/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import java.util.HashMap;
import java.util.Map;

import org.springframework.util.Assert;

/**
 * L[̑啶E𖳎nbV}bvłB
 * 
 * @param <V>
 */
@SuppressWarnings("serial")
public class CaseInsensitiveMap<V> extends HashMap<String, V> {
    public CaseInsensitiveMap() {
        super();
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveMap(Map<? extends String, ? extends V> m) {
        putAll(m);
    }

    @Override
    public boolean containsKey(Object key) {
        Assert.notNull(key);
        return super.containsKey(key.toString().toUpperCase());
    }

    @Override
    public V get(Object key) {
        Assert.notNull(key);
        return super.get(key.toString().toUpperCase());
    }

    @Override
    public V put(String key, V value) {
        Assert.notNull(key);
        return super.put(key.toUpperCase(), value);
    }

    @Override
    public V remove(Object key) {
        Assert.notNull(key);
        return super.remove(key.toString().toUpperCase());
    }
}
