/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

/**
 * {@link JdbcTemplate}bv[eBeBNXłB
 * 
 */
public class JdbcTemplateUtils {

    /**
     * CӂSQLs܂B<br />
     * DDLsꍇɎgp܂B
     * 
     * <pre>
     * 
     * execute(jdbcTemplate, &quot;create table foo(val integer, name varchar2(10))&quot;);
     * </pre>
     * 
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @throws DataAccessException
     */
    public static void execute(JdbcTemplate jdbcTemplate, String sql)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        jdbcTemplate.execute(sql);
    }

    /**
     * XVnSQLs܂B
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @return XV
     * @throws DataAccessException
     */
    public static int update(JdbcTemplate jdbcTemplate, String sql)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return jdbcTemplate.update(sql);
    }

    /**
     * XVnSQLs܂B({@link PreparedStatement}gp)
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @return XV
     * @throws DataAccessException
     */
    public static int update(JdbcTemplate jdbcTemplate, String sql,
            Object[] args) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return jdbcTemplate.update(sql, args);
    }

    /**
     * XVnSQLob`s܂B
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sqls
     *            ob`sSQL̔z
     * @return XVz
     * @throws DataAccessException
     */
    public static int[] batchUpdate(JdbcTemplate jdbcTemplate, String... sqls)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        Assert.notEmpty(sqls);
        return jdbcTemplate.batchUpdate(sqls);
    }

    /**
     * QƌnSQLslong^̌ʂԋp܂B<br>
     * ₢킹ʂꌏłKv܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val) values(100)&quot;);
     * queryForLong(jdbcTemplate, &quot;select val from foo&quot;); // -&gt; 100
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @return s
     * @throws DataAccessException
     */
    public static long queryForLong(JdbcTemplate jdbcTemplate, String sql)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return jdbcTemplate.queryForLong(sql);
    }

    /**
     * QƌnSQLslong^̌ʂԋp܂B({@link PreparedStatement}gp)<br>
     * ₢킹ʂꌏłKv܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val) values(100)&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val) values(10)&quot;);
     * queryForLong(jdbcTemplate, &quot;select val from foo where val < ?&quot;, new Object[]{50}); // -&gt; 10
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @return s
     * @throws DataAccessException
     */
    public static long queryForLong(JdbcTemplate jdbcTemplate, String sql,
            Object[] args) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return jdbcTemplate.queryForLong(sql, args);
    }

    /**
     * 
     * QƌnSQLsint^̌ʂԋp܂B<br>
     * ₢킹ʂꌏłKv܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val) values(100)&quot;);
     * queryForInt(jdbcTemplate, &quot;select val from foo&quot;); // -&gt; 100
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @return s
     * @throws DataAccessException
     */
    public static int queryForInt(JdbcTemplate jdbcTemplate, String sql)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return jdbcTemplate.queryForInt(sql);
    }

    /**
     * QƌnSQLsint^̌ʂԋp܂B({@link PreparedStatement}gp)<br>
     * ₢킹ʂꌏłKv܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val) values(100)&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val) values(10)&quot;);
     * queryForInt(jdbcTemplate, &quot;select val from foo where val < ?&quot;, new Object[]{50}); // -&gt; 10
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @return s
     * @throws DataAccessException
     */
    public static int queryForInt(JdbcTemplate jdbcTemplate, String sql,
            Object[] args) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return jdbcTemplate.queryForInt(sql, args);
    }

    /**
     * 
     * QƌnSQLsString^̌ʂԋp܂B<br>
     * ₢킹ʂꌏłKv܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample')&quot;);
     * queryForString(jdbcTemplate, &quot;select name from foo&quot;); // -&gt; Sample
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @return s
     * @throws DataAccessException
     */
    public static String queryForString(JdbcTemplate jdbcTemplate, String sql)
            throws DataAccessException {
        return JdbcTemplateUtils.<String> queryForObject(jdbcTemplate, sql,
                String.class);
    }

    /**
     * QƌnSQLsint^̌ʂԋp܂B({@link PreparedStatement}gp)<br>
     * ₢킹ʂꌏłKv܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForInt(jdbcTemplate, &quot;select name from foo where val < ?&quot;, new Object[]{50}); // -&gt; Sample2
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @return s
     * @throws DataAccessException
     */
    public static String queryForString(JdbcTemplate jdbcTemplate, String sql,
            Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.<String> queryForObject(jdbcTemplate, sql,
                args, String.class);
    }

    /**
     * QƌnSQLsw肵^̌ʂԋp܂B<br>
     * ₢킹ʂꌏłKv܂B
     * 
     * @param <T>
     *            ԋpľ^ ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param requiredType
     *            ԋpľ^ ԋpľ^
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> T queryForObject(JdbcTemplate jdbcTemplate, String sql,
            Class<T> requiredType) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return (T) jdbcTemplate.queryForObject(sql, requiredType);
    }

    /**
     * QƌnSQLsw肵^̌ʂԋp܂B<br>
     * ₢킹ʂꌏłKv܂B
     * 
     * @param <T>
     *            ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @param requiredType
     *            ԋpľ^
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> T queryForObject(JdbcTemplate jdbcTemplate, String sql,
            Object[] args, Class<T> requiredType) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return (T) jdbcTemplate.queryForObject(sql, args, requiredType);
    }

    /**
     * QƌnSQLs1šʂi[{@link Map}ԋp܂B<br>
     * ₢킹ʂꌏłKv܂B<br>
     * Ԃl{@link Map}̃L[͑啶E𖳎܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample')&quot;);
     * queryForRowMap(jdbcTemplate, &quot;select val, name from foo&quot;); // -&gt; {VAL=100, NAME=Sample}
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static Map<String, ?> queryForRowMap(JdbcTemplate jdbcTemplate,
            String sql) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        Map<String, ?> result = jdbcTemplate.queryForMap(sql);
        return new CaseInsensitiveMap<Object>(result);
    }

    /**
     * QƌnSQLs1šʂi[{@link Map}ԋp܂B({@link PreparedStatement}gp)<br>
     * ₢킹ʂꌏłKv܂B<br>
     * Ԃl{@link Map}̃L[͑啶E𖳎܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForRowMap(jdbcTemplate, &quot;select val from foo where val < ?&quot;, new Object[]{50}); // -&gt; {VAL=10, NAME=Sample2}
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static Map<String, ?> queryForRowMap(JdbcTemplate jdbcTemplate,
            String sql, Object[] args) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        Map<String, ?> result = jdbcTemplate.queryForMap(sql, args);
        return new CaseInsensitiveMap<Object>(result);
    }

    /**
     * QƌnSQLs1šʂT^̃IuWFNgɃ}bsOĕԋp܂B<br>
     * ₢킹ʂꌏłKv܂B<br>
     * <strong>Spring̃o[W2.5ȏłKv܂B</strong>
     * 
     * 
     * <pre>
     * 
     * public class Foo {
     *   private int val;
     *   private String name;
     *   // setter/getter
     * }
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample')&quot;);
     * queryForRowObject(jdbcTemplate, &quot;select val, name from foo&quot;, Foo.class); // -&gt; Foo{val=100, name=Sample}
     * </pre>
     * 
     * @param <T>
     *            ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param clazz
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> T queryForRowObject(JdbcTemplate jdbcTemplate,
            String sql, Class<T> clazz) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        RowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return (T) jdbcTemplate.queryForObject(sql, rowMapper);
    }

    /**
     * QƌnSQLs1šʂT^̃IuWFNgɃ}bsOĕԋp܂B({@link PreparedStatement}gp)<br>
     * ₢킹ʂꌏłKv܂B<br>
     * <strong>Spring̃o[W2.5ȏłKv܂B</strong>
     * 
     * <pre>
     * 
     * public class Foo {
     *   private int val;
     *   private String name;
     *   // setter/getter
     * }
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForRowObject(jdbcTemplate, &quot;select val from foo where val < ?&quot;, new Object[]{50}, Foo.class); // -&gt; Foo{val=10, name=Sample2}
     * </pre>
     * 
     * 
     * @param <T>
     *            ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @param clazz
     *            ԋpľ^
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> T queryForRowObject(JdbcTemplate jdbcTemplate,
            String sql, Object[] args, Class<T> clazz)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        RowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return (T) jdbcTemplate.queryForObject(sql, args, rowMapper);
    }

    /**
     * QƌnSQLs1񕪂̌ʂT^ŕԋp܂B<br>
     * ₢킹ʂłKv܂B<br>
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForSingleColumnList(jdbcTemplate, &quot;select val from foo&quot;, Integer.class);
     * // -&gt; [100, 10]
     * </pre>
     * 
     * @param <T>
     *            ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param elementType
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> List<T> queryForSingleColumnList(
            JdbcTemplate jdbcTemplate, String sql, Class<T> elementType)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return jdbcTemplate.queryForList(sql, elementType);
    }

    /**
     * QƌnSQLs1񕪂̌ʂT^ŕԋp܂B({@link PreparedStatement}gp)<br>
     * ₢킹ʂłKv܂B<br>
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForSingleColumnList(jdbcTemplate, &quot;select name from foo where val &gt; ?&quot;,
     *         new Object[] { 0 }, String.class);
     * // -&gt; [Sample1, Sample2]
     * </pre>
     * 
     * @param <T>
     *            ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @param elementType
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> List<T> queryForSingleColumnList(
            JdbcTemplate jdbcTemplate, String sql, Object[] args,
            Class<T> elementType) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return jdbcTemplate.queryForList(sql, args, elementType);
    }

    /**
     * Map̃XgL[啶Mapɕϊĕԋp܂B
     * 
     * @param list
     *            Map̃Xg
     * @return s
     */
    @SuppressWarnings("unchecked")
    private static List<Map<String, ?>> convertToCaseInsensitiveMapList(
            List<?> list) {
        List<Map<String, ?>> result = new ArrayList<Map<String, ?>>();
        if (list != null) {
            for (Object o : list) {
                result.add(new CaseInsensitiveMap<Object>((Map<String, ?>) o));
            }
        }
        return result;
    }

    /**
     * QƌnSQLsešʂi[{@link Map}̃Xgԋp܂B
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForRowMapList(jdbcTemplate, &quot;select val, name from foo&quot;);
     * // -&gt; [{VAL=100, NAME=Sample1}, {VAL=10, NAME=Sample2}]
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @return s
     * @throws DataAccessException
     */
    public static List<Map<String, ?>> queryForRowMapList(
            JdbcTemplate jdbcTemplate, String sql) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return convertToCaseInsensitiveMapList(jdbcTemplate.queryForList(sql));
    }

    /**
     * QƌnSQLsešʂi[{@link Map}̃Xgԋp܂B({@link PreparedStatement}gp)
     * 
     * <pre>
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForRowMapList(jdbcTemplate, &quot;select val, name from foo where val &gt; ?&quot;,
     *         new Object[] { 0 });
     * // -&gt; [{VAL=100, NAME=Sample1}, {VAL=10, NAME=Sample2}]
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @return s
     * @throws DataAccessException
     */
    public static List<Map<String, ?>> queryForRowMapList(
            JdbcTemplate jdbcTemplate, String sql, Object[] args)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return convertToCaseInsensitiveMapList(jdbcTemplate.queryForList(sql,
                args));
    }

    /**
     * w肵^̃tB[h񂩂QSQL(StB[hQ)𐶐ĎsAešʂi[{@link Map}̃Xgԋp܂B <br>
     * SQL{@link #createSelectSql(Class)}萶܂B
     * 
     * <pre>
     * 
     * public class Foo {
     *   private int val;
     *   private String name;
     *   // setter/getter
     * }
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForRowMapList(jdbcTemplate, Foo.class);
     * // -&gt; [{VAL=100, NAME=Sample1}, {VAL=10, NAME=Sample2}]
     * </pre>
     * 
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param clazz
     *            ԋpľ^
     * @return s
     * @throws DataAccessException
     */
    public static List<Map<String, ?>> queryForRowMapList(
            JdbcTemplate jdbcTemplate, Class<?> clazz)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        return convertToCaseInsensitiveMapList(jdbcTemplate
                .queryForList(createSelectSql(clazz)));
    }

    /**
     * QƌnSQLsešʂT^Ƀ}bsOĊi[Xgԋp܂B<br>
     * <strong>Spring̃o[W2.5ȏłKv܂B</strong>
     * 
     * <pre>
     * 
     * public class Foo {
     *   private int val;
     *   private String name;
     *   // setter/getter
     * }
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForRowOnjectList(jdbcTemplate, &quot;select val, name from foo&quot;, Foo.class);
     * // -&gt; [Foo{val=100, name=Sample1}, Foo{val=10, name=Sample2}]
     * </pre>
     * 
     * 
     * @param <T>
     *            ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param clazz
     *            ԋpľ^
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> List<T> queryForRowObjectList(JdbcTemplate jdbcTemplate,
            String sql, Class<T> clazz) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        RowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return jdbcTemplate.query(sql, rowMapper);
    }

    /**
     * QƌnSQLsešʂT^Ƀ}bsOĊi[Xgԋp܂B({@link PreparedStatement}gp)<br>
     * <strong>Spring̃o[W2.5ȏłKv܂B</strong>
     * 
     * <pre>
     * 
     * public class Foo {
     *   private int val;
     *   private String name;
     *   // setter/getter
     * }
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForRowOnjectList(jdbcTemplate, &quot;select val, name from foo where val > ?&quot;, new Object[] {0}, Foo.class);
     * // -&gt; [Foo{val=100, name=Sample1}, Foo{val=10, name=Sample2}]
     * </pre>
     * 
     * @param <T>
     *            ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param sql
     *            sSQL
     * @param args
     *            vyAhXe[gg̃p[^
     * @param clazz
     *            ԋpľ^
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> List<T> queryForRowObjectList(JdbcTemplate jdbcTemplate,
            String sql, Object[] args, Class<T> clazz)
            throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        RowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return jdbcTemplate.query(sql, args, rowMapper);
    }

    /**
     * w肵^̃tB[h񂩂QSQL(StB[hQ)𐶐ĎsAešʂT^̃IuWFNgɃ}bsOăXgԋp܂B <br>
     * SQL{@link #createSelectSql(Class)}萶܂B
     * <strong>Spring̃o[W2.5ȏłKv܂B</strong>
     * 
     * <pre>
     * 
     * public class Foo {
     *   private int val;
     *   private String name;
     *   // setter/getter
     * }
     * 
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(100, 'Sample1')&quot;);
     * upate(jdbcTemplate, &quot;insert into foo (val, name) values(10, 'Sample2')&quot;);
     * queryForRowOnjectList(jdbcTemplate, Foo.class);
     * // -&gt; [Foo{val=100, name=Sample1}, Foo{val=10, name=Sample2}]
     * </pre>
     * 
     * @param <T>
     *            ԋpľ^
     * @param jdbcTemplate
     *            JdbcTemplate
     * @param clazz
     *            ԋpľ^
     * @return s
     * @throws DataAccessException
     */
    @SuppressWarnings("unchecked")
    public static <T> List<T> queryForRowObjectList(JdbcTemplate jdbcTemplate,
            Class<T> clazz) throws DataAccessException {
        Assert.notNull(jdbcTemplate);
        Assert.notNull(clazz);
        String[] header = ReflectionUtils.createFiledNames(clazz);
        String sql = createSelectSql(clazz.getSimpleName(), header);
        RowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return jdbcTemplate.query(sql, rowMapper);
    }

    /**
     * w肵tB[hSĎQƂSELECT𐶐܂B
     * 
     * <pre>
     * 
     * createSelectSql("foo", new String[] {"val", "name"}); // SELECT val,name FROM foo
     * </pre>
     * 
     * @param tableName
     *            e[u
     * @param fieldNames
     *            tB[h
     * @return SQL
     */
    public static String createSelectSql(String tableName, String[] fieldNames) {
        Assert.notNull(tableName);
        Assert.notNull(fieldNames);
        String sql = "SELECT " + StringUtils.join(fieldNames, ",") + " FROM "
                + tableName;
        return sql;
    }

    /**
     * w肵NX̎tB[hSĎQƂSELECT𐶐܂B
     * 
     * <pre>
     * 
     * public class Foo {
     *     private int val;
     *     private String name;
     *     // setter/getter
     * }
     * 
     * createSelectSql("foo", Foo.clas); // -> SELECT val,name FROM foo
     * </pre>
     * 
     * @param tableName
     *            e[u
     * @param clazz
     *            NX
     * @return SQL
     */
    public static String createSelectSql(String tableName, Class<?> clazz) {
        Assert.notNull(clazz);
        return createSelectSql(tableName,
                ReflectionUtils.createFiledNames(clazz));
    }

    /**
     * w肵NX̎tB[hSĎQƂSELECT𐶐܂Be[u̓NXɂȂ܂B
     * 
     * <pre>
     * 
     * public class Foo {
     *     private int val;
     *     private String name;
     *     // setter/getter
     * }
     * 
     * createSelectSql(Foo.clas); // -> SELECT val,name FROM Foo
     * </pre>
     * 
     * @param clazz
     *            NX
     * @return SQL
     */
    public static String createSelectSql(Class<?> clazz) {
        Assert.notNull(clazz);
        return createSelectSql(clazz.getSimpleName(), clazz);
    }

    /**
     * w肵tB[hSĐݒ肷INSERT𐶐܂B
     * 
     * <pre>
     * 
     * createInsertSql("foo", new String[] {"val", "name"}); // INSERT INTO foo (val,name) VALUES(?,?)
     * </pre>
     * 
     * @param tableName
     *            e[u
     * @param fieldNames
     *            tB[h
     * @return SQL
     */
    public static String createInsertSql(String tableName, String[] fieldNames) {
        Assert.notNull(tableName);
        Assert.notNull(fieldNames);

        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tableName);
        sb.append("(");
        sb.append(StringUtils.join(fieldNames, ","));
        sb.append(") VALUES (");
        for (int i = 0; i < fieldNames.length; i++) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    /**
     * w肵NX̎tB[hSĐݒ肷INSERT𐶐܂B
     * 
     * <pre>
     * 
     * createInsertSql("foo", Foo.class); // INSERT INTO foo (val,name) VALUES(?,?)
     * </pre>
     * 
     * @param tableName
     *            e[u
     * @param clazz
     *            NX
     * @return SQL
     */
    public static String createInsertSql(String tableName, Class<?> clazz) {
        return createInsertSql(tableName,
                ReflectionUtils.createFiledNames(clazz));
    }

    /**
     * w肵NX̎tB[hSĐݒ肷INSERT𐶐܂Be[u̓NXɂȂ܂B
     * 
     * <pre>
     * 
     * createInsertSql(Foo.class); // INSERT INTO Foo (val,name) VALUES(?,?)
     * </pre>
     * 
     * @param clazz
     *            NX
     * @return SQL
     */
    public static String createInsertSql(Class<?> clazz) {
        Assert.notNull(clazz);
        return createInsertSql(clazz.getSimpleName(),
                ReflectionUtils.createFiledNames(clazz));
    }
}
