/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

import jp.terasoluna.fw.ex.unit.exception.ReflectionFailedException;
import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

/**
 * privateCq̃tB[hɃANZX胁\bh̎ss[eBeB
 */
public class ReflectionUtils {
    /**
     * Class\NX̐VCX^X𐶐܂B<br>
     * vCx[gȃRXgN^ꍇłCX^X𐶐ł܂B<br>
     * ̃\bhł̓RXgN^Ȃ̂s܂B
     * 
     * @param clazz
     *            ΏۃNX
     * @return NX̃CX^X
     * @throws ReflectionFailedException
     *             CX^X̐ɗOꍇ
     */
    public static <T> T newInstance(Class<T> clazz) {
        Assert.notNull(clazz);
        try {
            Constructor<T> c = clazz.getDeclaredConstructor();
            c.setAccessible(true);
            return c.newInstance();
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * Class\NX̐VCX^X𐶐܂B<br>
     * vCx[gȃRXgN^ꍇłCX^X𐶐ł܂B<br>
     * ̃\bhł̓RXgN^argsClassesƈv̂s܂B
     * 
     * @param clazz
     *            ΏۃNX
     * @param argClasses
     *            RXgN^̈̌^z
     * @param args
     *            RXgN^̈
     * @return NX̃CX^X
     * @throws ReflectionFailedException
     *             CX^X̐ɗOꍇ
     */
    public static <T> T newInstance(Class<T> clazz, Class<?>[] argClasses,
            Object[] args) {
        Assert.notNull(clazz);
        try {
            Constructor<T> c = clazz.getDeclaredConstructor(argClasses);
            c.setAccessible(true);
            return c.newInstance(args);
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * ΏۃIuWFNg̃NX̎w肳ꂽtB[h̒lԂ܂B
     * 
     * @param obj
     *            ΏۃIuWFNg
     * @param name
     *            擾tB[h̖O
     * @return tB[hl
     * @throws ReflectionFailedException
     *             tB[hIuWFNg擾ɗOꍇ
     */
    @SuppressWarnings("unchecked")
    public static <T> T getField(Object obj, String name) {
        Assert.notNull(obj);
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return (T) field.get(obj);
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * ΏClass\NX܂̓C^tF[X̎w肳ꂽtB[h̒lԂ܂B
     * 
     * @param clazz
     *            ΏۃNX
     * @param name
     *            擾tB[h̖O
     * @return tB[hl
     * @throws ReflectionFailedException
     *             tB[hIuWFNg擾ɗOꍇ
     */
    @SuppressWarnings("unchecked")
    public static <T> T getField(Class<?> clazz, String name) {
        Assert.notNull(clazz);
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return (T) field.get(null);
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * ΏۃIuWFNg̃NX̎w肳ꂽtB[h̒lύX܂B<br>
     * finalȃtB[hɑ΂Ă͕ύXł܂B<br
     * finalȃtB[hɒlݒ肵ĂO͔A{@link #getField(Object, String)}ɂĎ擾\łA<br>
     * Ώۂ̃IuWFNg̃tB[hl͕̂ς܂(getterŎ擾ꍇAݒO̒lԋp܂B)
     * 
     * @param obj
     *            ΏۃIuWFNg
     * @param name
     *            ύXtB[h̖O
     * @param value
     *            ύXl
     * @throws ReflectionFailedException
     *             tB[hIuWFNg擾ɗOꍇ
     */
    public static void setField(Object obj, String name, Object value) {
        Assert.notNull(obj);
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(obj, value);
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * ΏClass\NX܂̓C^tF[X̎w肳ꂽtB[h̒lύX܂B<br>
     * finalȃtB[hɑ΂Ă͕ύXł܂B<br>
     * finalȃtB[hɒlݒ肷{@link UTRuntimeException}܂B
     * 
     * @param clazz
     *            ΏۃNX
     * @param name
     *            擾tB[h̖O
     * @param value
     *            ύXl
     * @throws ReflectionFailedException
     *             tB[hIuWFNg擾ɗOꍇ
     */
    public static void setField(Class<?> clazz, String name, Object value) {
        Assert.notNull(clazz);
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            field.set(null, value);
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * w肵IuWFNgɑ΂Ďw肵p[^Ŏw肵Õ\bhĂяo܂B
     * 
     * @param obj
     *            {ƂȂ郁\bȟĂяõIuWFNg
     * @param methodName
     *            \bh̖O
     * @param parameterTypes
     *            p[^z
     * @param args
     *            \bhĂяoɎgp
     * @return \bhAp[^ args gp obj ɃfBXpb`
     * @throws ReflectionFailedException
     *             \bh̎擾܂͎sɗOꍇ
     */
    @SuppressWarnings("unchecked")
    public static <T> T invoke(Object obj, String methodName,
            Class<?>[] parameterTypes, Object[] args) {
        Assert.notNull(obj);
        try {
            Method method = obj.getClass().getDeclaredMethod(methodName,
                    parameterTypes);
            method.setAccessible(true);
            return (T) method.invoke(obj, args);
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * w肵IuWFNgɑ΂Ďw肵Õ\bhĂяo܂B<br>
     * Õ\bhꍇɂ̓\bh1CӂŌĂяo܂
     * 
     * @param obj
     *            {ƂȂ郁\bȟĂяõIuWFNg
     * @param methodName
     *            \bh̖O
     * @return \bhAobj ɃfBXpb`
     * @throws ReflectionFailedException
     *             \bh̎擾܂͎sɗOꍇ
     */
    public static <T> T invoke(Object obj, String methodName) {
        return ReflectionUtils.<T> invoke(obj, methodName, new Class<?>[] {},
                new Object[] {});
    }

    /**
     * w肵NXɑ΂Ďw肵p[^Ŏw肵Õ\bhĂяo܂B<br>
     * Ăяo\bhstaticłKv܂B
     * 
     * @param clazz
     *            {ƂȂ郁\bȟĂяõNX
     * @param methodName
     *            \bh̖O
     * @param parameterTypes
     *            p[^z
     * @param args
     *            \bhĂяoɎgp
     * @return \bhAp[^ args gp obj ɃfBXpb`
     * @throws ReflectionFailedException
     *             \bh̎擾܂͎sɗOꍇ
     */
    @SuppressWarnings("unchecked")
    public static <T> T invoke(Class<?> clazz, String methodName,
            Class<?>[] parameterTypes, Object[] args) {
        Assert.notNull(clazz);
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return (T) method.invoke(null, args);
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * w肵NXɑ΂Ďw肵p[^Ŏw肵Õ\bhĂяo܂B<br>
     * Ăяo\bhstaticłKv܂B
     * 
     * @param clazz
     *            {ƂȂ郁\bȟĂяõNX
     * @param methodName
     *            \bh̖O
     * 
     * @return \bhAp[^ args gp obj ɃfBXpb`
     * @throws ReflectionFailedException
     *             \bh̎擾܂͎sɗOꍇ
     */
    @SuppressWarnings("unchecked")
    public static <T> T invoke(Class<?> clazz, String methodName) {
        Assert.notNull(clazz);
        try {
            Method method = clazz.getDeclaredMethod(methodName,
                    new Class<?>[] {});
            method.setAccessible(true);
            return (T) method.invoke(null, new Object[] {});
        } catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    /**
     * NX̃tB[h擾B<br>
     * 
     * <pre>
     * eNX̃tB[h擾łBstaticȃtB[h̖O͎擾ȂB
     * </pre>
     * 
     * @param clazz
     *            ΏۃNX
     * @return tB[hꗗz
     */
    public static String[] createFiledNames(Class<?> clazz) {
        Assert.notNull(clazz);

        BeanWrapper beanWrapper = new BeanWrapperImpl(clazz);
        PropertyDescriptor[] descs = beanWrapper.getPropertyDescriptors();

        String[] fieldNames = new String[descs.length - 1]; // class͏

        for (int i = 0, j = 0; i < descs.length; i++) {
            String name = descs[i].getName();
            if (!"class".equals(name)) {
                fieldNames[j++] = name;
            }
        }

        return fieldNames;
    }

    public static Class<?>[] classes(Class<?>... classes) {
        return classes;
    }

    public static Object[] args(Object... args) {
        return args;
    }

}
