/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.action.ActionMapping;

public class DefaultFlowCallbackInfoFactoryTest extends TestCase {

    public DefaultFlowCallbackInfoFactoryTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testCreateFlowCallbackInfo01B
     * EDefaultFlowCallbackInfoCX^XԂƂmFB
     * EԂꂽDefaultFlowCallbackInfoflowInvokeActionMappingtB[hɁAŗ^FlowInvokeActionMappingi[Ă邱ƂmFB
     */
    public void testCreateFlowCallbackInfo01() throws Exception {
        DefaultFlowCallbackInfoFactory factory = new DefaultFlowCallbackInfoFactory();
        ActionMapping mapping = new FlowInvokeActionMapping();
        
        FlowCallbackInfo callBackInfo = factory.createFlowCallbackInfo(mapping, null, null, null);
        
        assertNotNull(callBackInfo);
        assertTrue(callBackInfo instanceof DefaultFlowCallbackInfo);
        assertSame(mapping, UTUtil.getPrivateField(callBackInfo, "flowInvokeActionMapping"));
    }

}
