/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.ex.web.struts.action.DefaultFlowCallbackInfo;
import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfo;
import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfoFactory;
import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfoMapping;
import jp.terasoluna.fw.ex.web.struts.action.FlowInvokeActionMapping;
import jp.terasoluna.fw.ex.web.struts.action.FlowInvokeActionMappingExtendPropertyHolder;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import junit.framework.TestCase;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.impl.ModuleConfigImpl;

public class FlowInvokeActionTest extends TestCase {

    public FlowInvokeActionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoExecute01B
     * ʉʃt[߂Ăۂ̏̃eXg(n)B
     * ENGXgFlowTerminateAction.TERMINAL_KEYݒ肳ĂāA
     *   ̒lL[ɁAANV}bsOfindForwardłꍇA
     *   YActionForwardԂ邱ƂmFB
     * ENGXgFlowTerminateAction.TERMINAL_KEY폜邱ƂmFB
     */
    public void testDoExecute01() throws Exception {
        FlowInvokeAction action = new FlowInvokeAction();
        ActionForward forward0 = new ActionForward("success", "/aaa.do", false);
        ActionForward forward1 = new ActionForward("Final01", "/xxx.do", false);
        ActionForward forward2 = new ActionForward("Final02", "/yyy.do", false);
        ActionMapping mapping = new FlowInvokeActionMapping();
        mapping.addForwardConfig(forward0);
        mapping.addForwardConfig(forward1);
        mapping.addForwardConfig(forward2);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute(FlowTerminateAction.TERMINAL_KEY, "Final01");
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        ActionForward result = action.doExecute(mapping, null, request, response);
        
        assertSame(forward1, result);
        assertNull(request.getAttribute(FlowTerminateAction.TERMINAL_KEY));
    }

    /**
     * testDoExecute02B
     * ʉʃt[߂Ăۂ̏̃eXg(ُn)B
     * ENGXgFlowTerminateAction.TERMINAL_KEYݒ肳ĂāA
     *   ̒lL[ɁAANV}bsOfindForwardłȂꍇA
     *   FlowTerminateFailureExceptionX[邱ƂmFB
     * ENGXgFlowTerminateAction.TERMINAL_KEY폜邱ƂmFB
     */
    public void testDoExecute02() throws Exception {
        FlowInvokeAction action = new FlowInvokeAction();
        ActionForward forward0 = new ActionForward("success", "/aaa.do", false);
        ActionForward forward1 = new ActionForward("Final01", "/xxx.do", false);
        ActionForward forward2 = new ActionForward("Final02", "/yyy.do", false);
        ModuleConfigImpl moduleConfig = new ModuleConfigImpl("/mod01");
        ActionMapping mapping = new FlowInvokeActionMapping();
        mapping.setPath("/path01");
        mapping.setModuleConfig(moduleConfig);
        mapping.addForwardConfig(forward0);
        mapping.addForwardConfig(forward1);
        mapping.addForwardConfig(forward2);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute(FlowTerminateAction.TERMINAL_KEY, "Final03");
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        try {
            action.doExecute(mapping, null, request, response);
            fail();
        } catch (FlowTerminateFailureException e) {
            assertEquals("Failed to find ActionForward(name=\"Final03\") in ActionMapping(path=\"/path01\", module=\"/mod01\").", e.getMessage());
        }
    }

    /**
     * testDoExecute03B
     * ꂩ狤ʉʃt[ɓۂ̏̃eXg(n)B
     * ENGXgFlowTerminateAction.TERMINAL_KEYݒ肳Ă炸A
     *   ܂Aݒ蓙ȂꍇAFlowCallbackInfoAZbVFlowCallbackInfoMappingɓo^邱ƂmFB
     * EZbVFlowCallbackInfoMappingꍇɁAFlowCallbackInfoMapping邱ƂmFB
     * E"success"ActionForwardԂ邱ƂmFB
     */
    public void testDoExecute03() throws Exception {
        FlowInvokeAction action = new FlowInvokeAction();
        ActionForward forward0 = new ActionForward("success", "/aaa.do", false);
        ActionForward forward1 = new ActionForward("Final01", "/xxx.do", false);
        ActionForward forward2 = new ActionForward("Final02", "/yyy.do", false);
        FlowInvokeActionMapping mapping = new FlowInvokeActionMapping();
        mapping.addForwardConfig(forward0);
        mapping.addForwardConfig(forward1);
        mapping.addForwardConfig(forward2);
        mapping.setDestinationFlow("flow1");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        final DefaultFlowCallbackInfo callBackInfo = new DefaultFlowCallbackInfo(mapping);
        FlowCallbackInfoFactory callBackInfoFactory = new FlowCallbackInfoFactory() {
            public FlowCallbackInfo createFlowCallbackInfo(
                    ActionMapping flowInvokeActionMapping, ActionForm form,
                    HttpServletRequest request, HttpServletResponse response) {
                return callBackInfo;
            }
        };
        action.setFlowCallbackInfoFactory(callBackInfoFactory);
        
        ActionForward result = action.doExecute(mapping, null, request, response);
        
        FlowCallbackInfoMapping callBackInfoMapping = (FlowCallbackInfoMapping) request.getSession().getAttribute(FlowCallbackInfoMapping.class.getName());
        assertNotNull(callBackInfoMapping);
        assertSame(callBackInfo, callBackInfoMapping.findFlowCallbackInfo("flow1"));
        assertSame(forward0, result);
    }

    /**
     * testDoExecute04B
     * ꂩ狤ʉʃt[ɓۂ̏̃eXg(n)B
     * ENGXgFlowTerminateAction.TERMINAL_KEYݒ肳Ă炸A
     *   ܂Aݒ蓙ȂꍇAFlowCallbackInfoAZbVFlowCallbackInfoMappingɓo^邱ƂmFB
     * EZbVFlowCallbackInfoMappingꍇAFlowCallbackInfoMappingFlowCallbackInfoo^邱ƂmFB
     *   (̏񂪈ێĂ邱ƂmFB)
     * E"success"ActionForwardԂ邱ƂmFB
     */
    public void testDoExecute04() throws Exception {
        FlowInvokeAction action = new FlowInvokeAction();
        ActionForward forward0 = new ActionForward("success", "/aaa.do", false);
        ActionForward forward1 = new ActionForward("Final01", "/xxx.do", false);
        ActionForward forward2 = new ActionForward("Final02", "/yyy.do", false);
        FlowInvokeActionMapping mapping = new FlowInvokeActionMapping();
        mapping.addForwardConfig(forward0);
        mapping.addForwardConfig(forward1);
        mapping.addForwardConfig(forward2);
        mapping.setDestinationFlow("flow1");
        MockHttpServletRequest request = new MockHttpServletRequest();
        FlowCallbackInfoMapping callBackInfoMapping0 = new FlowCallbackInfoMapping();
        DefaultFlowCallbackInfo callBackInfo0 = new DefaultFlowCallbackInfo(new FlowInvokeActionMapping());
        callBackInfoMapping0.registerFlowCallbackInfo("flow0", callBackInfo0);
        request.getSession().setAttribute(FlowCallbackInfoMapping.class.getName(), callBackInfoMapping0);
        MockHttpServletResponse response = new MockHttpServletResponse();
        final DefaultFlowCallbackInfo callBackInfo = new DefaultFlowCallbackInfo(mapping);
        FlowCallbackInfoFactory callBackInfoFactory = new FlowCallbackInfoFactory() {
            public FlowCallbackInfo createFlowCallbackInfo(
                    ActionMapping flowInvokeActionMapping, ActionForm form,
                    HttpServletRequest request, HttpServletResponse response) {
                return callBackInfo;
            }
        };
        action.setFlowCallbackInfoFactory(callBackInfoFactory);
        
        ActionForward result = action.doExecute(mapping, null, request, response);
        
        FlowCallbackInfoMapping callBackInfoMapping = (FlowCallbackInfoMapping) request.getSession().getAttribute(FlowCallbackInfoMapping.class.getName());
        assertSame(callBackInfoMapping0, callBackInfoMapping);
        assertSame(callBackInfo0, callBackInfoMapping.findFlowCallbackInfo("flow0"));
        assertSame(callBackInfo, callBackInfoMapping.findFlowCallbackInfo("flow1"));
        assertSame(forward0, result);
    }

    /**
     * testDoExecute05B
     * ꂩ狤ʉʃt[ɓۂ̏̃eXg(ُn)B
     * ENGXgFlowTerminateAction.TERMINAL_KEYݒ肳Ă炸A
     *   ܂AANV}bsOFlowInvokeActionMappingExtendPropertyHolderC^tF[XĂȂƂA
     *   IllegalArgumentExceptionX[邱ƂmFB
     */
    public void testDoExecute05() throws Exception {
        FlowInvokeAction action = new FlowInvokeAction();
        ActionMapping mapping = new ActionMappingEx();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        try {
            action.doExecute(mapping, null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("Argument mapping must be an instance of "
                    + FlowInvokeActionMapping.class.getName()
                    + " or "
                    + FlowInvokeActionMappingExtendPropertyHolder.class
                            .getName() + ".", e.getMessage());
        }
    }

    /**
     * testDoExecute06B
     * ꂩ狤ʉʃt[ɓۂ̏̃eXg(ُn)B
     * ENGXgFlowTerminateAction.TERMINAL_KEYݒ肳Ă炸A
     *   ܂AANV}bsOdestinationFloŵƂA
     *   IllegalArgumentExceptionX[邱ƂmFB
     */
    public void testDoExecute06() throws Exception {
        FlowInvokeAction action = new FlowInvokeAction();
        FlowInvokeActionMapping mapping = new FlowInvokeActionMapping();
        mapping.setDestinationFlow("");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        try {
            action.doExecute(mapping, null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("The value of destinationFlow at "
                    + mapping.getClass().getName() + " must be specified.", e
                    .getMessage());
        }
    }

}
