/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfo;
import jp.terasoluna.fw.ex.web.struts.action.FlowCallbackInfoMapping;
import jp.terasoluna.fw.ex.web.struts.action.FlowTerminateActionMapping;
import jp.terasoluna.fw.ex.web.struts.action.FlowTerminateActionMappingExtendPropertyHolder;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import junit.framework.TestCase;

public class FlowTerminateActionTest extends TestCase {

    public FlowTerminateActionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoExecute01B
     * EZbVFlowCallbackInfoMappingi[ĂA
     *   FlowCallbackInfoMappingɁAcurrentFlowɊYFlowCallbackInfoi[ĂꍇA
     *   FlowCallbackInfo擾ActionForwardԂ邱ƂmFB
     * ENGXgFlowTerminateAction.TERMINAL_KEYɁAterminal̒lݒ肳邱ƂmFB
     */
    public void testDoExecute01() throws Exception {
        FlowTerminateAction action = new FlowTerminateAction();
        FlowTerminateActionMapping mapping = new FlowTerminateActionMapping();
        mapping.setCurrentFlow("flow1");
        mapping.setTerminal("Final01");
        final ActionForward forward1 = new ActionForward();
        FlowCallbackInfo callBackInfo = new FlowCallbackInfo() {
            public ActionForward getActionForward(
                    ActionMapping flowTerminateActionMapping, ActionForm form,
                    HttpServletRequest request, HttpServletResponse response) {
                return forward1;
            }
        };
        FlowCallbackInfoMapping callBackInfoMapping = new FlowCallbackInfoMapping();
        callBackInfoMapping.registerFlowCallbackInfo("flow1", callBackInfo);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute(FlowCallbackInfoMapping.class.getName(), callBackInfoMapping);
        MockHttpServletResponse response = new MockHttpServletResponse();

        ActionForward result = action.doExecute(mapping, null, request, response);
        
        assertSame(forward1, result);
        assertEquals("Final01", request.getAttribute(FlowTerminateAction.TERMINAL_KEY));
    }

    /**
     * testDoExecute02B
     * EANV}bsOFlowTerminateActionMappingExtendPropertyHolderC^tF[XĂȂƂA
     *   IllegalArgumentExceptionX[邱ƂmFB
     */
    public void testDoExecute02() throws Exception {
        FlowTerminateAction action = new FlowTerminateAction();
        ActionMapping mapping = new ActionMappingEx();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        try {
            action.doExecute(mapping, null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("Argument mapping must be an instance of "
                    + FlowTerminateActionMapping.class.getName()
                    + " or "
                    + FlowTerminateActionMappingExtendPropertyHolder.class
                            .getName() + ".", e.getMessage());
        }
    }

    /**
     * testDoExecute03B
     * EcurrentFloŵƂAIllegalArgumentExceptionX[邱ƂmFB
     */
    public void testDoExecute03() throws Exception {
        FlowTerminateAction action = new FlowTerminateAction();
        FlowTerminateActionMapping mapping = new FlowTerminateActionMapping();
        mapping.setCurrentFlow("");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        try {
            action.doExecute(mapping, null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("The value of currentFlow at "
                    + mapping.getClass().getName() + " must be specified.", e
                    .getMessage());
        }
    }

    /**
     * testDoExecute04B
     * EZbVFlowCallbackInfoMapping擾łȂƂA
     *   FlowTerminateFailureExceptionX[邱ƂmFB
     */
    public void testDoExecute04() throws Exception {
        FlowTerminateAction action = new FlowTerminateAction();
        FlowTerminateActionMapping mapping = new FlowTerminateActionMapping();
        mapping.setCurrentFlow("flow1");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        try {
            action.doExecute(mapping, null, request, response);
            fail();
        } catch (FlowTerminateFailureException e) {
            assertEquals("Failed to find FlowCallbackInfoMapping in session. Session attribute name is \""
                    + FlowCallbackInfoMapping.class.getName() + "\".",
                    e.getMessage());
        }
    }

    /**
     * testDoExecute05B
     * EFlowCallbackInfoMappingɁAcurrentFlowɊYFlowCallbackInfoi[ĂȂƂA
     *   FlowTerminateFailureExceptionX[邱ƂmFB
     */
    public void testDoExecute05() throws Exception {
        FlowTerminateAction action = new FlowTerminateAction();
        FlowTerminateActionMapping mapping = new FlowTerminateActionMapping();
        mapping.setCurrentFlow("flow2");
        final ActionForward forward1 = new ActionForward();
        FlowCallbackInfo callBackInfo = new FlowCallbackInfo() {
            public ActionForward getActionForward(
                    ActionMapping flowTerminateActionMapping, ActionForm form,
                    HttpServletRequest request, HttpServletResponse response) {
                return forward1;
            }
        };
        FlowCallbackInfoMapping callBackInfoMapping = new FlowCallbackInfoMapping();
        callBackInfoMapping.registerFlowCallbackInfo("flow1", callBackInfo);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute(
                FlowCallbackInfoMapping.class.getName(), callBackInfoMapping);
        MockHttpServletResponse response = new MockHttpServletResponse();

        try {
            action.doExecute(mapping, null, request, response);
            fail();
        } catch (FlowTerminateFailureException e) {
            assertEquals("Failed to find FlowCallbackInfo in FlowCallbackInfoMapping. Flow name is \"flow2\".",
                    e.getMessage());
        }
    }

}
