/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;


/**
 * ServletRequest ̃bNAbvNXB
 * <BR><BR>
 * ɁATERASOLUNA t[[N̊g̒P̃eXgp̃NXŁA
 * ƖAvP[ṼeXgŕKvɂȂ邱Ƃ͂قƂǂȂƎvB
 * 
 */
public class MockServletRequest implements ServletRequest {

    /**
     * Attrivuten\bhɂĐݒ肳ꂽlێMap
     */
    private Map attributes = new HashMap();

    /**
     * Parametern\bhɂĐݒ肳ꂽlێMap
     */
    private Map params = new HashMap();

    /**
     * ContentType
     */
    private String contentType = null;

    /**
     * GR[fBO̖O
     */
    private String env = null;

    /**
     * HTTP POST  PUT Ȃǂ̃vgRp
     * NCAg瑗Mꂽf[^ێB
     */
    private ServletInputStream servletInputStream = null;
    
    /**
     * vgR ftHglHTTP/1.1
     */
    private String protocol = "HTTP/1.1";

    /**
     * XL[} ftHglhttp
     */
    private String scheme = "http";

    /**
     * T[o ftHgllocalhost
     */
    private String serverName = "localhost";
    
    /**
     * |[gԍ ftHgl7001
     */
    private int serverPort = 7001;

    /**
     * ZLAȒʐMۂ
     */
    private boolean secure = false;

    /**
     * P[w ftHg̓VXẽftHgP[
     */
    private Locale locale = Locale.getDefault();

    /**
     * @see javax.servlet.ServletRequest#getAttribute(String)
     */
    public Object getAttribute(String s) {
        return attributes.get(s);
    }

    /**
     * @see javax.servlet.ServletRequest#getAttributeNames()
     */
    public Enumeration getAttributeNames() {
        Set set = new HashSet();
        Iterator iter = this.attributes.keySet().iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return Collections.enumeration(set);
    }

    /**
     * @see javax.servlet.ServletRequest#getCharacterEncoding()
     */
    public String getCharacterEncoding() {
        return this.env;
    }

    /**
     * @see javax.servlet.ServletRequest#setCharacterEncoding()
     */
    public void setCharacterEncoding(String env)
                          throws UnsupportedEncodingException {
        this.env = env;
    }

    /**
     * @see javax.servlet.ServletRequest#getContentType()
     */
    public String getContentType() {
        return contentType;
    }

    /**
     * ContentTypeݒ
     * 
     * @param contentType Reg^Cv
     */
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * @see javax.servlet.ServletRequest#getContentLength()
     */
    public int getContentLength() {
        int length = -1;
        if (contentType != null) {
            length = contentType.length();
        }
        return length;
    }

    /**
     * @see javax.servlet.ServletRequest#getInputStream()
     */
    public ServletInputStream getInputStream()
                                  throws java.io.IOException {
        return this.servletInputStream;
    }

    /**
     * ServletɎStreamݒłB
     *
     * @param servletInputStream T[ubgXg[
     */
    public void setInputStream(ServletInputStream servletInputStream) {
        this.servletInputStream = servletInputStream;
    }

    /**
     * @see javax.servlet.ServletRequest#getParameter()
     */
    public String getParameter(String name) {
        String[] values = null;
        if (name != null) {
            values = this.getParameterValues(name);
        }
        return (values == null) ? null : values[0];
    }

    /**
     * NGXgp[^ݒ肷B
     *  <code>value</code>  <code>null</code>
     * ̂Ƃ̓p[^폜B
     *
     * @param name p[^
     * @param value p[^l
     */
    public void setParameter(String name, String value) {
        if (value == null) {
            params.remove(name);
        } else {
            if (name != null) {
                this.params.put(name, new String[] { value });
            }
        }
    }

    /**
     * NGXgp[^ݒ肷B
     *  <code>value</code>  <code>null</code>
     * ̂Ƃ̓p[^폜B
     *
     * @param name p[^(z)
     * @param value p[^l
     */
    public void setParameter(String name, String[] value) {
        if (value == null) {
            params.remove(name);
        } else {
            if (name != null) {
                this.params.put(name, value);
            }
        }
    }

    /**
     * @see javax.servlet.ServletRequest#getParameterNames()
     */
    public Enumeration getParameterNames() {
        Set set = new HashSet();
        Iterator iter = this.params.keySet().iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return Collections.enumeration(set);
    }

    /**
     * @see javax.servlet.ServletRequest#getParameterValues()
     */
    public String[] getParameterValues(String name) {
        String[] values = null;
        if (name != null) {
            values = (String[]) this.params.get(name);
        }
        return values;
    }

    /**
     * @see javax.servlet.ServletRequest#getParameterMap()
     */
    public java.util.Map getParameterMap() {
        return params;
    }

    /**
     * @see javax.servlet.ServletRequest#getProtocol()
     */
    public String getProtocol() {
        return protocol;
    }

    /**
     * vgRݒ
     *
     * @param protocol HTTP/1.1X̃vgRw
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * @see javax.servlet.ServletRequest#getScheme()
     */
    public String getScheme() {
        return this.scheme;
    }

    /**
     * XL[}ݒ
     *
     * @param scheme httpftpȂǃXL[}̖O
     */
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    /**
     * @see javax.servlet.ServletRequest#getServerName()
     */
    public String getServerName() {
        return this.serverName;
    }

    /**
     * T[oݒ肷B
     * 
     * ftHgݒlocalhostB
     * @param serverName T[o[
     */
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    /**
     * @see javax.servlet.ServletRequest#getServerPort()
     */
    public int getServerPort() {
        return serverPort;
    }
    
    /**
     * T[o|[gݒ
     *
     * @param serverPort T[o|[gԍ
     */
    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    /**
     * @see javax.servlet.ServletRequest#getReader()
     */
    public BufferedReader getReader() throws IOException {
        BufferedReader bfReader = null;
        if (servletInputStream != null) {
            InputStreamReader reader 
                    = new InputStreamReader(servletInputStream);
            bfReader = new BufferedReader(reader);
        }
        return bfReader;
    }

    /**
     * @see javax.servlet.ServletRequest#getRemoteAddr()
     */
    public String getRemoteAddr() {
        throw new UnsupportedOperationException(
            "getRemoteAddr() IS Not Supported!");
    }

    /**
     * @see javax.servlet.ServletRequest#getRemoteAddr()
     */
    public String getRemoteHost() {
        throw new UnsupportedOperationException(
            "getRemoteHost() IS Not Supported!");
    }

    /**
     * @see javax.servlet.ServletRequest#setAttribute(String, Object)
     */
    public void setAttribute(String key, Object attr) {
        if (attr != null) {
            attributes.put(key, attr);
        } else {
            removeAttribute(key);
        }
    }
    
    /**
     * @see javax.servlet.ServletRequest#removeValue(String)
     * @deprecated
     */
    public void removeValue(String key) {
        removeAttribute(key);
    }
    
    /**
     * @see javax.servlet.ServletRequest#removeAttribute(String)
     */
    public void removeAttribute(String key) {
        attributes.remove(key);
    }
    
    /**
     * @see javax.servlet.ServletRequest#getLocale()
     */
    public Locale getLocale() {
        return this.locale;
    }

    /**
     * VXẽftHgP[ȊÕP[ݒ肷B
     * 
     * @param locale P[
     */
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    /**
     * @see javax.servlet.ServletRequest#getLocales()
     */
    public Enumeration getLocales() {
        throw new UnsupportedOperationException(
            "getLocales() IS Not Supported!");
    }

    /**
     * @see javax.servlet.ServletRequest#isSecure()
     */
    public boolean isSecure() {
        return this.secure;
    }

    /**
     * ZLAȒʐMǂݒ肷B
     *
     * @param secure ZLAȒʐMǂAZLAȂture
     */
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    /**
     * @see javax.servlet.ServletRequest#getRequestDispatcher()
     */
    public RequestDispatcher getRequestDispatcher(String path) {
        MockRequestDispatcher dsp = new MockRequestDispatcher(path);
        return dsp;
    }


    /**
     * @see javax.servlet.ServletRequest#getRealPath()
     */
    public String getRealPath(String path) {
        throw new UnsupportedOperationException(
            "getRealPath() IS Not Supported!");
    }

}
