/*
 * Copyright (c) 2014 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.common.filter;

import javax.servlet.ServletException;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockFilterChain;
import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.common.filter.ContentTypeLengthLimitFilter} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Content-TypẽTCYsB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.common.filter.ContentTypeLengthLimitFilter
 */
public class ContentTypeLengthLimitFilterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ContentTypeLengthLimitFilterTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ContentTypeLengthLimitFilterTest(String name) {
        super(name);
    }

    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:limitBytes:1024<br>
     *         
     * <br>
     * ҒlF(ԕω) limitBytes:1024<br>
     * <br>
     * p[^ݒ肳ĂꍇAtB[hlimitBytesɔf邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
        // RtBO
        MockFilterConfig filterConfig = new MockFilterConfig();
        filterConfig.setInitParameter("limitBytes", "1024");
        // tB^̗p
        ContentTypeLengthLimitFilter filter
            = new ContentTypeLengthLimitFilter();
        
        // eXg{
        filter.init(filterConfig);

        // 
        assertEquals(1024, UTUtil.getPrivateField(filter, "limitBytes"));
    }

    /**
     * testInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:limitBytes:null(ݒȂ)<br>
     *         
     * <br>
     * ҒlF(ԕω) limitBytes:2048<br>
     *         
     * <br>
     * p[^ݒ肳ĂȂꍇAtB[hlimitBytes̓ftHgl(2048)ł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // O
        // RtBO
        MockFilterConfig filterConfig = new MockFilterConfig();
        // tB^̗p
        ContentTypeLengthLimitFilter filter
            = new ContentTypeLengthLimitFilter();
        
        // eXg{
        filter.init(filterConfig);

        // 
        assertEquals(2048, UTUtil.getPrivateField(filter, "limitBytes"));
    }

    /**
     * testInit03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:limitBytes:AAA<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NumberFormatException<br>
     *         
     * <br>
     * p[^limitBytesɐȊOݒ肳ĂꍇANumberFormatException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit03() throws Exception {
        // O
        // RtBO
        MockFilterConfig filterConfig = new MockFilterConfig();
        filterConfig.setInitParameter("limitBytes", "AAA");
        // tB^̗p
        ContentTypeLengthLimitFilter filter
            = new ContentTypeLengthLimitFilter();
        
        // eXg{
        try {
            filter.init(filterConfig);
            fail();
        } catch (NumberFormatException e) {
            // Ғʂ
        }
    }

    /**
     * testDoFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:not null<br>
     *         () req:contentType:null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) chain:request:req<br>
     *                    chain:response:res<br>
     *         
     * <br>
     * contentTypenull̏ꍇAFilterChain#doFilters邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setContentType(null);
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        ContentTypeLengthLimitFilter filter = new ContentTypeLengthLimitFilter();
        UTUtil.setPrivateField(filter, "limitBytes", 2048);
        
        // eXg{
        filter.doFilter(req, res, chain);
        
        // 
        assertSame(req, chain.getRequest());
        assertSame(res, chain.getResponse());
    }

    /**
     * testDoFilter02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() req:not null<br>
     *         () req:contentType:2047oCg̒l<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () limitBytes:2048<br>
     *         
     * <br>
     * ҒlF(ԕω) chain:request:req<br>
     *                    chain:response:res<br>
     *         
     * <br>
     * contentTypẽoCglimitBytesɐݒ肳ꂽlȉ̏ꍇAFilterChain#doFilters邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter02() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        int contentTypeLength = 2047;
        StringBuilder contentTypeSB = new StringBuilder();
        for (int i = 0; i < contentTypeLength; i++) {
            contentTypeSB.append('-');
        }
        req.setContentType(contentTypeSB.toString());
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        ContentTypeLengthLimitFilter filter = new ContentTypeLengthLimitFilter();
        UTUtil.setPrivateField(filter, "limitBytes", 2048);
        
        // eXg{
        filter.doFilter(req, res, chain);
        
        // 
        assertSame(req, chain.getRequest());
        assertSame(res, chain.getResponse());
    }

    /**
     * testDoFilter03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() req:not null<br>
     *         () req:contentType:2048oCg̒l<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () limitBytes:2048<br>
     *         
     * <br>
     * ҒlF(ԕω) chain:request:req<br>
     *                    chain:response:res<br>
     *         
     * <br>
     * contentTypẽoCglimitBytesɐݒ肳ꂽlȉ̏ꍇAFilterChain#doFilters邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter03() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        int contentTypeLength = 2048;
        StringBuilder contentTypeSB = new StringBuilder();
        for (int i = 0; i < contentTypeLength; i++) {
            contentTypeSB.append('-');
        }
        req.setContentType(contentTypeSB.toString());
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        ContentTypeLengthLimitFilter filter = new ContentTypeLengthLimitFilter();
        UTUtil.setPrivateField(filter, "limitBytes", 2048);
        
        // eXg{
        filter.doFilter(req, res, chain);
        
        // 
        assertSame(req, chain.getRequest());
        assertSame(res, chain.getResponse());
    }

    /**
     * testDoFilter04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FB
     * <br><br>
     * ͒lF() req:not null<br>
     *         () req:contentType:2049oCg̒l<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () limitBytes:2048<br>
     *         
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bZ[WF"Content-Type header is too long."<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[WF"Content-Type header is too long. Limit size is 2048 byte. Actual size is 2049 byte."<br>
     *         
     * <br>
     * contentTypẽoCglimitBytesɐݒ肳ꂽlȉ̏ꍇAFilterChain#doFilters邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter04() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        int contentTypeLength = 2049;
        StringBuilder contentTypeSB = new StringBuilder();
        for (int i = 0; i < contentTypeLength; i++) {
            contentTypeSB.append('-');
        }
        req.setContentType(contentTypeSB.toString());
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        ContentTypeLengthLimitFilter filter = new ContentTypeLengthLimitFilter();
        UTUtil.setPrivateField(filter, "limitBytes", 2048);
        
        // eXg{
        try {
            filter.doFilter(req, res, chain);
            fail();
        } catch (ServletException e) {
            // 
            assertEquals("Content-Type header is too long.", e.getMessage());
            assertTrue(LogUTUtil.checkError("Content-Type header is too long. Limit size is 2048 byte. Actual size is 2049 byte."));
        }
    }

}
