/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.util.GenericsUtil;
import jp.terasoluna.fw.util.ProxyUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;

/**
 * rWlXWbNo̓Ame[VΉrWlXWbNNANVNXB
 * <p>
 * rWlXWbNo͒`LqɁA rWlXWbNo̓NX̃tB[hɐp̃Ame[V t^邱ƂłB<br>
 * ɂrWlXWbNo͒`̋Lqȗ邱ƂłB
 * </p>
 * @param <P> rWlXWbNւ̓͒lƂȂJavaBeaň^
 * @see jp.terasoluna.fw.web.struts.actions.BLogicAction
 * @see jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction
 * @see jp.terasoluna.fw.web.struts.actions.AbstractAnnotationBLogicAction
 */
public class AnnotationBLogicAction<P> extends
                                       AbstractAnnotationBLogicAction<P> {

    /** Oo̓IuWFNg */
    private static Log log = LogFactory.getLog(AnnotationBLogicAction.class);

    /**
     * ݒ肳rWlXWbNB
     */
    private BLogic<P> businessLogic = null;

    /**
     * BLogicNB
     * <p>
     * ƂāANXϐbusinessLogicɂBLogicC^tF[X NXݒ肳ĂKvB<br>
     * BLogicnull̂Ƃ́AnullԋpB
     * </p>
     * @param param BLogic͏
     * @return BLogico͏
     * @throws Exception \ȂO
     */
    @Override
    public BLogicResult doExecuteBLogic(P param) throws Exception {

        if (log.isDebugEnabled()) {
            log.debug("*** doExecuteBLogic() called. ***");
        }

        if (businessLogic == null) {
            return null;
        }

        if (log.isDebugEnabled()) {
            // DIꂽrWlXWbÑNXo
            StringBuilder sb = new StringBuilder("*** Starting blogic[");
            sb.append(getTargetClass().getName()).append("]. ***");
            log.debug(sb.toString());
        }

        BLogicResult result = businessLogic.execute(param);

        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("*** Finished blogic[");
            sb.append(getTargetClass().getName()).append("]. ***");
            log.debug(sb.toString());
        }

        return result;
    }

    /**
     * ^[QbgNX擾
     * @return ^[QbgNX
     */
    protected Class<?> getTargetClass() {
        // AOPĂꍇɃ^[QbgNX擾
        if (AopUtils.isAopProxy(getBusinessLogic())) {
            return AopUtils.getTargetClass(getBusinessLogic());
        }
        return getBusinessLogic().getClass();
    }

    /**
     * NX̃TuNXɒ`ꂽAR}hNX̎^Cv擾B
     * @return ̓NX̌^B
     */
    protected Class<P> getInputBeanClass() {
        return getInputBeanClass(getBusinessLogic());
    }

    /**
     * rWlXWbN擾B
     * @return rWlXWbN
     */
    public BLogic<P> getBusinessLogic() {
        return this.businessLogic;
    }

    /**
     * ̃ANVɁAsrWlXWbÑCX^Xݒ肵܂B
     * @param businessLogic ̃ANVsrWlXWbÑCX^X
     */
    public void setBusinessLogic(BLogic<P> businessLogic) {
        this.businessLogic = businessLogic;
    }

    /**
     * R}hIuWFNǧ^擾B {@link jp.terasoluna.fw.service.thin.BLogic}NX execute\bḧ̌^ԂB
     * execute\bhI[o[[hĂꍇAOԂB
     * @return ̓NX̌^B
     */
    @SuppressWarnings("unchecked")
    protected Class<P> getInputBeanClass(BLogic<P> blogic) {
        return GenericsUtil.resolveParameterizedClass(BLogic.class, ProxyUtil
                .getTargetClass(blogic))[0];
    }
}
