/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.web.codelist.DBCodeListLoader;
import jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader;
import jp.terasoluna.fw.web.struts.action.MockWebApplicationContext;
import jp.terasoluna.fw.web.struts.actions.ClearSessionAction;
import jp.terasoluna.fw.web.struts.actions.DispatchAction;
import jp.terasoluna.fw.web.struts.actions.ForwardAction;
import jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * GeneralActionResolverTest
 */
public class GeneralActionResolverTest {

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : null</li>
     * <li>pathPattern : null</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction001() throws Exception {
        Action result = null;

        // p[^
        String actionName = null;
        String pathPattern = null;
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = null;

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : ""</li>
     * <li>pathPattern : null</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction002() throws Exception {
        Action result = null;

        // p[^
        String actionName = "";
        String pathPattern = null;
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = null;

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : null</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction003() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = null;
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = null;

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : ""</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction004() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "";
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = null;

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "hoge"</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction005() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "hoge";
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = null;

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "hoge"</li>
     * <li>beanName : "abc"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction006() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "hoge";
        String beanName = "abc";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = null;

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeDSP"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction007() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeDSP";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction008() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.TRUE, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction009() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.TRUE);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.FALSE, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction010() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.FALSE);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNull(result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>getClass() : ForwardAction.class</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction011() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, new ForwardAction());

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(ForwardAction.class, result.getClass());
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>action : new Action()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction012() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        Action action = new Action();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>action : new ForwardAction()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction013() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        Action action = new ForwardAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>action : new DispatchAction()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction014() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        Action action = new DispatchAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>action : new ClearSessionAction()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction015() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        Action action = new ClearSessionAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>clearSessionKeysBeanName : "clearSessionKeysBean"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>action : new ClearSessionAction()</li>
     * <li>clearSessionKeysList : new ArrayList<String>()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * containsBean(clearSessionKeysBeanName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * getBean(clearSessionKeysBeanName) : clearSessionKeysList, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction016() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        String clearSessionKeysBeanName = "clearSessionKeysBean";
        ResolverActionMapping mapping = new ResolverActionMapping();
        // mapping.setClearSessionKeysBeanName(clearSessionKeysBeanName);
        ActionServlet servlet = null;
        Action action = new ClearSessionAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(clearSessionKeysBeanName,
                Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        List<String> clearSessionKeysList = new ArrayList<String>();
        applicationContext.addBeanMap(clearSessionKeysBeanName,
                clearSessionKeysList);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>clearSessionKeysBeanName : "clearSessionKeysBean"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>action : new ClearSessionAction()</li>
     * <li>clearSessionKeysList : new Object()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * containsBean(clearSessionKeysBeanName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * getBean(clearSessionKeysBeanName) : clearSessionKeysList, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction017() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        String clearSessionKeysBeanName = "clearSessionKeysBean";
        ResolverActionMapping mapping = new ResolverActionMapping();
        // mapping.setClearSessionKeysBeanName(clearSessionKeysBeanName);
        ActionServlet servlet = null;
        Action action = new ClearSessionAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(clearSessionKeysBeanName,
                Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        Object clearSessionKeysList = new Object();
        applicationContext.addBeanMap(clearSessionKeysBeanName,
                clearSessionKeysList);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>action : new ReloadCodeListAction()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction018() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        Action action = new ReloadCodeListAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>codeListLoaderBeanName : "codeListLoaderBean"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>action : new ReloadCodeListAction()</li>
     * <li>clearSessionKeysList : new DBCodeListLoader()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * containsBean(codeListLoaderBeanName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * getBean(codeListLoaderBeanName) : clearSessionKeysList, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction019() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        String codeListLoaderBeanName = "codeListLoaderBean";
        ResolverActionMapping mapping = new ResolverActionMapping();
        // mapping.setCodeListLoaderBeanName(codeListLoaderBeanName);
        ActionServlet servlet = null;
        Action action = new ReloadCodeListAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(codeListLoaderBeanName,
                Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        ReloadableCodeListLoader clearSessionKeysList = new DBCodeListLoader();
        applicationContext.addBeanMap(codeListLoaderBeanName,
                clearSessionKeysList);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getDelegateAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>codeListLoaderBeanName : "codeListLoaderBean"</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>action : new ReloadCodeListAction()</li>
     * <li>clearSessionKeysList : new Object()</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(beanName) : Boolean.FALSE, <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * containsBean(codeListLoaderBeanName) : Boolean.TRUE, <br>
     * getBean(actionName) : action, <br>
     * getBean(codeListLoaderBeanName) : clearSessionKeysList, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * <li>return : action</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetDelegateAction020() throws Exception {
        Action result = null;

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        String codeListLoaderBeanName = "codeListLoaderBean";
        ResolverActionMapping mapping = new ResolverActionMapping();
        // mapping.setCodeListLoaderBeanName(codeListLoaderBeanName);
        ActionServlet servlet = null;
        Action action = new ReloadCodeListAction();
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(beanName, Boolean.FALSE);
        applicationContext.addContainsBeanMap(actionName, Boolean.TRUE);
        applicationContext.addContainsBeanMap(codeListLoaderBeanName,
                Boolean.TRUE);
        applicationContext.addBeanMap(actionName, action);
        Object clearSessionKeysList = new Object();
        applicationContext.addBeanMap(codeListLoaderBeanName,
                clearSessionKeysList);

        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        result = resolver.getDelegateAction(beanName, mapping, servlet,
                applicationContext);

        // 
        assertNotNull(result);
        assertEquals(action, result);
    }

    /**
     * getActionCache\bh<br>
     * <p>
     * (n)
     * </p>
     * @throws Exception
     */
    @Test
    public void testGetActionCache001() throws Exception {
        // 
        GeneralActionResolver resolver = new GeneralActionResolver();

        // p[^
        Object cacheKey = null;

        // eXg
        Action result = resolver.getActionCache(cacheKey);

        // 
        assertNull(result);
    }
}
