/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;

public class MockApplicationContext implements ApplicationContext {

    private Map<String, Boolean> containsBeanMap = new HashMap<String, Boolean>();

    private Map<String, Object> beanMap = new HashMap<String, Object>();

    private Map<Class, String[]> beanNamesForType = new HashMap<Class, String[]>();

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory()
            throws IllegalStateException {

        return null;
    }

    public String getDisplayName() {

        return null;
    }

    public String getId() {

        return null;
    }

    public ApplicationContext getParent() {

        return null;
    }

    public long getStartupDate() {

        return 0;
    }

    public boolean containsBeanDefinition(String arg0) {

        return false;
    }

    public int getBeanDefinitionCount() {

        return 0;
    }

    public String[] getBeanDefinitionNames() {

        return null;
    }

    public String[] getBeanNamesForType(Class key) {
        return beanNamesForType.get(key);
    }

    public String[] getBeanNamesForType(Class arg0, boolean arg1, boolean arg2) {

        return null;
    }

    public Map getBeansOfType(Class arg0) throws BeansException {

        return null;
    }

    public Map getBeansOfType(Class arg0, boolean arg1, boolean arg2)
            throws BeansException {

        return null;
    }

    public boolean containsBean(String key) {
        Boolean value = containsBeanMap.get(key);
        if (value == null) {
            return false;
        }
        return value.booleanValue();
    }

    public String[] getAliases(String arg0) {

        return null;
    }

    public Object getBean(String key) throws BeansException {

        return beanMap.get(key);
    }

    public Object getBean(String key, Class arg1) throws BeansException {

        return beanMap.get(key);
    }

    public Object getBean(String key, Object[] arg1) throws BeansException {

        return beanMap.get(key);
    }

    public Class getType(String key) throws NoSuchBeanDefinitionException {
        Object obj = beanMap.get(key);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    public boolean isPrototype(String arg0)
            throws NoSuchBeanDefinitionException {

        return false;
    }

    public boolean isSingleton(String arg0)
            throws NoSuchBeanDefinitionException {

        return false;
    }

    public boolean isTypeMatch(String arg0, Class arg1)
            throws NoSuchBeanDefinitionException {

        return false;
    }

    public boolean containsLocalBean(String arg0) {

        return false;
    }

    public BeanFactory getParentBeanFactory() {

        return null;
    }

    public String getMessage(MessageSourceResolvable arg0, Locale arg1)
            throws NoSuchMessageException {

        return null;
    }

    public String getMessage(String arg0, Object[] arg1, Locale arg2)
            throws NoSuchMessageException {

        return null;
    }

    public String getMessage(String arg0, Object[] arg1, String arg2,
            Locale arg3) {

        return null;
    }

    public void publishEvent(ApplicationEvent arg0) {

    }

    public Resource[] getResources(String arg0) throws IOException {

        return null;
    }

    public ClassLoader getClassLoader() {

        return null;
    }

    public Resource getResource(String arg0) {

        return null;
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return null;
    }

    public Environment getEnvironment() {
        return null;
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName,
            Class<A> annotationType) {
        return null;
    }

    public Map<String, Object> getBeansWithAnnotation(
            Class<? extends Annotation> annotationType) throws BeansException {
        return null;
    }

    public void addContainsBeanMap(String key, Boolean value) {
        containsBeanMap.put(key, value);
    }

    public void addBeanMap(String key, Object value) {
        beanMap.put(key, value);
    }

    public void addBeanNamesForType(Class key, String[] value) {
        beanNamesForType.put(key, value);
    }
}
