/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import static org.junit.Assert.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.BLogicMapperEx;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.util.ExceptionUtil;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.MockServletContext;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ForwardConfig;
import org.easymock.classextension.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.mockrunner.mock.web.MockActionServlet;
import com.mockrunner.mock.web.MockForwardConfig;
import com.mockrunner.mock.web.MockModuleConfig;

public class AbstractAnnotationBLogicActionTest {

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * doExecute\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     */
    @Test
    public void testDoExecuteActionMappingActionFormHttpServletRequestHttpServletResponse001() {
        AbstractAnnotationBLogicAction<?> action = new AbstractAnnotationBLogicActionStub01();

        // p[^
        ActionMapping mapping = new ActionMapping();
        ActionForm form = null;
        HttpServletRequest request = null;
        HttpServletResponse response = null;

        // eXg
        try {
            action.doExecute(mapping, form, request, response);
        } catch (Exception e) {
            // 
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            assertEquals("errors.blogic.mapping", e.getMessage());
            return;
        }
        fail();
    }

    /**
     * doExecute\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     */
    @Test
    public void testDoExecuteActionMappingActionFormHttpServletRequestHttpServletResponse002() {
        AbstractAnnotationBLogicAction<?> action = new AbstractAnnotationBLogicActionStub01();

        // p[^
        ActionMappingEx mapping = new ActionMappingEx();
        ActionForm form = EasyMock.createMock(ActionForm.class);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        EasyMock.replay(form);

        MockModuleConfig moduleConfig = new MockModuleConfig("");
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // ServletContext
        MockServletContext servletContext = new MockServletContext();
        BLogicMapperEx mapper = new BLogicMapperEx();
        servletContext.setAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY, mapper);

        // ActionServlet
        MockActionServlet mockActionServlet = new MockActionServlet();
        mockActionServlet.setServletContext(servletContext);
        action.setServlet(mockActionServlet);

        // eXg
        try {
            action.doExecute(mapping, form, request, response);
        } catch (Exception e) {
            // 
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            assertEquals("errors.blogic.result.null", e.getMessage());
            return;
        }
        fail();
    }

    /**
     * doExecute\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     */
    @Test
    public void testDoExecuteActionMappingActionFormHttpServletRequestHttpServletResponse003() {
        AbstractAnnotationBLogicAction<?> action = new AbstractAnnotationBLogicActionStub02();

        // p[^
        ActionMappingEx mapping = new ActionMappingEx();
        ActionForm form = EasyMock.createMock(ActionForm.class);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        EasyMock.replay(form);

        MockModuleConfig moduleConfig = new MockModuleConfig("");
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // ServletContext
        MockServletContext servletContext = new MockServletContext();
        BLogicMapperEx mapper = new BLogicMapperEx();
        servletContext.setAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY, mapper);

        // ActionServlet
        MockActionServlet mockActionServlet = new MockActionServlet();
        mockActionServlet.setServletContext(servletContext);
        action.setServlet(mockActionServlet);

        // eXg
        try {
            action.doExecute(mapping, form, request, response);
        } catch (Exception e) {
            // 
            assertNotNull(e);
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("Bean object must not be null", e.getMessage());
            return;
        }
        fail();
    }

    /**
     * doExecute\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     */
    @Test
    public void testDoExecuteActionMappingActionFormHttpServletRequestHttpServletResponse004() {

        // ------------
        // AbstractAnnotationBLogicAction
        AbstractAnnotationBLogicActionStub03 action = new AbstractAnnotationBLogicActionStub03();
        String forwardName = "hoge";
        action.setForwardName(forwardName);

        // ServletContext
        MockServletContext servletContext = new MockServletContext();
        BLogicMapperEx mapper = new BLogicMapperEx();
        servletContext.setAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY, mapper);

        // ActionServlet
        MockActionServlet mockActionServlet = new MockActionServlet();
        mockActionServlet.setServletContext(servletContext);
        action.setServlet(mockActionServlet);

        // ------------
        // ActionMappingEx
        ActionMappingEx mapping = new ActionMappingEx();
        ForwardConfig forwardConfig = new MockForwardConfig();
        forwardConfig.setName(forwardName);
        mapping.addForwardConfig(forwardConfig);

        // ------------
        // ActionForm
        ActionForm form = EasyMock.createMock(ActionForm.class);
        EasyMock.replay(form);

        // ------------
        // HttpServletRequest, MockHttpServletResponse
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // MockModuleConfig
        MockModuleConfig moduleConfig = new MockModuleConfig("");
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // eXg
        ActionForward result = null;
        try {
            result = action.doExecute(mapping, form, request, response);
        } catch (Exception e) {
            fail();
        }

        // 
        assertNotNull(result);
        assertEquals(forwardName, result.getName());
        assertEquals(MockForwardConfig.class, result.getClass());
    }

    /**
     * doExecute\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     */
    @Test
    public void testDoExecuteActionMappingActionFormHttpServletRequestHttpServletResponse005() {

        // ------------
        // AbstractAnnotationBLogicAction
        String forwardName = "hoge";
        AbstractAnnotationBLogicActionStub04 action = new AbstractAnnotationBLogicActionStub04();
        action.setForwardName(forwardName);

        // ServletContext
        MockServletContext servletContext = new MockServletContext();
        BLogicMapperEx mapper = new BLogicMapperEx();
        servletContext.setAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY, mapper);

        // ActionServlet
        MockActionServlet mockActionServlet = new MockActionServlet();
        mockActionServlet.setServletContext(servletContext);
        action.setServlet(mockActionServlet);

        // ------------
        // ActionMappingEx
        String scope = "request";
        String formName = "form";
        ActionMappingEx mapping = new ActionMappingEx();
        ForwardConfig forwardConfig = new MockForwardConfig();
        forwardConfig.setName(forwardName);
        mapping.addForwardConfig(forwardConfig);
        mapping.setScope(scope);
        mapping.setAttribute(formName);

        // ------------
        // ActionForm
        ActionForm form = EasyMock.createMock(ActionForm.class);
        EasyMock.replay(form);

        // ------------
        // HttpServletRequest, MockHttpServletResponse
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // MockModuleConfig
        MockModuleConfig moduleConfig = new MockModuleConfig("");
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        ActionForm actionForm = new MockActionForm();
        request.setAttribute(formName, actionForm);

        // eXg
        ActionForward result = null;
        try {
            result = action.doExecute(mapping, form, request, response);
        } catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(ExceptionUtil.getStackTrace(e));
            fail();
        }

        // 
        assertNotNull(result);
        assertEquals(forwardName, result.getName());
        assertEquals(MockForwardConfig.class, result.getClass());
    }

    /**
     * doExecute\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     */
    @Test
    public void testDoExecuteActionMappingActionFormHttpServletRequestHttpServletResponse006() {

        // ------------
        // AbstractAnnotationBLogicAction
        String forwardName = null;
        AbstractAnnotationBLogicActionStub04 action = new AbstractAnnotationBLogicActionStub04();
        action.setForwardName(forwardName);

        // ServletContext
        MockServletContext servletContext = new MockServletContext();
        BLogicMapperEx mapper = new BLogicMapperEx();
        servletContext.setAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY, mapper);

        // ActionServlet
        MockActionServlet mockActionServlet = new MockActionServlet();
        mockActionServlet.setServletContext(servletContext);
        action.setServlet(mockActionServlet);

        // DownloadProcessor
        DownloadProcessor downloadProcessor = new DownloadProcessor() {
            public void processDownload(Object resultObject,
                    BLogicResult result, HttpServletRequest request,
                    HttpServletResponse response, ActionMappingEx mappingEx) {
            }
        };
        action.setDownloadProcessor(downloadProcessor);

        // ------------
        // ActionMappingEx
        String scope = "request";
        String formName = "form";
        ActionMappingEx mapping = new ActionMappingEx();
        ForwardConfig forwardConfig = new MockForwardConfig();
        forwardConfig.setName(forwardName);
        mapping.addForwardConfig(forwardConfig);
        mapping.setScope(scope);
        mapping.setAttribute(formName);

        // ------------
        // ActionForm
        ActionForm form = EasyMock.createMock(ActionForm.class);
        EasyMock.replay(form);

        // ------------
        // HttpServletRequest, MockHttpServletResponse
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // MockModuleConfig
        MockModuleConfig moduleConfig = new MockModuleConfig("");
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        ActionForm actionForm = new MockActionForm();
        request.setAttribute(formName, actionForm);

        // eXg
        ActionForward result = null;
        try {
            result = action.doExecute(mapping, form, request, response);
        } catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(ExceptionUtil.getStackTrace(e));
            fail();
        }

        // 
        assertNotNull(result);
        assertEquals(forwardName, result.getName());
        assertEquals(MockForwardConfig.class, result.getClass());
    }

}
