/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.dao.ibatis;

import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.dao.IllegalClassTypeException;
import jp.terasoluna.utlib.LogUTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.dao.ibatis.QueryDAOiBatisImpl}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * QueryDAOC^tF[XiBATISpNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.dao.ibatis.QueryDAOiBatisImpl
 */
public class QueryDAOiBatisImplTest extends TestCase {

    /**
     * eXgΏۃNX
     */
    private QueryDAOiBatisImpl dao = new QueryDAOiBatisImpl();

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(QueryDAOiBatisImplTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        dao = new QueryDAOiBatisImpl();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        dao = null;
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public QueryDAOiBatisImplTest(String name) {
        super(name);
    }

    /**
     * testExecuteForObject01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.String"<br>
     * () queryForObject̖߂Object:String("abc")<br>
     * 
     * <br>
     * ҒlF(߂l) E:String("abc")<br>
     * queryForObject̖߂Objectclazz̃NX
     * ϊĕԋp邱ƂmFB<br>
     * (ԕω) queryForObjecťďomF:sqlIdA
     * bindParamsŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * queryForObject̖߂lAclazz̕ɃLXgłAԋpꍇ
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObject01() throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        String str = dao.executeForObject("sqlId", "1", String.class);

        // ߂l̊mF
        assertEquals("abc", str);

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testExecuteForObject02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:null<br>
     * () queryForObject̖߂Object:String("abc")<br>
     * 
     * <br>
     * ҒlF(ԕω) queryForObjecťďomF:sqlIdA
     * bindParamsŌĂяoĂ鎖mF<br>
     * (ԕω) O:IllegalClassTypeException<br>
     * (ԕω) O:bZ[W<br>
     * "The mistake Class Type of the argument."<br>
     * 
     * <br>
     * clazznull̏ꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObject02() throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        String str = dao.executeForObject("sqlId", "1", null);

        // ߂l̊mF
        assertNull(str);

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testExecuteForObject03() <br>
     * <br>
     * 
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.Integer"<br>
     * () queryForObject̖߂Object:String("abc")<br>
     * 
     * <br>
     * ҒlF (ԕω) queryForObjecťďomF:sqlIdA
     * bindParamsŌĂяoĂ鎖mF<br>
     * (ԕω) O:IllegalClassTypeException<br>
     * bvꂽOFClassCastException (ԕω) O:bZ[W<br>
     * "The mistake Class Type of the argument."<br>
     * 
     * <br>
     * clazzqueryForObject̖߂ɕႤꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObject03() throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        try {
            dao.executeForObject("sqlId", "1", Integer.class);
            fail();
        } catch (IllegalClassTypeException e) {
            assertEquals(ClassCastException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError(
                    IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE));
        }

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testExecuteForObject04() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.String"<br>
     * () queryForObject̖߂Object:null<br>
     * 
     * <br>
     * ҒlF(߂l) E:null<br>
     * (ԕω) queryForObjecťďomF:sqlIdA
     * bindParamsŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * queryForObject̖߂lAnull̏ꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObject04() throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub02());

        // eXg{
        String str = dao.executeForObject("sqlId", "1", String.class);

        // ߂l̊mF
        assertNull(str);

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub02 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub02) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testExecuteForMap01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () queryForMap̖߂Map:not null<br>
     * 
     * <br>
     * ҒlF(߂l) Map:not null<br>
     * (ԕω) queryForObjecťďomF:sqlIdAbindParams ŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * queryForObject̖߂肪not nullŁA̖߂肪̂܂ܕԋpꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForMap01() throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub03());

        // eXg{
        Map<String, Object> str = dao.executeForMap("sqlId", "1");

        // ߂l̊mF
        assertNotNull(str);

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub03 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub03) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testExecuteForObjectArrayStringObjectClass01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.String"<br>
     * () queryForList̖߂List:not null<br>
     * [String("a"),String("b"), String("c")]<br>
     * 
     * <br>
     * ҒlF(߂l) E[]:String("a")<br>
     * String("b")<br>
     * String("c")<br>
     * (ԕω) queryForLisťďomF:sqlIdAbindParams
     * ĂяoĂ鎖mF<br>
     * 
     * <br>
     * queryForList̖߂肪not nullŁAclazž^̔zɕϊłꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObjectArrayStringObjectClass01() 
            throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        String[] str = dao.executeForObjectArray("sqlId", "1", String.class);

        // ߂l̊mF
        assertEquals("a", str[0]);
        assertEquals("b", str[1]);
        assertEquals("c", str[2]);

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testExecuteForObjectArrayStringObjectClass02() <br>
     * <br>
     * 
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:null<br>
     * () queryForList̖߂List:not null<br>
     * 
     * <br>
     * ҒlF(ԕω) O:llegalClassTypeException<br>
     * (ԕω) O:bZ[W<br>
     * "The mistake Class Type of the argument."<br>
     * 
     * <br>
     * clazznull̏ꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObjectArrayStringObjectClass02() 
            throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        try {
            dao.executeForObjectArray("sqlId", "1", null);
            fail();
        } catch (IllegalClassTypeException e) {
            assertNull(e.getCause());
            assertTrue(LogUTUtil.checkError(
                    IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE));
        }

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertFalse(sqlMapTemp.isCalled());
    }

    /**
     * testExecuteForObjectArrayStringObjectClass03() <br>
     * <br>
     * 
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.Integer"<br>
     * () queryForList̖߂List:"not null<br>
     * [String(""a""),String(""b""), String(""c"")]"<br>
     * 
     * <br>
     * ҒlF(ԕω) O:IllegalClassTypeException<br>
     * bvꂽOF<br>
     * ArrayStoreException<br>
     * (ԕω) O:bZ[W<br>
     * "The mistake Class Type of the argument."<br>
     * 
     * <br>
     * queryForList̖߂ƈclazž^Ⴄꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObjectArrayStringObjectClass03() 
            throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        try {
            dao.executeForObjectArray("sqlId", "1", Integer.class);
            fail();
        } catch (IllegalClassTypeException e) {
            assertEquals(ArrayStoreException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError(
                    IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE));
        }

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testExecuteForMapArrayStringObject01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * 
     * <br>
     * ҒlF(߂l) Mapz<br>
     * [0]=Map["abc","123"]<br>
     * (ԕω) executeForObjectArray̌ďomF:sqlIdA bindParams,
     * Map.classŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * ł́AexecuteForObjectArrayĂяoĂ邽߁A
     * eXgexecuteForObjectArraỹeXgP[Xɕ܂B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForMapArrayStringObject01() throws Exception {
        // O
        dao = new QueryDAOiBatisImpl_QueryDAOiBatisImplStub01();

        // eXg{
        Map<String, Object>[] map = dao.executeForMapArray("sqlId", "1");

        // 
        assertTrue(map[0].containsKey("abc"));
        assertEquals("123", map[0].get("abc"));
        assertTrue(((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .isCalled());
        assertEquals("sqlId",
                ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao).getSqlID());
        assertEquals("1", ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .getBindParams());
        assertEquals(Map.class.getName(),
                ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao).getClazz()
                        .getName());
    }

    /**
     * testExecuteForObjectArrayStringObjectClassintint01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.String"<br>
     * () beginIndex:10<br>
     * () maxCount:100<br>
     * () queryForList̖߂List:not null<br>
     * [String("a"),String("b"), String("c")]<br>
     * 
     * <br>
     * ҒlF(߂l) E[]:String("a")<br>
     * String("b")<br>
     * String("c")<br>
     * (ԕω) queryForLisťďomF:sqlID, bindParams, beginIndex,
     * maxCountŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * queryForList̖߂肪not nullŁAclazž^̔zɕϊłꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObjectArrayStringObjectClassintint01()
            throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        String[] str = dao.executeForObjectArray("sqlId", "1", String.class,
                10, 100);

        // ߂l̊mF
        assertEquals("a", str[0]);
        assertEquals("b", str[1]);
        assertEquals("c", str[2]);

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
        assertEquals(10, sqlMapTemp.getSkipResults());
        assertEquals(100, sqlMapTemp.getMaxResults());
    }

    /**
     * testExecuteForObjectArrayStringObjectClassintint02() <br>
     * <br>
     * 
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:null<br>
     * () queryForList̖߂List:not null<br>
     * 
     * <br>
     * ҒlF(ԕω) O:llegalClassTypeException<br>
     * (ԕω) O:bZ[W<br>
     * "The mistake Class Type of the argument."<br>
     * 
     * <br>
     * clazznull̏ꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObjectArrayStringObjectClassintint02()
            throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        try {
            dao.executeForObjectArray("sqlId", "1", null, 10, 100);
            fail();
        } catch (IllegalClassTypeException e) {
            assertNull(e.getCause());
            assertTrue(LogUTUtil.checkError(
                    IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE));
        }

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertFalse(sqlMapTemp.isCalled());
    }

    /**
     * testExecuteForObjectArrayStringObjectClassintint03() <br>
     * <br>
     * 
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.String"<br>
     * () queryForList̖߂List:not null<br>
     * [Integer(1)]<br>
     * 
     * <br>
     * ҒlF(ԕω) O:IllegalClassTypeException<br>
     * bvꂽOF<br>
     * ArrayStoreException<br>
     * (ԕω) O:bZ[W<br>
     * "The mistake Class Type of the argument."<br>
     * 
     * <br>
     * queryForList̖߂ƈclazž^Ⴄꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObjectArrayStringObjectClassintint03()
            throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        try {
            dao.executeForObjectArray("sqlId", "1", Integer.class, 10, 100);
            fail();
        } catch (IllegalClassTypeException e) {
            assertEquals(ArrayStoreException.class.getName(), e.getCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError(
                    IllegalClassTypeException.ERROR_ILLEGAL_CLASS_TYPE));
        }

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
        assertEquals(10, sqlMapTemp.getSkipResults());
        assertEquals(100, sqlMapTemp.getMaxResults());
    }

    /**
     * testExecuteForMapArrayStringObjectintint01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () beginIndex:10<br>
     * () maxCount:100<br>
     * 
     * <br>
     * ҒlF(߂l) Mapz<br>
     * [0]=Map["abc","123"]<br>
     * (ԕω) executeForObjectArray̌ďomF:sqlIdA bindParams,
     * Map.class,beginIndex, maxCountŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * ł́AexecuteForObjectArrayĂяoĂ邽߁A
     * eXgexecuteForObjectArraỹeXgP[Xɕ܂B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForMapArrayStringObjectintint01() throws Exception {
        // O
        dao = new QueryDAOiBatisImpl_QueryDAOiBatisImplStub01();

        // eXg{
        Map<String, Object>[] map = dao.executeForMapArray("sqlId", "1", 10,
                100);

        // 
        assertTrue(map[0].containsKey("abc"));
        assertEquals("123", map[0].get("abc"));
        assertTrue(((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .isCalled());
        assertEquals("sqlId",
                ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao).getSqlID());
        assertEquals("1", ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .getBindParams());
        assertEquals(Map.class.getName(),
                ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao).getClazz()
                        .getName());
        assertEquals(10, ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .getBeginIndex());
        assertEquals(100, ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .getMaxCount());
    }

    /**
     * testExecuteForObjectListStringObjectClass01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.String"<br>
     * () queryForList̖߂List:not null<br>
     * [String("a"),String("b"), String("c")]<br>
     * 
     * <br>
     * ҒlF(߂l) List<E>:String("a")<br>
     * String("b")<br>
     * String("c")<br>
     * (ԕω) queryForLisťďomF:sqlIdAbindParams
     * ĂяoĂ鎖mF<br>
     * 
     * <br>
     * queryForList̖߂肪not null̏ꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObjectListStringObjectClass01() 
            throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        List<String> str = dao.executeForObjectList("sqlId", "1");

        // ߂l̊mF
        assertEquals("a", str.get(0));
        assertEquals("b", str.get(1));
        assertEquals("c", str.get(2));

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testExecuteForMapListStringObject01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * 
     * <br>
     * ҒlF(߂l) MapList<br>
     * List.get(0)=Map["abc","123"]<br>
     * (ԕω) executeForObjectLisťďomF:sqlIdA bindParams,
     * Map.classŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * ł́AexecuteForObjectListĂяoĂ邽߁A
     * eXgexecuteForObjectList̃eXgP[Xɕ܂B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForMapListStringObject01() throws Exception {
        // O
        dao = new QueryDAOiBatisImpl_QueryDAOiBatisImplStub01();

        // eXg{
        List<Map<String, Object>> map = dao.executeForMapList("sqlId", "1");

        // 
        assertTrue(map.get(0).containsKey("abc"));
        assertEquals("123", map.get(0).get("abc"));
        assertTrue(((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .isCalled());
        assertEquals("sqlId",
                ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao).getSqlID());
        assertEquals("1", ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .getBindParams());
    }

    /**
     * testExecuteForObjectListStringObjectClassintint01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () clazz:"java.lang.String"<br>
     * () beginIndex:10<br>
     * () maxCount:100<br>
     * () queryForList̖߂List:not null<br>
     * [String("a"),String("b"), String("c")]<br>
     * 
     * <br>
     * ҒlF(߂l) List<E>:String("a")<br>
     * String("b")<br>
     * String("c")<br>
     * (ԕω) queryForLisťďomF:sqlID, bindParams, beginIndex,
     * maxCountŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * queryForList̖߂肪not nullŁAclazž^̔zɕϊłꍇ <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForObjectListStringObjectClassintint01()
            throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new QueryDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        List<String> str = dao.executeForObjectList("sqlId", "1", 
                10, 100);

        // ߂l̊mF
        assertEquals("a", str.get(0));
        assertEquals("b", str.get(1));
        assertEquals("c", str.get(2));

        // ĂяomF
        QueryDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp =
            (QueryDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
        assertEquals(10, sqlMapTemp.getSkipResults());
        assertEquals(100, sqlMapTemp.getMaxResults());
    }

    /**
     * testExecuteForMapListStringObjectintint01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() sqlID:"sqlId"<br>
     * () bindParams:"1"<br>
     * () beginIndex:10<br>
     * () maxCount:100<br>
     * 
     * <br>
     * ҒlF(߂l) MapList<br>
     * List.get(0)=Map["abc","123"]<br>
     * (ԕω) executeForObjectLisťďomF:sqlIdA bindParams,
     * Map.class,beginIndex, maxCountŌĂяoĂ鎖mF<br>
     * 
     * <br>
     * ł́AexecuteForObjectListĂяoĂ邽߁A
     * eXgexecuteForObjectList̃eXgP[Xɕ܂B <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testExecuteForMapListStringObjectintint01() throws Exception {
        // O
        dao = new QueryDAOiBatisImpl_QueryDAOiBatisImplStub01();

        // eXg{
        List<Map<String, Object>> map = dao.executeForMapList("sqlId", "1", 10,
                100);

        // 
        assertTrue(map.get(0).containsKey("abc"));
        assertEquals("123", map.get(0).get("abc"));
        assertTrue(((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .isCalled());
        assertEquals("sqlId",
                ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao).getSqlID());
        assertEquals("1", ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .getBindParams());

        assertEquals(10, ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .getBeginIndex());
        assertEquals(100, ((QueryDAOiBatisImpl_QueryDAOiBatisImplStub01) dao)
                .getMaxCount());
    }
    
}
