/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.fw.util.PropertyUtil;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessages;

/**
 * <p>
 *  1[UقȂ郆[XP[X̉ʂ𑀍삵AG[EbZ[W̃|bv
 *  Abv\ɍsƂAZbVɃ[XP[X̃G[E
 *  bZ[W񂪌ĕ\Ă܂B<br>
 *  ̃^O&lt;ts:errors&gt;^OAy&lt;ts:messages&gt;^O
 *  gݍ킹鎖ɂAʒPʂŔ|bvAbvG[̍
 *  邱Ƃ\ƂȂB<br>
 *  {@link MessagesPopupTag}́ANGXgƂēo^Ă
 *  G[EbZ[WZbVɕۑB
 * </p>
 * <p>
 *  {@link MessagesPopupTag} ́A<code>&lt;ts:body&gt;</code>
 *  ^OƘAgă|bvAbvʂJB
 *  {@link MessagesPopupTag} pۂɂ́AK
 *  <code>&lt;ts:body&gt;</code>^OƋɗpA܂A
 *  {@link MessagesPopupTag} <code>&lt;ts:body&gt;</code>^O
 *  OɋLqȂĂ͂ȂȂB
 * </p>
 * <p>
 *  {@link MessagesPopupTag} ́A<code>JavaScript</code> 
 *  <code>onLoad</code>Cxg̃XNvgǉ邱ƂŁA
 *  G[EbZ[W\p̃|bvAbvʂJB<br>
 *  ]āAG[EbZ[W\p̃|bvAbvʂ\ہA
 *  L̎菇B̂߁AG[EbZ[W\Ỏʂł͖A
 *  G[EbZ[W̑Jڐʂɂ̃^Ozu悤ӂ
 *  ƁB<br>
 * <ol>
 *  <li>
 *   U͂ɑ΂錋ʉʂԂB
 *  </li>
 *  <li>
 *   ̌ʉʂ<code>onLoad</code>CxgŃ|bvAbvʂJB
 *  </li>
 *  <li>
 *   G[EbZ[W\p̃NGXg炽߂ăT[oɑMB
 *  </li>
 * </ol>
 * </p>
 * <p>
 *  {@link MessagesPopupTag} ́A<code>&lt;ts:body&gt;</code> ^O
 *  {<code>onLoad</code>CxgXNvgɏ㏑B
 *  <code>JSP</code>  {@link MessagesPopupTag}̑O
 *  <code>onLoad</code> ^Oꍇɂ́AG[ȂƂɂ
 *  <code>onLoad</code> ^ÕXNvgLɂȂA
 *  G[ꍇɂ {@link MessagesPopupTag} ɂݒŏ㏑A
 *  G[\p̃|bvAbvʂD悳B
 * </p>
 * <h5>^OT|[g鑮</h5>
 * <p>{@link MessagesPopupTag} ł́Aȉ̑T|[gB</p>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Tv</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>popup</code> </td>
 *    <td> - </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     |bvAbvʂŕ\URLB<code>JavaScript</code>
 *     <code>window.open()</code>̑ɑΉB<br>
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>title</code> </td>
 *    <td> <code>popup</code> </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     G[\|bvAbvʂ̃^CgB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>param</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     <code>JavaScript</code> Ń|bvAbvʂJƂ̃p[^B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>paramType</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     <code>JavaScript</code> Ń|bvAbvʂJƂ̃p[^A
 *     <code>ApplicationResources</code> t@C擾ꍇ
 *     \[XL[B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>paramFunc</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     <code>JavaScript</code> Ń|bvAbvʂJƂ
 *     p[^擾 <code>JavaScript</code> ֐B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>windowId</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     J|bvAbvʂێ <code>JavaScript</code> ϐB
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 * <br><br>
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 *
 * <p><code><pre>
 * &lt;ts:messagesPopup popup="/popup/errors.do" /&gt;
 *   ...
 * &lt;ts:body ...&gt;
 * </pre></code></p>
 *
 * @see jp.terasoluna.fw.web.struts.taglib.BodyTag
 *
 */
public class MessagesPopupTag extends TagSupport {
    
    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 1148524236499924202L;

    /**
     * <code>onLoad</code> ̏NGXgɕۑƂ̃L[B
     */
    public static final String ON_LOAD_KEY = BodyTag.ON_LOAD_KEY;

    /**
     * |bvAbvɃNGXgp[^œnG[̃L[B
     */
    public static final String POPUP_ERROR_KEY = "popup_error_key";

    /**
     * |bvAbvɃNGXgp[^œn郁bZ[W̃L[B
     */
    public static final String POPUP_MESSAGE_KEY = "popup_message_key";

    /**
     * ftHg^CgBĺA<code>popup</code>B
     */
    private static final String DEFAULT_TITLE = "popup";

    /**
     * |bvAbvʂŕ\URLBReLXgpX͊܂܂ȂB
     */
    private String popup = null;

    /**
     * G[EbZ[W\|bvAbvʂ̃^CgB
     */
    private String title = DEFAULT_TITLE;

    /**
     * <code>JavaScript</code>
     * Ń|bvAbvʂJƂ̃p[^B
     */
    private String param = null;

    /**
     * <code>JavaScript</code>
     * Ń|bvAbvʂJƂ̃p[^
     * 擾 <code>JavaScript</code> ֐B
     */
    private String paramFunc = null;

    /**
     * J|bvAbvʂێ <code>JavaScript</code> ϐB
     */
    private String windowId = null;

    /**
     * |bvAbvʂŕ\URLݒ肷B
     *
     * @param value |bvAbvʂŕ\URL
     */
    public void setPopup(String value) {
        this.popup = value;
    }

    /**
     * G[\|bvAbvʂ̃^Cgݒ肷B
     *
     * @param value ^Cg
     */
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * <code>JavaScript</code>
     * Ń|bvAbvʂJƂ̃p[^ݒ肷B
     *
     * @param value p[^
     */
    public void setParam(String value) {
        this.param = value;
    }

    /**
     * <code>JavaScript</code>
     * Ń|bvAbvʂJƂ̃p[^A
     * <code>ApplicationResources</code> t@C擾Đݒ肷B
     *
     * @param value p[^
     */
    public void setParamType(String value) {
        this.param = PropertyUtil.getProperty("messages.popup.param." + value);
    }

    /**
     * <code>JavaScript</code>
     * Ń|bvAbvʂJƂ̃p[^ƂāA
     * w肳ꂽ<code>JavaScript</code> ֐̖߂lݒ肷B
     *
     * @param value p[^
     */
    public void setParamFunc(String value) {
        this.paramFunc = value;
    }

    /**
     * J|bvAbvʂێ <code>JavaScript</code>
     * ϐݒ肷B
     *
     * @param value ϐ
     */
    public void setWindowId(String value) {
        this.windowId = value;
    }

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return wB <code>EVAL_BODY_INCLUDE</code>
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {
        HttpServletRequest req
            = (HttpServletRequest) pageContext.getRequest();

        if (req.getAttribute(Globals.ERROR_KEY) == null
                && req.getAttribute(Globals.MESSAGE_KEY) == null) {
            // NGXgɃG[EbZ[W
            // ݂ȂƂAȍ~͍̏sȂB
            return EVAL_BODY_INCLUDE;
        }

        ActionMessages errors =
            (ActionMessages) req.getAttribute(Globals.ERROR_KEY);

        ActionMessages messages =
            (ActionMessages) req.getAttribute(Globals.MESSAGE_KEY);

        String errorKey = null;
        String messageKey = null;

        HttpSession session
             = pageContext.getSession();
        if (errors != null && !errors.isEmpty()) {
            errorKey = RandomUtil.generateRandomID();
            // ZbVɃG[ۑB
            session.setAttribute(errorKey, errors);
        }
        if (messages != null && !messages.isEmpty()) {
            messageKey = RandomUtil.generateRandomID();
            // ZbVɃbZ[WۑB
            session.setAttribute(messageKey, messages);
        }

        // <body>^OonLoadŎw肳XNvg
        // 擾B
        String script = getOnLoadScript(req, errorKey, messageKey);
        req.setAttribute(ON_LOAD_KEY, script);

        return EVAL_BODY_INCLUDE;
    }

    /**
     * <code>&lt;body&gt;</code>^O<code>onLoad</code>
     * LqEBhEI[v̂߂̃XNvg𐶐B
     *
     * @param req HTTPNGXg
     * @param errorKey G[̃L[
     * @param messageKey bZ[W̃L[
     * @return EBhEI[vsXNvg
     */
    private String getOnLoadScript(HttpServletRequest req,
            String errorKey, String messageKey) {

        // G[EbZ[W̃L[
        // ݂ȂꍇAIB
        if (errorKey == null && messageKey == null) {
            return null;
        }

        StringBuilder onLoad = new StringBuilder();
        onLoad.append("  ");
        if (this.windowId != null) {
            // EBhEIDiXNvg̖߂li[j
            onLoad.append(this.windowId);
            onLoad.append(" = ");
        }
        onLoad.append("window.open(\"");
        // URLw
        onLoad.append(req.getContextPath());
        onLoad.append(this.popup);
        // G[EbZ[Ŵꂩ݂鎞A
        // NGXgp[^ŃL[𑗐MB
        onLoad.append(getRequestParameterKey(errorKey,
            messageKey));
        onLoad.append("\", \"");
        if (this.title != null) {
            // EBhE^Cg\w
            onLoad.append(this.title);
        }
        onLoad.append("\", ");
        if (this.paramFunc != null) {
            // JavaScript֐̖߂lw
            onLoad.append(this.paramFunc);
        } else {
            onLoad.append("\"");
            if (this.param != null) {
                // |bvAbvʂ̃TCYAʒuȂǂ
                // p[^w
                onLoad.append(this.param);
            }
            onLoad.append("\"");
        }
        onLoad.append(");" + System.getProperty("line.separator"));

        return onLoad.toString();
    }

    /**
     * ZbVɊi[ĂG[EbZ[W
     * ̃L[ɁANGXgp[^
     * NG쐬B
     *
     * @param errorKey G[L[
     * @param messageKey bZ[WL[
     * @return NGXgp[^ƂđMNG
     */
    private String getRequestParameterKey(String errorKey,
            String messageKey) {

        StringBuilder param = new StringBuilder();
        param.append("?");
        if (errorKey != null) {
            param.append(POPUP_ERROR_KEY);
            param.append("=");
            param.append(errorKey);
        }
        if (errorKey != null && messageKey != null) {
            // G[L[EbZ[WL[
            // ݂ꍇ̂݁AAǉB
            param.append("&");
        }
        if (messageKey != null) {
            param.append(POPUP_MESSAGE_KEY);
            param.append("=");
            param.append(messageKey);
        }

        return param.toString();
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return wB <code>EVAL_PAGE</code>
     * @throws JspException JSPO
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

    /**
     * ^Onh̏B
     */
    @Override
    public void release() {
        super.release();
        this.popup = null;
        this.title = DEFAULT_TITLE;
        this.param = null;
        this.paramFunc = null;
        this.windowId = null;
    }

}
