/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ZbV̏̓sB
 * <p>
 * ZbV̏𕡐XbhœɎsȂꍇɁÃtB^gpB<br>
 * ZbVXR[ṽANVtH[gpꍇAZbV̏𕡐XbhœɎsׂł͂Ȃ߁ÃtB^gpB<br>
 * (ZbVXR[ṽANVtH[gpꍇAZbV̏𕡐XbhœɎsƁA͒l؂ʂAActionBLogic̏ɈڂOɁAANVtH[\B)<br>
 * </p>
 * <p>
 * ̃tB^ł́AQ̃bN񋟂ĂB<br>
 * <ul>
 * <li>{@link LimitedLock}ɂ郍bN(bN҂XbhۂɁAÂbN҂Xbh𒆒f@\bN)</li>
 * <li>synchronizedubNɂ郍bN</li>
 * </ul>
 * ftHgł́A{@link LimitedLock}(l=2)ɂ郍bNgpB<br>
 * {@link LimitedLock}̃bN₵lÃbN݈̑Ӌ`́A{@link LimitedLock}QƂ̂ƁB
 * </p>
 * <p>
 * {@link LimitedLock}̂l̕ύXAsynchronizedubNɂ郍bNւ̐؂ւ́ÃtB^̏p[^thresholdɂčsB<br>
 * threshold0̏ꍇ́Athreshold̒llƂĎgpA{@link LimitedLock}ɂ郍bNsB<br>
 * threshold0̏ꍇ́AsynchronizedubNɂ郍bNsB<br>
 * thresholdɂ͐lݒ肷邱ƁB
 * </p>
 * <p>
 * {@link LimitedLock}̋@\ɂAbN҂fꂽXbhł́AX|XƂāÃX|XR[hԂƂłB܂AfvCgfBXNv^&lt;error-page&gt;vfLq邱ƂɂA
 * X|XR[hɑΉG[y[W蓖Ă邱ƂłB<br>
 * A[UZbVŕEBhE𑀍삵ȂAbN҂fꂽXbhɂāAX|XɉԂĂA[Uɂ͌ȂB<br>
 * (ŐṼNGXgɑ΂郌X|XuEUɕ\邪AŐṼNGXg悤ƂĂXbh͒fΏۂɂȂȂBbN҂fꂽXbh́AÂNGXĝłAuEU͂̃X|X𖳎B)
 * ftHgł́AbN҂f̃X|XR[h503(ߕ׏ԂňꎞIɏsłȂԂł邱Ƃ\X|XR[h)ƂȂĂB<br>
 * X|XR[h̐ݒ́ÃtB^̏p[^interruptResponseCodeɂčsB<br>
 * interruptResponseCodeɂ͐lݒ肷邱ƁB܂ÃNXł͒l͈̔͂𐧌ȂAJavaEET[ogpł郌X|XR[hݒ肷邱ƁB<br>
 * </p>
 * <h5>gp@</h5> ̋@\gpɂ̓fvCgfBXNv^iweb.xmljɈȉ̂悤 ݒ肷B<br>
 * <br>
 * <code><pre>
 * &lt;filter&gt;
 *   &lt;filter-name&gt;sessionLockControlFilter&lt;/filter-name&gt;
 *   &lt;filter-class&gt;jp.terasoluna.fw.web.thin.SessionLockControlFilter&lt;/filter-class&gt;
 *   &lt;init-param&gt;
 *     &lt;param-name&gt;interruptResponseCode&lt;/param-name&gt;
 *     &lt;param-value&gt;503&lt;/param-value&gt;
 *   &lt;/init-param&gt;
 *   &lt;init-param&gt;
 *     &lt;param-name&gt;threshold&lt;/param-name&gt;
 *     &lt;param-value&gt;2&lt;/param-value&gt;
 *   &lt;/init-param&gt;
 * &lt;/filter&gt;
 * 
 * &lt;filter-mapping&gt;
 *   &lt;filter-name&gt;sessionLockControlFilter&lt;/filter-name&gt;
 *   &lt;url-pattern&gt;*.do&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 * 
 * &lt;error-page&gt;
 *   &lt;error-code&gt;503&lt;/error-code&gt;
 *   &lt;location&gt;/error.jsp&lt;/location&gt;
 * &lt;/error-page&gt;
 * </pre></code> <br>
 * ȂAep[^ɂāAftHgl(interruptResponseCode=503Athreshold=2)𗘗pꍇ́A fvCgfBXNv^
 * iweb.xmlj&lt;filter&gt;vf&lt;init-param&gt;vfȗ邱ƂłB<br>
 * ܂AG[y[Wݒ肵Ȃꍇ́A&lt;error-page&gt;vfȗ邱ƂłB
 * @see LimitedLock
 */
public class SessionLockControlFilter implements Filter {

    /**
     * ONXB
     */
    private static final Log log = LogFactory
            .getLog(SessionLockControlFilter.class);

    /**
     * p[^FinterruptResponseCodeB
     */
    private static final String INIT_PARAM_INTERRUPT_RESPONSE_CODE = "interruptResponseCode";

    /**
     * p[^FthresholdB
     */
    private static final String INIT_PARAM_THRESHOLD = "threshold";

    /**
     * p[^interruptResponseCodẽftHgl(503)B
     */
    private static final int DEFAULT_INTERRUPT_RESPONSE_CODE = HttpServletResponse.SC_SERVICE_UNAVAILABLE; // 503

    /**
     * p[^threshold̃ftHgl(2)B
     */
    private static final int DEFAULT_THRESHOLD = 2;

    /**
     * p[^interruptResponseCodeB
     * <p>
     * bN҂f̃X|XR[hB
     * </p>
     */
    private int interruptResponseCode = DEFAULT_INTERRUPT_RESPONSE_CODE;

    /**
     * p[^thresholdB
     * <p>
     * 0ȏ̂ƂA{@link LimitedLock}ɓnlƂȂB<br>
     * 0̂ƂA{@link LimitedLock}gpAsynchronizedubNgpB
     * </p>
     */
    protected int threshold = DEFAULT_THRESHOLD;

    /**
     * ZbVɗpĂ{@link LimitedLock}̎QƃL[B
     * <p>
     * ZbVɗpĂ{@link LimitedLock}CX^XQƂȂȂAKx[WRN^ɉƂAKx[WRN^ɂāA {@link LimitedLock}CX^XێĂ
     * {@link SessionLockReference}̎QƃL[ɒǉB<br>
     * {@link limitedLockMap}ŕsvɂȂGg[폜ۂɗpB
     * </p>
     */
    private ReferenceQueue<LimitedLock> sessionLockRefQueue = new ReferenceQueue<LimitedLock>();

    /**
     * {@link LimitedLock}̎Qƃ}bvB
     * <p>
     * L[̓ZbVIDAĺA{@link LimitedLock}ւ̎QƂł{@link SessionLockReference}B<br>
     * ZbVIDp{@link LimitedLock}CX^XpӂꍇA{@link SessionLockReference}ɃbvĂ炱̃}bvputB<br>
     * ́AZbVIDpɗpӂ{@link LimitedLock}Aꂩ̃XbhŎgpłꍇA ̃}bvÃZbVIDL[{@link SessionLockReference}AɁA
     * {@link SessionLockReference}ÃZbVIDp{@link LimitedLock}擾\łB<br>
     * ́AZbVIDpɗpӂ{@link LimitedLock}Aǂ̃XbhQƂĂȂƂA{@link LimitedLock}̓Kx[WRN^ɂĉ\ƂȂB<br>
     * {@link LimitedLock}Kx[WRN^ɉꂽꍇÃ}bv瓾ꂽ{@link SessionLockReference}́A{@link LimitedLock}𓾂邱ƂłȂB<br>
     * ̏ꍇA{@link LimitedLock}擾łȂGg[ꎞIɎc邪AsessionLockRefQueueƘAg邱ƂɂAsvɂȂGg[́Aɍ폜B
     * </p>
     */
    private ConcurrentHashMap<String, SessionLockReference> limitedLockMap = new ConcurrentHashMap<String, SessionLockReference>();

    /**
     * ZbV̏̓sB
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain tB^`F[
     * @throws IOException I/OG[
     * @throws ServletException T[ubgO
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse,
     *      javax.servlet.FilterChain)
     */
    public void doFilter(ServletRequest req, ServletResponse res,
            FilterChain chain) throws IOException, ServletException {
        HttpSession session = ((HttpServletRequest) req).getSession(false);
        if (session != null) {
            // ZbVpĂ邩LȂ̂ŁAsB
            if (threshold < 0) {
                // l𖳌ɂĂꍇA
                // ҂Xbh܂ĂAȂA
                // Psynchronizedɂ铯sB
                log.debug("use synchronized lock.");
                synchronized (session.getId().intern()) {
                    chain.doFilter(req, res);
                }
            } else {
                // gɂȂASessionLockReferencelɂA
                // limitedLockMap̃Gg[폜B
                // (LimitedLockQƂĂȂԂŁAGCƂ(LimitedLockCX^XꂽƂ)ɁA
                // SessionLockReference̒g͋ɂȂB)
                SessionLockReference oldRef = null;
                while ((oldRef = (SessionLockReference) sessionLockRefQueue
                        .poll()) != null) {

                    // limitedLockMap̃Gg[폜ėǂ̂ł邩A
                    // mFĂ폜B
                    // (LimitedLockQƂȂȂĂA
                    // SessionLockReference(WeakReference)ReferenceQueueɓ܂łɂ
                    // Ȃ̃^CÔŁA
                    // limitedLockMapSessionLockReferenceɍւĂȂAŊmFB)
                    // mF폜܂ł̊ԂɁAZbVIDputƁAč폜˂Ȃ̂ŁA
                    // putɂbNĂAZbVIDŃbNB
                    synchronized (oldRef.getSessionId().intern()) {
                        if (oldRef == limitedLockMap.get(oldRef.getSessionId())) {
                            limitedLockMap.remove(oldRef.getSessionId());
                        }
                        if (log.isDebugEnabled()) {
                            log
                                    .debug("LimitedLock is deallocated. sessionId = "
                                            + oldRef.getSessionId()
                                            + ", SessionLockReference = "
                                            + oldRef);
                        }
                    }
                }

                LimitedLock lock = null;
                synchronized (session.getId().intern()) {
                    SessionLockReference sessionLockRef = limitedLockMap
                            .get(session.getId());
                    if (sessionLockRef != null) {
                        lock = sessionLockRef.get();
                    }
                    if (lock == null) {
                        lock = createLimitedLock();
                        sessionLockRef = new SessionLockReference(session
                                .getId(), lock, sessionLockRefQueue);

                        limitedLockMap.put(session.getId(), sessionLockRef);
                        if (log.isDebugEnabled()) {
                            log.debug("LimitedLock is allocated. sessionId = "
                                    + session.getId() + ", "
                                    + INIT_PARAM_THRESHOLD + " = " + threshold
                                    + ", SessionLockReference = "
                                    + sessionLockRef);
                        }
                    }
                }

                try {
                    log.debug("use LimitedLock.");
                    lockLimitedLock((HttpServletRequest) req, lock);
                    chain.doFilter(req, res);
                } catch (InterruptedException e) {
                    // ZbVŏĂԂɁA
                    // xdȂ郊[hŁAbN҂Xbh臒l𒴂߁A
                    // ÂNGXgɑ΂鏈sA
                    // Œ背X|XԂďIB
                    log.info("interrupt wait for lock.");
                    if (interruptResponseCode >= 0) {
                        ((HttpServletResponse) res)
                                .sendError(interruptResponseCode);
                    }
                } finally {
                    unlockLimitedLock((HttpServletRequest) req, lock);
                }
            }
        } else {
            log.debug("not lock.");
            chain.doFilter(req, res);
        }
    }

    /**
     * LimitedLockCX^X𐶐B
     * <p>
     * LimitedLockgꍇÃ\bhI[o[ChALimitedLockgNX̃CX^XԂ悤gB
     * </p>
     * @return LimitedLockCX^X
     */
    protected LimitedLock createLimitedLock() {
        return new LimitedLock(threshold);
    }

    /**
     * LimitedLock̃bN擾B
     * <p>
     * bN擾Oɏǉg_B<br>
     * KvɉāÃ\bhg邱ƁB<br>
     * </p>
     * <p>
     * g)<br>
     * X|XԂOɁACӂ̏ꏊŃbNꍇAtB^ȊOAbN擾ĂLimitedLockɃANZXꍇALimitedLockNGXgɐݒ肷悤gB
     * </p>
     * @param request HTTPNGXg
     * @param lock LimitedLockCX^X
     * @throws InterruptedException ݂̃XbhŊ荞݂ꍇ(LimitedLock̋@\ɂAbN҂fꂽꍇ܂)
     */
    protected void lockLimitedLock(HttpServletRequest request, LimitedLock lock)
                                                                                throws InterruptedException {
        lock.lockInterruptibly();
    }

    /**
     * LimitedLock̃bNB
     * <p>
     * bNOɏǉg_B<br>
     * KvɉāÃ\bhg邱ƁB
     * </p>
     * @param request HTTPNGXg
     * @param lock LimitedLockCX^X
     */
    protected void unlockLimitedLock(HttpServletRequest request,
            LimitedLock lock) {
        lock.unlock();
    }

    /**
     * tB^T[rXJnԂɂȂۂɁAReiɂČĂяoB ReíAFilterCX^XɁAinit\bh 1 񂾂ĂяoB<br>
     * FilterɃtB^Ƃs悤ɗvɂ́A init \bh IĂȂ΂ȂȂB init\bh ̂ꂩ̏Ԃ̏ꍇARei FilterT[rXԂɂłȂB<br>
     * <ul>
     * <li>ServletException X[B</li>
     * <li>ReiɂĒ`ꂽԓɁAAȂB</li>
     * <li>ݒُ펞B</li>
     * </ul>
     * @param config FilterConfigCX^XB
     * @throws javax.servlet.ServletException ُ펞ɃX[OB
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     * @see jp.terasoluna.fw.web.thin.AbstractControlFilter
     */
    public void init(FilterConfig config) throws ServletException {
        String interruptResponseCodeStr = config
                .getInitParameter(INIT_PARAM_INTERRUPT_RESPONSE_CODE);
        if (interruptResponseCodeStr != null) {
            interruptResponseCode = Integer.parseInt(interruptResponseCodeStr);
        }

        String thresholdStr = config.getInitParameter(INIT_PARAM_THRESHOLD);
        if (thresholdStr != null) {
            threshold = Integer.parseInt(thresholdStr);
        }

        if (log.isDebugEnabled()) {
            log.debug(INIT_PARAM_INTERRUPT_RESPONSE_CODE + " = "
                    + interruptResponseCode + ".");
            if (threshold >= 0) {
                log.debug(INIT_PARAM_THRESHOLD + " = " + threshold
                        + ". LimitedLock is enabled.");
            } else {
                log.debug(INIT_PARAM_THRESHOLD + " = " + threshold
                        + ". LimitedLock is disabled. Reason: "
                        + INIT_PARAM_THRESHOLD + " is negative number.");
            }
        }
    }

    /**
     * T[rXԂItB^ɓ`邽߂ɁAReiĂяoB<br>
     * ̃NXł͏͍sȂȂB
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy() {
        // ɂȂ
    }
}
