/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.thin.BLogicIO} NX
 * ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * rWlXWbNo͏ێNXB<br>
 * BLogicIOPlugInŃrWlXWbNo͏`t@Cłblogic-io.xmlA
 * ANVpXƂ̃ANVNꂽ̓͏Ao͏ێB
 * <p>
 * 
 * @see jp.terasoluna.fw.service.thin.BLogicIO
 */
public class BLogicIOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BLogicIOTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BLogicIOTest(String name) {
        super(name);
    }

    /**
     * testGetInputBeanName01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () inputBeanName:"inputBeanName"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"inputBeanName"<br>
     *         
     * <br>
     * BLogicIOɊi[ĂinputBeanName𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetInputBeanName01() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // pathݒ
        UTUtil.setPrivateField(blogicIO, "inputBeanName", "inputBeanName");

        // eXgsEʊmF
        assertEquals("inputBeanName", blogicIO.getInputBeanName());
    }

    /**
     * testSetInputBeanName01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() inputBeanName:"inputBeanName"<br>
     *         () inputBeanName:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) inputBeanName:"inputBeanName"<br>
     *         
     * <br>
     * Ɏw肵lBLogicIOinputBeanNameɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetInputBeanName01() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // eXgs
        blogicIO.setInputBeanName("inputBeanName");

        // eXgʊmF
        assertEquals("inputBeanName", UTUtil.getPrivateField(blogicIO,
                "inputBeanName"));
    }

    /**
     * testGetPath01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () path:"path"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"path"<br>
     *         
     * <br>
     * BLogicIOɊi[Ăpath𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetPath01() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // pathݒ
        UTUtil.setPrivateField(blogicIO, "path", "path");

        // eXgsEʊmF
        assertEquals("path", blogicIO.getPath());
    }

    /**
     * testSetPath01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() path:"path"<br>
     *         () path:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) path:"path"<br>
     *         
     * <br>
     * Ɏw肵lBLogicIOpathɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetPath01() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // eXgs
        blogicIO.setPath("path");

        // eXgʊmF
        assertEquals("path", UTUtil.getPrivateField(blogicIO, "path"));
    }

    /**
     * testGetBLogicParams01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () blogicParams:List<BLogicProperty>IuWFNg<br>
     *         
     * <br>
     * ҒlF(߂l) List:OƓList<BLogicProperty>IuWFNg<br>
     *         
     * <br>
     * BLogicIOɊi[ĂblogicParams𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicParams01() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // blogicParamsݒ
        List<BLogicProperty> list = new ArrayList<BLogicProperty>();
        BLogicProperty blogicProperty = new BLogicProperty();
        list.add(blogicProperty);
        UTUtil.setPrivateField(blogicIO, "blogicParams", list);

        // eXgsEʊmF
        assertSame(list, blogicIO.getBLogicParams());
    }

    /**
     * testGetBLogicResults01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () blogicResults:List<BLogicProperty>IuWFNg<br>
     *         
     * <br>
     * ҒlF(߂l) List:OƓList<BLogicProperty>IuWFNg<br>
     *         
     * <br>
     * BLogicIOɊi[ĂblogicResults𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicResults01() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // blogicResultsݒ
        List<BLogicProperty> list = new ArrayList<BLogicProperty>();
        BLogicProperty blogicProperty = new BLogicProperty();
        list.add(blogicProperty);
        UTUtil.setPrivateField(blogicIO, "blogicResults", list);

        // eXgsEʊmF
        assertSame(list, blogicIO.getBLogicResults());
    }

    /**
     * testSetBLogicParam01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() blogicParam:BlogicProperty[property="property"]<br>
     *         () blogicParams:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) blogicParams:w肵BLogicPropertyCX^X1ԖڂɊi[Ă<br>
     *         
     * <br>
     * Ɏw肵lBLogicIOblogicParamsɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBLogicParam01() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // BlogicProperty쐬
        BLogicProperty blogicParam = new BLogicProperty();
        UTUtil.setPrivateField(blogicParam, "blogicProperty", "BlogicProperty");

        // eXgs
        blogicIO.setBLogicParam(blogicParam);

        // eXgʊmF
        List resultList = (List) UTUtil.getPrivateField(blogicIO,
                "blogicParams");
        assertEquals(1, resultList.size());
        BLogicProperty resultBlogicProperty = (BLogicProperty) resultList
                .get(0);
        assertEquals("BlogicProperty", UTUtil.getPrivateField(
                resultBlogicProperty, "blogicProperty"));
    }

    /**
     * testSetBLogicParam02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicParam:null<br>
     *         () blogicParams:1ݒ肳ꂽXg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) blogicParams:null2ԖڂɊi[Ă<br>
     *         
     * <br>
     * Ɏw肵lBLogicIOblogicParamsɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBLogicParam02() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // blogicParamsݒ
        List<BLogicProperty> list = new ArrayList<BLogicProperty>();
        BLogicProperty blogicProperty = new BLogicProperty();
        list.add(blogicProperty);
        UTUtil.setPrivateField(blogicIO, "blogicParams", list);
        
        // eXgs
        blogicIO.setBLogicParam(null);

        // eXgʊmF
        List resultList = (List) UTUtil.getPrivateField(blogicIO,
                "blogicParams");
        assertEquals(2, resultList.size());
        assertNull(((List) UTUtil.getPrivateField(blogicIO, "blogicParams"))
                .get(1));

    }

    /**
     * testSetBLogicResult01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() blogicResult:BlogicProperty[property="property"]<br>
     *         () blogicResult:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) blogicResults:w肵BLogicPropertyCX^X1ԖڂɊi[Ă<br>
     *         
     * <br>
     * Ɏw肵lBLogicIOblogicResultsɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBLogicResult01() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // BlogicProperty쐬
        BLogicProperty blogicParam = new BLogicProperty();
        UTUtil.setPrivateField(blogicParam, "blogicProperty", "BlogicProperty");

        // eXgs
        blogicIO.setBLogicResult(blogicParam);

        // eXgʊmF
        List resultList = (List) UTUtil.getPrivateField(blogicIO,
                "blogicResults");
        assertEquals(1, resultList.size());
        BLogicProperty resultBlogicProperty = (BLogicProperty) resultList
                .get(0);
        assertEquals("BlogicProperty", UTUtil.getPrivateField(
                resultBlogicProperty, "blogicProperty"));
    }

    /**
     * testSetBLogicResult02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicResult:null<br>
     *         () blogicResult:1ݒ肳ꂽXg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) blogicResults:null2ԖڂɊi[Ă<br>
     *         
     * <br>
     * Ɏw肵lBLogicIOblogicResultsɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBLogicResult02() throws Exception {
        // rWlXWbNo͏
        BLogicIO blogicIO = new BLogicIO();

        // blogicResultsݒ
        List<BLogicProperty> list = new ArrayList<BLogicProperty>();
        BLogicProperty blogicProperty = new BLogicProperty();
        list.add(blogicProperty);
        UTUtil.setPrivateField(blogicIO, "blogicResults", list);
        
        // eXgs
        blogicIO.setBLogicResult(null);

        // eXgʊmF
        List resultList = (List) UTUtil.getPrivateField(blogicIO,
                "blogicResults");
        assertEquals(2, resultList.size());
        assertNull(((List) UTUtil.getPrivateField(blogicIO, "blogicResults"))
                .get(1));

    }

}
