/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web;

import java.util.HashMap;

import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.MockServletContext;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.RequestUtil} NX ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4> RequestɊւ郆[eBeBNXB
 * <p>
 * @see jp.terasoluna.fw.web.RequestUtil
 */
public class RequestUtilTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(RequestUtilTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public RequestUtilTest(String name) {
        super(name);
    }

    /**
     * testGetPathInfo01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/logon.do"<br>
     * () request.getContextPath:"/sample1"<br>
     * <br>
     * ҒlF(߂l) String:"/logon.do"<br>
     * <br>
     * NGXgpX<ReLXg>/<\[X>̌`̏ꍇA /<\[X>擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetPathInfo01() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample1/logon.do");
        req.setContextPath("/sample1");

        // eXgs
        String path = RequestUtil.getPathInfo(req);

        // eXgʊmF
        // ReLXgpXȍ~URI擾ł邱
        assertEquals("/logon.do", path);
    }

    /**
     * testGetPathInfo02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample2"<br>
     * () request.getContextPath:"/sample2"<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * NGXgpX<ReLXg>̌`̏ꍇA 󕶎擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetPathInfo02() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI("/sample2");
        req.setContextPath("/sample2");

        // eXgs
        String path = RequestUtil.getPathInfo(req);

        // eXgʊmF
        // 󕶎񂪎擾ł邱ƁB
        assertEquals("", path);
    }

    /**
     * testGetPathInfo03() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() request:null<br>
     * <br>
     * ҒlF(߂l) String:null<br>
     * <br>
     * requestnull̏ꍇAnull擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetPathInfo03() throws Exception {
        // eXg{
        String path = RequestUtil.getPathInfo(null);

        // 
        assertNull(path);
    }

    /**
     * testGetServletContext01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getSession:not null<br>
     * () session.getServletContext:not null<br>
     * <br>
     * ҒlF(߂l) ServletContext:session擾 T[ubgReLXgCX^X<br>
     * <br>
     * ZbVT[ubgReLXgCX^X擾ł邱Ƃ mFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetServletContext01() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockServletContext ctx = new MockServletContext();
        MockHttpSession session = new MockHttpSession();
        session.setServletContext(ctx);
        req.setSession(session);

        // eXg{
        Object result = RequestUtil.getServletContext(req);

        // 
        assertSame(ctx, result);
    }

    /**
     * testGetServletContext02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() request:null<br>
     * <br>
     * ҒlF(߂l) ServletContext:null<br>
     * <br>
     * requestnull̏ꍇAnull擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetServletContext02() throws Exception {
        // eXg{
        Object result = RequestUtil.getServletContext(null);

        // 
        assertNull(result);
    }

    /**
     * testIsChanged01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/logon/start.do"<br>
     * () request.getAttribute("PREV_PATH_INFO"):"/logon/start.do" <br>
     * <br>
     * ҒlF(߂l) boolean:falseԋp邱ƁB<br>
     * <br>
     * ReLXg[gȉ̊KwƃNGXgɕۑꂽÕpX KwvꍇAfalseԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsChanged01() throws Exception {
        // eXgf[^ݒ
        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();

        // ݂̃ReLXgpX
        req.setContextPath("/sample1");

        // ݂̃NGXgpX
        req.setRequestURI("/sample1/logon/start.do");

        // ÕNGXgpX
        req.setAttribute("PREV_PATH_INFO", "/logon/start.do");

        // eXgs
        boolean result = RequestUtil.isChanged(req);

        // eXgʊmF
        // Ɩ؂ւĂȂƁB
        assertFalse(result);
    }

    /**
     * testIsChanged02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/logon/start.do"<br>
     * () request.getAttribute("PREV_PATH_INFO"):"/logon/end.do"<br>
     * <br>
     * ҒlF(߂l) boolean:falseԋp邱ƁB<br>
     * <br>
     * ReLXg[gȉ̊KwƃNGXgɕۑꂽÕpX KwvꍇAfalseԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsChanged02() throws Exception {
        // eXgf[^ݒ
        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();

        // ݂̃ReLXgpX
        req.setContextPath("/sample1");

        // ݂̃NGXgpX
        req.setRequestURI("/sample1/logon/start.do");

        // ÕNGXgpX
        req.setAttribute("PREV_PATH_INFO", "/logon/end.do");

        // eXgs
        boolean result = RequestUtil.isChanged(req);

        // eXgʊmF
        // Ɩ؂ւĂȂƁB
        assertFalse(result);
    }

    /**
     * testIsChanged03() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/logon/start.do"<br>
     * () request.getAttribute("PREV_PATH_INFO"):"/logout/end.do" <br>
     * <br>
     * ҒlF(߂l) boolean:trueԋp邱ƁB<br>
     * <br>
     * ReLXg[gȉ̊KwƃNGXgɕۑꂽÕpX KwvȂꍇAtrueԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsChanged03() throws Exception {
        // eXgf[^ݒ
        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();

        // ݂̃ReLXgpX
        req.setContextPath("/sample1");

        // ݂̃NGXgpX
        req.setRequestURI("/sample1/logon/start.do");

        // ÕNGXgpX
        req.setAttribute("PREV_PATH_INFO", "/logout/end.do");

        // eXgs
        boolean result = RequestUtil.isChanged(req);

        // eXgʊmF
        // Ɩ؂ւƔf邱ƁB
        assertTrue(result);
    }

    /**
     * testIsChanged04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/logon/start.do"<br>
     * () request.getAttribute("PREV_PATH_INFO"):null<br>
     * <br>
     * ҒlF(߂l) boolean:trueԋp邱ƁB<br>
     * <br>
     * NGXgÕpX擾łȂꍇA trueԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsChanged04() throws Exception {
        // eXgf[^ݒ
        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();

        // ݂̃ReLXgpX
        req.setContextPath("/sample1");

        // ݂̃NGXgpX
        req.setRequestURI("/sample1/logon/start.do");

        // ÕNGXgpX
        req.setAttribute("PREV_PATH_INFO", null);

        // eXgs
        boolean result = RequestUtil.isChanged(req);

        // eXgʊmF
        // Ɩ؂ւƔf邱ƁB
        assertTrue(result);
    }

    /**
     * testIsChanged05() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () request.getRequestURI:"/sample1/service/logon/start.do" <br>
     * () request.getAttribute("PREV_PATH_INFO"): "/service/logout/end.do"<br>
     * <br>
     * ҒlF(߂l) boolean:falseԋp邱ƁB<br>
     * <br>
     * ReLXg[gȉɕ̊KwANGXgɕۑꂽ ÕpXƑKwvꍇAfalseԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsChanged05() throws Exception {
        // eXgf[^ݒ
        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();

        // ݂̃ReLXgpX
        req.setContextPath("/sample1");

        // ݂̃NGXgpX
        req.setRequestURI("/sample1/service/logon/start.do");

        // ÕNGXgpX
        req.setAttribute("PREV_PATH_INFO", "/service/logout/end.do");

        // eXgs
        boolean result = RequestUtil.isChanged(req);

        // eXgʊmF
        // Ɩ؂ւƔf邱ƁB
        assertFalse(result);
    }

    /**
     * testIsChanged06() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() request:null<br>
     * <br>
     * ҒlF(߂l) boolean:trueԋp邱ƁB<br>
     * <br>
     * requestnull̏ꍇAtrue擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsChanged06() throws Exception {
        // eXg{
        boolean result = RequestUtil.isChanged(null);

        // 
        assertTrue(result);
    }

    /**
     * testGetSessionHash01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() req:not null<br>
     * () req.getSession():not null<br>
     * () session.getId():"dummyId"<br>
     * <br>
     * ҒlF(߂l) String:"95E301072238E16FD3FFB3D256D3EA930544C6D7"<br>
     * <br>
     * ZbVID̃nbVl擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetSessionHash01() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // [ZbV
        MockHttpSession session = new MockHttpSession();
        req.setSession(session);

        // eXgs
        String hash = RequestUtil.getSessionHash(req);
        // eXgʊmF
        assertEquals("95E301072238E16FD3FFB3D256D3EA930544C6D7", hash);
    }

    /**
     * testGetSessionHash02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() req:null<br>
     * <br>
     * ҒlF(߂l) String:null<br>
     * <br>
     * requestnull̏ꍇAnull擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetSessionHash02() throws Exception {
        // eXg{
        String result = RequestUtil.getSessionHash(null);

        // 
        assertNull(result);
    }

    /**
     * testDumpRequestAttributes01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() req:null<br>
     * <br>
     * ҒlF(߂l) String:null<br>
     * <br>
     * ̃NGXgnull̏ꍇA<br>
     * null<br>
     * ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestAttributes01() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = null;
        // ɉo^Ȃ

        // eXgs
        String dump = RequestUtil.dumpRequestAttributes(req);
        // eXgʊmF
        assertNull(dump);
    }

    /**
     * testDumpRequestAttributes02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() req:not null<br>
     * () request.getAttributeNames():vfȂ<br>
     * <br>
     * ҒlF(߂l) String:" RequestAttributes {}"<br>
     * <br>
     * ̃NGXg擾ɗvfȂꍇA<br>
     * " RequestAttributes {}"<br>
     * ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestAttributes02() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // ɉo^Ȃ

        // eXgs
        String dump = RequestUtil.dumpRequestAttributes(req);
        // eXgʊmF
        assertEquals(" RequestAttributes {}", dump);
    }

    /**
     * testDumpRequestAttributes03() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() req:not null<br>
     * () request.getAttributeNames():attr0="value0"<br>
     * <br>
     * ҒlF(߂l) String:" RequestAttributes {attr0 = value0}"<br>
     * <br>
     * ̃NGXg擾ɒlString^̗vfꍇA<br>
     * " RequestAttributes {<vf> = <l>}"<br>
     * ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestAttributes03() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // ɓo^B
        req.setAttribute("attr0", "value0");
        // eXgs
        String dump = RequestUtil.dumpRequestAttributes(req);
        // eXgʊmF
        assertEquals(" RequestAttributes {attr0 = value0}", dump);
    }

    /**
     * testDumpRequestAttributes04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() req:not null<br>
     * () request.getAttributeNames():attr0=""<br>
     * <br>
     * ҒlF(߂l) String:" RequestAttributes {attr0 = }"<br>
     * <br>
     * ̃NGXg擾ɗvfAl󕶎̏ꍇA<br>
     * " RequestAttributes {<vf> = }"<br>
     * ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestAttributes04() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // ɓo^B
        req.setAttribute("attr0", "");
        // eXgs
        String dump = RequestUtil.dumpRequestAttributes(req);
        // eXgʊmF
        assertEquals(" RequestAttributes {attr0 = }", dump);
    }

    /**
     * testDumpRequestAttributes05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() req:not null<br>
     * () request.getAttributeNames(): attr0=HashMap(={inner0="inner0"})<br>
     * <br>
     * ҒlF(߂l) String:" RequestAttributes {attr0 = {inner0=inner0}}"<br>
     * <br>
     * ̃NGXg擾ɒlString^ȊO̗vfꍇA " RequestAttributes {<vf> = <ltoStrinǧ>}"<br>
     * ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestAttributes05() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("inner0", "inner0");
        // ɓo^B
        req.setAttribute("attr0", map);
        // eXgs
        String dump = RequestUtil.dumpRequestAttributes(req);
        // eXgʊmF
        assertEquals(" RequestAttributes {attr0 = {inner0=inner0}}", dump);
    }

    /**
     * testDumpRequestAttributes06() <br>
     * <br>
     * (n) <br>
     * ϓ_FB <br>
     * <br>
     * ͒lF() req:not null<br>
     * () request.getAttributeNames():attr0="value0"<br>
     * attr1="value1"<br>
     * attr2="value2"<br>
     * <br>
     * ҒlF(߂l) String:" RequestAttributes {attr0 = value0 , attr1 = value1 , attr2 = value2}"<br>
     * <br>
     * ̃NGXg擾ɕ̗vf̏ꍇA<br>
     * " RequestAttributes {<vf> = <l>*vf}"<br>
     * ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestAttributes06() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        // ɓo^B
        req.setAttribute("attr0", "value0");
        req.setAttribute("attr1", "value1");
        req.setAttribute("attr2", "value2");
        // eXgs
        String dump = RequestUtil.dumpRequestAttributes(req);
        // eXgʊmF
        // String expect = " RequestAttributes {attr1 = value1 , "
        // + "attr2 = value2 , attr0 = value0}";
        assertNotNull(dump);
        assertTrue(dump.startsWith(" RequestAttributes {"));
        assertTrue(dump.endsWith("}"));
        assertTrue(dump.indexOf("attr1 = value1") != -1);
        assertTrue(dump.indexOf("attr2 = value2") != -1);
        assertTrue(dump.indexOf("attr0 = value0") != -1);
        // assertEquals(expect, dump);
    }

    /**
     * testDumpRequestParameters01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() req:null<br>
     * <br>
     * ҒlF(߂l) String:null<br>
     * <br>
     * ̃NGXgnull̏ꍇA<br>
     * null<br>
     * ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestParameters01() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = null;
        // p[^ɓo^Ȃ
        // eXgs
        String dump = RequestUtil.dumpRequestParameters(req);
        // eXgʊmF
        assertNull(dump);
    }

    /**
     * testDumpRequestParameters02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() req:not null<br>
     * () req.getParameterNames():{} (vfȂ:0)<br>
     * <br>
     * ҒlF(߂l) String:" RequestParameters {}"<br>
     * <br>
     * ̃NGXg擾p[^ɗvfȂꍇA " RequestAttributes {}"ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestParameters02() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();

        // eXgs
        String dump = RequestUtil.dumpRequestParameters(req);

        // eXgʊmF
        assertEquals(" RequestParameters {}", dump);
    }

    /**
     * testDumpRequestParameters03() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() req:not null<br>
     * () req.getParameterNames():{"param"}i1j<br>
     * () parameter̓e:param[] = {null}(vfnull:1)<br>
     * <br>
     * ҒlF(߂l) String:" RequestParameters {}"<br>
     * <br>
     * ̃NGXg擾p[^ɗvf1݂A z̗vf1nullłꍇA " RequestAttributes {}"ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestParameters03() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        String value = null;
        // p[^ɓo^
        req.setParameter("param", value);
        // eXgs
        String dump = RequestUtil.dumpRequestParameters(req);
        // eXgʊmF
        assertEquals(" RequestParameters {}", dump);
    }

    /**
     * testDumpRequestParameters04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() req:not null<br>
     * () req.getParameterNames():{"param"}i1j<br>
     * () parameter̓e:param[] = {""}(vf:1)<br>
     * <br>
     * ҒlF(߂l) String:" RequestParameters {param[0] = }"<br>
     * <br>
     * ̃NGXg擾p[^ɗvf1݂A z̗vf1̋󕶎łꍇA "RequestAttributes{<p[^>[0]=}"ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestParameters04() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] values = { "" };
        // p[^ɓo^
        req.setParameter("param", values);
        // eXgs
        String dump = RequestUtil.dumpRequestParameters(req);
        // eXgʊmF
        assertEquals(" RequestParameters {param[0] = }", dump);
    }

    /**
     * testDumpRequestParameters05() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() req:not null<br>
     * () req.getParameterNames():{"param"}i1j<br>
     * () parameter̓e:param[] = {"param0"}(vf:1)<br>
     * <br>
     * ҒlF(߂l) String:"RequestParameters{param[0]=param0}"<br>
     * <br>
     * ̃NGXg擾p[^ɗvf1݂A z̗vf1łꍇA "RequestAttributes{<p[^>[0]=<l>}"ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestParameters05() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] values = { "param0" };
        // p[^ɓo^
        req.setParameter("param", values);
        // eXgs
        String dump = RequestUtil.dumpRequestParameters(req);
        // eXgʊmF
        assertEquals(" RequestParameters {param[0] = param0}", dump);
    }

    /**
     * testDumpRequestParameters06() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() req:not null<br>
     * () req.getParameterNames():{"param"}i1j<br>
     * () parameter̓e:param[]={"param0","param1","param2"} (vf:)<br>
     * <br>
     * ҒlF(߂l) String:"RequestParameters{param[0]=param0, param[1] = param1, param[2]=param2}"<br>
     * <br>
     * ̃NGXg擾p[^ɗvf1݂A z̗vfłꍇA "RequestAttributes{<p[^>[n]=<l>*vf}"ԋp邱Ƃ mFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestParameters06() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] values = { "param0", "param1", "param2" };
        // p[^ɓo^
        req.setParameter("param", values);
        // eXgs
        String dump = RequestUtil.dumpRequestParameters(req);
        // eXgʊmF
        assertEquals(" RequestParameters {param[0] = param0 , param[1] = "
                + "param1 , param[2] = param2}", dump);
    }

    /**
     * testDumpRequestParameters07() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() req:not null<br>
     * () req.getParameterNames():{"param0","param1"}(n)<br>
     * () parameter̓e:param0[]={"param0","param1","param2"}<br>
     * param1[]={"value0","param1","param2"}<br>
     * (vf:n)<br>
     * <br>
     * ҒlF(߂l) String:"RequestParameters{<br>
     * param0[0]=param0 , param0[1]=param1 , param0[2]=param2, param1[0]=value0 , param1[1]=value1 , param1[2]=value2 }"<br>
     * <br>
     * ̃NGXg擾p[^ɗvf݂A z̗vfłꍇA "RequestAttributes{<p[^>[n]=<l>*vf*p[^vf}" ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequestParameters07() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] values = { "param0", "param1", "param2" };
        String[] values2 = { "value0", "value1", "value2" };
        // p[^ɓo^
        req.setParameter("param0", values);
        req.setParameter("param1", values2);
        // eXgs
        String dump = RequestUtil.dumpRequestParameters(req);
        // eXgʊmF
        assertEquals(
                " RequestParameters {"
                        + "param0[0] = param0 , param0[1] = param1 , param0[2] = param2 , "
                        + "param1[0] = value0 , param1[1] = value1 , param1[2] = value2}",
                dump);
    }

    /**
     * testDumpRequest01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() req:not null<br>
     * () parameter:param = {"param0"}<br>
     * () attribute:attr0="value0"<br>
     * <br>
     * ҒlF(߂l) String:" RequestParameters = {param[0]=param0}" , " RequestAttributes{attr0=value0} "<br>
     * (s)<br>
     * <br>
     * dumpRequestParametersdumpRequestAttributešʂJ}؂ 擾ł邱ƁB<br>
     * n1̂݊mF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDumpRequest01() throws Exception {
        // eXgf[^ݒ

        // [NGXg
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] values = { "param0" };
        // p[^ɓo^
        req.setParameter("param", values);
        req.setAttribute("attr0", "value0");
        // eXgs
        String dump = RequestUtil.dumpRequest(req);
        // eXgʊmF
        assertEquals(" RequestParameters {param[0] = param0} ,  "
                + "RequestAttributes {attr0 = value0}", dump);
    }

    /**
     * testDeleteUrlParam01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:null<br>
     * () key:null<br>
     * <br>
     * ҒlF(߂l) String:null<br>
     * <br>
     * urlnull̏ꍇnull̂܂ܕԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam01() throws Exception {
        // O
        String url = null;
        String key = null;

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertNull(value);
    }

    /**
     * testDeleteUrlParam02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:""<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * url󔒂̏ꍇ͋󔒂̂܂ܕԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam02() throws Exception {
        // O
        String url = "";
        String key = "";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("", value);
    }

    /**
     * testDeleteUrlParam03() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do"<br>
     * () key:null<br>
     * <br>
     * ҒlF(߂l) String:"/test.do"<br>
     * <br>
     * keynull̏ꍇ́Aurl̂܂ܕԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam03() throws Exception {
        // O
        String url = "/test.do";
        String key = null;

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do", value);
    }

    /**
     * testDeleteUrlParam04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do"<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:"/test.do"<br>
     * <br>
     * key󔒂̏ꍇ́Aurl̂܂ܕԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam04() throws Exception {
        // O
        String url = "/test.do";
        String key = "";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do", value);
    }

    /**
     * testDeleteUrlParam05() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do"<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:"/test.do"<br>
     * <br>
     * urlɁAp[^݂Ȃꍇ́Aurl̂܂ܕԋp邱Ƃ mFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam05() throws Exception {
        // O
        String url = "/test.do";
        String key = "r";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do", value);
    }

    /**
     * testDeleteUrlParam06() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do?no2=2&no1=1"<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:"/test.do?no2=2&no1=1"<br>
     * <br>
     * urlɁA폜Ώۂ̃p[^݂Ȃꍇ́A폜ꂸɁAurl ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam06() throws Exception {
        // O
        String url = "/test.do?no2=2&no1=1";
        String key = "r";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do?no2=2&no1=1", value);
    }

    /**
     * testDeleteUrlParam07() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do?r=8331352040"<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:"/test.do"<br>
     * <br>
     * urlɁA폜Ώۂ̃p[^݂̂̏ꍇAp[^폜ꂽurl ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam07() throws Exception {
        // O
        String url = "/test.do?r=8331352040";
        String key = "r";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do", value);
    }

    /**
     * testDeleteUrlParam08() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do?r=8331352040&no1=1"<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:"/test.do?no1=1"<br>
     * <br>
     * urlɁA폜Ώۂ̃p[^ƁǍɕʂ̃p[^݂ꍇA 폜Ώۂ̃p[^폜ꂽurlԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam08() throws Exception {
        // O
        String url = "/test.do?r=8331352040&no1=1";
        String key = "r";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do?no1=1", value);
    }

    /**
     * testDeleteUrlParam09() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do?no2=2&r=8331352040"<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:"/test.do?no2=2"<br>
     * <br>
     * urlɁA폜Ώۂ̃p[^ƁȂOɕʂ̃p[^݂ꍇA 폜Ώۂ̃p[^폜ꂽurlԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam09() throws Exception {
        // O
        String url = "/test.do?no2=2&r=8331352040";
        String key = "r";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do?no2=2", value);
    }

    /**
     * testDeleteUrlParam10() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do?no2=2&r=8331352040&no1=1"<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:"/test.do?no2=2&no1=1"<br>
     * <br>
     * urlɁA폜Ώۂ̃p[^ƁȂOɕʂ̃p[^݂ꍇA 폜Ώۂ̃p[^폜ꂽurlԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam10() throws Exception {
        // O
        String url = "/test.do?no2=2&r=8331352040&no1=1";
        String key = "r";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do?no2=2&no1=1", value);
    }

    /**
     * testDeleteUrlParam11() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do?r=9856456131&r=8331352040&no1=1"<br>
     * () key:""<br>
     * <br>
     * ҒlF(߂l) String:"/test.do?no1=1"<br>
     * <br>
     * urlɁA폜Ώۂ̃p[^݂ꍇAΏۂƂȂp[^ ׂč폜ꂽurlԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam11() throws Exception {
        // O
        String url = "/test.do?r=9856456131&r=8331352040&no1=1";
        String key = "r";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals("/test.do?no1=1", value);
    }

    /**
     * testDeleteUrlParam12() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() url:"/test.do?r=8331352040"<br>
     * () key:"s"<br>
     * <br>
     * ҒlF(߂l) String:"/test.do?r=8331352040"<br>
     * <br>
     * 폜Ώۂ̃p[^ƈkeyႤꍇAp[^폜ꂸ urlԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDeleteUrlParam12() throws Exception {
        // O
        String url = "/test.do?r=8331352040";
        String key = "s";

        // eXg{
        String value = RequestUtil.deleteUrlParam(url, key);

        // 
        assertEquals(url, value);
    }

}
