/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.codelist.LocaleCodeBean} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * R[hAR[hl(\)ƃP[iR[hAR[hAoAgj
 * ێBeanNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.codelist.CodeBean
 * 
 */
public class LocaleCodeBeanTest extends TestCase {
    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(LocaleCodeBeanTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public LocaleCodeBeanTest(String name) {
        super(name);
    }

    /**
     * testSetId01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:"id"<br>
     * () id:null<br>
     * 
     * <br>
     * ҒlF(ԕω) id:"id"<br>
     * 
     * <br>
     * Ɏw肳ꂽ񂪃CX^Xϐidɐݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetId01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();

        // eXg{
        codeBean.setId("id");
        // 
        assertEquals("id", UTUtil.getPrivateField(codeBean, "id"));
    }

    /**
     * testSetId02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:null<br>
     * () id:null<br>
     * 
     * <br>
     * ҒlF(ԕω) id:""<br>
     * 
     * <br>
     * idnull̏ꍇA󕶎ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetId02() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setId(null);
        // 
        assertEquals("", UTUtil.getPrivateField(codeBean, "id"));
    }

    /**
     * testGetId01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() id:"id"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"id"<br>
     * 
     * <br>
     * CX^Xϐid̒l擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetId01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        UTUtil.setPrivateField(codeBean, "id", "id");
        
        // eXg{E
        assertEquals("id", codeBean.getId());
    }

    /**
     * testSetName01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() name:"name"<br>
     * () name:null<br>
     * 
     * <br>
     * ҒlF(ԕω) name:"name"<br>
     * 
     * <br>
     * Ɏw肳ꂽ񂪃CX^Xϐnameɐݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetName01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setName("name");
        // 
        assertEquals("name", UTUtil.getPrivateField(codeBean, "name"));
    }

    /**
     * testSetName02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() name:null<br>
     * () name:null<br>
     * 
     * <br>
     * ҒlF(ԕω) name:""<br>
     * 
     * <br>
     * namenull̏ꍇA󕶎ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetName02() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setName(null);
        // 
        assertEquals("", UTUtil.getPrivateField(codeBean, "name"));
    }

    /**
     * testGetName01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() name:"name"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"name"<br>
     * 
     * <br>
     * CX^Xϐname̒l擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetName01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        UTUtil.setPrivateField(codeBean, "name", "name");
        
        // eXg{E
        assertEquals("name", codeBean.getName());
    }

    /**
     * testSetLanguage01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() language:"language"<br>
     * () language:null<br>
     * 
     * <br>
     * ҒlF(ԕω) language:"language"<br>
     * 
     * <br>
     * Ɏw肳ꂽ񂪃CX^Xϐlanguage
     * ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetLanguage01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setLanguage("language");
        // 
        assertEquals("language", UTUtil.getPrivateField(codeBean, "language"));
    }

    /**
     * testSetLanguage02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() language:null<br>
     * () language:null<br>
     * 
     * <br>
     * ҒlF(ԕω) language:""<br>
     * 
     * <br>
     * languagenull̏ꍇA󕶎ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetLanguage02() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setLanguage(null);
        // 
        assertEquals("", UTUtil.getPrivateField(codeBean, "language"));
    }

    /**
     * testGetLanguage01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() language:"language"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"language"<br>
     * 
     * <br>
     * CX^Xϐlanguage̒l擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetLanguage01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        UTUtil.setPrivateField(codeBean, "language", "language");
        
        // eXg{E
        assertEquals("language", codeBean.getLanguage());
    }
    
    /**
     * testSetCountry01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() country:"country"<br>
     * () country:null<br>
     * 
     * <br>
     * ҒlF(ԕω) country:"country"<br>
     * 
     * <br>
     * Ɏw肳ꂽ񂪃CX^Xϐcountry
     * ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetCountry01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setCountry("country");
        // 
        assertEquals("country", UTUtil.getPrivateField(codeBean, "country"));
    }

    /**
     * testSetCountry02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() country:null<br>
     * () country:null<br>
     * 
     * <br>
     * ҒlF(ԕω) country:""<br>
     * 
     * <br>
     * countrynull̏ꍇA󕶎ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetCountry02() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setCountry(null);
        // 
        assertEquals("", UTUtil.getPrivateField(codeBean, "country"));
    }

    /**
     * testGetCountry01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() country:"country"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"country"<br>
     * 
     * <br>
     * CX^Xϐcountry̒l擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetCountry01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        UTUtil.setPrivateField(codeBean, "country", "country");
        
        // eXg{E
        assertEquals("country", codeBean.getCountry());
    }
    
    /**
     * testSetVariant01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() variant:"variant"<br>
     * () name:null<br>
     * 
     * <br>
     * ҒlF(ԕω) variant:"variant"<br>
     * 
     * <br>
     * Ɏw肳ꂽ񂪃CX^Xϐvariant
     * ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetVariant01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setVariant("variant");
        // 
        assertEquals("variant", UTUtil.getPrivateField(codeBean, "variant"));
    }

    /**
     * testSetVariant02() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() variant:null<br>
     * () variant:null<br>
     * 
     * <br>
     * ҒlF(ԕω) variant:""<br>
     * 
     * <br>
     * variantnull̏ꍇA󕶎ݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetVariant02() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        // eXg{
        codeBean.setVariant(null);
        // 
        assertEquals("", UTUtil.getPrivateField(codeBean, "variant"));
    }

    /**
     * testGetVariant01() <br>
     * <br>
     * 
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() variant:"variant"<br>
     * 
     * <br>
     * ҒlF(߂l) String:"variant"<br>
     * 
     * <br>
     * CX^Xϐvariant̒l擾ł邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetVariant01() throws Exception {
        // O
        LocaleCodeBean codeBean = new LocaleCodeBean();
        UTUtil.setPrivateField(codeBean, "variant", "variant");
        
        // eXg{E
        assertEquals("variant", codeBean.getVariant());
    }

}
