/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.codelist.MappedCodeListLoader} NX
 * ̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * R[hXg̏MapōsA
 * jp.terasoluna.fw.web.codelist.CodeListLoaderNXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.codelist.MappedCodeListLoader
 */
public class MappedCodeListLoaderTest extends TestCase {

    /**
     * eXgΏہB
     */
    private MappedCodeListLoader test = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MappedCodeListLoaderTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        test = new MappedCodeListLoader();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public MappedCodeListLoaderTest(String name) {
        super(name);
    }

    /**
     * testGetCodeListMap01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() codeListMap:not null<br>
     *
     * <br>
     * ҒlF(߂l) Map:CX^XϐcodeListMap<br>
     *
     * <br>
     * CX^XϐcodeListMap擾ł邱ƂmFB<br>
     * n1̂݊mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetCodeListMap01() throws Exception {
        // O
        Map map = new HashMap();
        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        Object result = test.getCodeListMap();

        // 
        assertSame(map, result);
    }

    /**
     * testSetCodeListMap01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() codeListMap:not null<br>
     *         () codeListMap:null<br>
     *
     * <br>
     * ҒlF(ԕω) codeListMap:not nulliɎw肵Mapj<br>
     *
     * <br>
     * Ɏw肵MapCX^XϐcodeListMapɐݒ肳邱ƂmFB<br>
     * n1̂݊mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetCodeListMap01() throws Exception {
        // O
        UTUtil.setPrivateField(test, "codeListMap", null);

        // eXg{
        Map<String, String> map = new HashMap<String, String>();
        test.setCodeListMap(map);

        // 
        Object result = UTUtil.getPrivateField(test, "codeListMap");
        assertSame(map, result);
    }

    /**
     * testLoad01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() localeMap:not null<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:ωȂ<br>
     *
     * <br>
     * CX^XϐcodeListsnot null̏ꍇAsꂸI邱ƂmFBcodeListsϐɕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad01() throws Exception {
        // O
        CodeBean cb = new CodeBean();
        cb.setId("id");
        cb.setName("name");
        List<CodeBean> list = new ArrayList<CodeBean>();
        list.add(cb);
        Map<Locale, List<CodeBean>> localeMap = new HashMap<Locale, List<CodeBean>>();
        localeMap.put(Locale.JAPANESE, list);
        
        test.defaultLocale = Locale.JAPANESE;
        test.localeMap = localeMap;

        // eXg{
        test.load();

        // 
        Map<Locale, List<CodeBean>> result = test.localeMap;
        assertSame(localeMap, result);
        
        List<CodeBean> codeLists = result.get(Locale.JAPANESE);
        assertSame(list, codeLists);
        assertEquals(1, codeLists.size());
        CodeBean codebean = codeLists.get(0);
        assertEquals("id", codebean.getId());
        assertEquals("name", codebean.getName());
    }

    /**
     * testLoad02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () codeListMap:null<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf0List<br>
     *
     * <br>
     * codeListMapnull̏ꍇAcodeListsvf0ListƂĐݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad02() throws Exception {
        // O
        test.localeMap = null;
        UTUtil.setPrivateField(test, "codeListMap", null);

        // eXg{
        test.load();

        // 
        Map<Locale, List<CodeBean>> result = test.localeMap;
        assertTrue(result.isEmpty());
    }

    /**
     * testLoad03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () codeListMap:vf0Map<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf0List<br>
     *
     * <br>
     * codeListMap̗vf̏ꍇAcodeListsvf0ListƂĐݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad03() throws Exception {
        // O
        test.localeMap = null;
        Map<String, String> map = new HashMap<String, String>();
        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        test.load();

        // 
        Map<Locale, List<CodeBean>> result = test.localeMap;
        assertTrue(result.isEmpty());
    }

    /**
     * testLoad04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () codeListMap:vf1Map<br>
     *                {"id","name"}<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf1List<br>
     *                    CodeBean{"id","name"}<br>
     *
     * <br>
     * codeListMap1̗vfꍇAMap̓ecodeLists邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad04() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        Map<String, String> map = new HashMap<String, String>();
        map.put("id", "name");
        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        test.load();

        // 
        Map<Locale, List<CodeBean>> result = test.localeMap;
        List<CodeBean> resutCodeList = result.get(Locale.JAPANESE);
        assertEquals(1, resutCodeList.size());
        CodeBean codebean = resutCodeList.get(0);
        assertEquals("id", codebean.getId());
        assertEquals("name", codebean.getName());
    }

    /**
     * testLoad05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () codeListMap:vf3Map<br>
     *                {"id1","name1"},<br>
     *                {"id2","name2"},<br>
     *                {"id3","name3"}<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf1List<br>
     *                    CodeBean{"id1","name1"},<br>
     *                    CodeBean{"id2","name2"},<br>
     *                    CodeBean{"id3","name3"},<br>
     *
     * <br>
     * codeListMapɕ̗vfꍇAMap̓ecodeLists邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad05() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        Map<String, String> map = new TreeMap<String, String>();
        map.put("id1", "name1");
        map.put("id2", "name2");
        map.put("id3", "name3");
        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        test.load();

        // 
        Map<Locale, List<CodeBean>> result = test.localeMap;
        List<CodeBean> resutCodeList = result.get(Locale.JAPANESE);
        
        assertEquals(3, resutCodeList.size());

        // 1
        CodeBean codebean = resutCodeList.get(0);
        assertEquals("id1", codebean.getId());
        assertEquals("name1", codebean.getName());

        // 2
        codebean = resutCodeList.get(1);
        assertEquals("id2", codebean.getId());
        assertEquals("name2", codebean.getName());

        // 3
        codebean = resutCodeList.get(2);
        assertEquals("id3", codebean.getId());
        assertEquals("name3", codebean.getName());
    }
    
    /**
     * testLoad06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() localeMap:null<br>
     *         () codeListMap:vf3Map<br>
     *                {"id1","name1"},<br>
     *                {"id2","name2"},<br>
     *                {"id3","name3"}<br>
     *
     * <br>
     * ҒlF(ԕω) codeLists:vf1List<br>
     *                    CodeBean{"id1","name1"},<br>
     *                    CodeBean{"id2","name2"},<br>
     *                    CodeBean{"id3","name3"},<br>
     *
     * <br>
     * codeListMapɕ̗vfꍇAMap̓ecodeLists邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLoad06() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        Map<String, Map<String, String>> map = 
                        new LinkedHashMap<String, Map<String,String>>();
        Map<String, String> childMap = new LinkedHashMap<String, String>();
        childMap.put("001", "val_1");
        childMap.put("002", "val_2");
        childMap.put("003", "val_3");
        map.put("ja", childMap);
        
        childMap = new TreeMap<String, String>();
        childMap.put("004", "val_4");
        childMap.put("005", "val_5");
        map.put("en", childMap);
        
        childMap = new TreeMap<String, String>();
        childMap.put("006", "val_6");
        childMap.put("007", "val_7");
        map.put("en_GB", childMap);
        
        childMap = new TreeMap<String, String>();
        childMap.put("008", "val_8");
        childMap.put("009", "val_9");
        map.put("en_US", childMap);
        
        childMap = new TreeMap<String, String>();
        childMap.put("010", "val_10");
        childMap.put("011", "val_11");
        map.put("en_US_us01", childMap);
        
        childMap = new TreeMap<String, String>();
        childMap.put("012", "val_12");
        childMap.put("013", "val_13");
        map.put("en_US_us02", childMap);

        UTUtil.setPrivateField(test, "codeListMap", map);

        // eXg{
        test.load();

        // 
        Map<Locale, List<CodeBean>> result = test.localeMap;
        // P[: ja
        List<CodeBean> codeList = result.get(new Locale("ja"));
        assertEquals(3, codeList.size());
        
        assertEquals("001", codeList.get(0).getId());
        assertEquals("val_1", codeList.get(0).getName());
        
        assertEquals("002", codeList.get(1).getId());
        assertEquals("val_2", codeList.get(1).getName());
        
        assertEquals("003", codeList.get(2).getId());
        assertEquals("val_3", codeList.get(2).getName());
        
        // P[: en
        codeList = result.get(new Locale("en"));
        assertEquals(2, codeList.size());
        
        assertEquals("004", codeList.get(0).getId());
        assertEquals("val_4", codeList.get(0).getName());
        
        assertEquals("005", codeList.get(1).getId());
        assertEquals("val_5", codeList.get(1).getName());
        
        // P[: en_GB
        codeList = result.get(new Locale("en", "GB"));
        assertEquals(2, codeList.size());
        
        assertEquals("006", codeList.get(0).getId());
        assertEquals("val_6", codeList.get(0).getName());
        
        assertEquals("007", codeList.get(1).getId());
        assertEquals("val_7", codeList.get(1).getName());
        
        // P[: en_US
        codeList = result.get(new Locale("en", "US"));
        assertEquals(2, codeList.size());
        
        assertEquals("008", codeList.get(0).getId());
        assertEquals("val_8", codeList.get(0).getName());
        
        assertEquals("009", codeList.get(1).getId());
        assertEquals("val_9", codeList.get(1).getName());
        
        // P[: en_US_us01
        codeList = result.get(new Locale("en", "US", "us01"));
        assertEquals(2, codeList.size());
        
        assertEquals("010", codeList.get(0).getId());
        assertEquals("val_10", codeList.get(0).getName());
        
        assertEquals("011", codeList.get(1).getId());
        assertEquals("val_11", codeList.get(1).getName());
        
        // P[: en_US_us02
        codeList = result.get(new Locale("en", "US", "us02"));
        assertEquals(2, codeList.size());
        
        assertEquals("012", codeList.get(0).getId());
        assertEquals("val_12", codeList.get(0).getName());
        
        assertEquals("013", codeList.get(1).getId());
        assertEquals("val_13", codeList.get(1).getName());
    }

    /**
     * testCreateLocale01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF""
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: LOCALE.JAPANESE
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale01() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        // eXg{
        Locale result = test.createLocale("");
        
        // 
        assertEquals(Locale.JAPANESE, result);
    }
    
    /**
     * testCreateLocale02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF"__us01"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: LOCALE.JAPANESE
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale02() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        // eXg{
        Locale result = test.createLocale("__us01");
        
        // 
        assertEquals(Locale.JAPANESE, result);
    }
    
    /**
     * testCreateLocale03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF_US_
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: LOCALE.JAPANESE
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale03() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        // eXg{
        Locale result = test.createLocale("_US_");
        
        // 
        assertEquals(Locale.JAPANESE, result);
    }
    /**
     * testCreateLocale04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF"_US_us01"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: LOCALE.JAPANESE
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale04() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        // eXg{
        Locale result = test.createLocale("_US_us01");
        
        // 
        assertEquals(Locale.JAPANESE, result);
    }

    /**
     * testCreateLocale05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF"en"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: en
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale05() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        // eXg{
        Locale result = test.createLocale("en");
        
        // 
        assertEquals(new Locale("en"), result);
    }
    /**
     * testCreateLocale06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF"en__us01"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: en
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale06() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;

        // eXg{
        Locale result = test.createLocale("en__us01");
        
        // 
        assertEquals(new Locale("en"), result);
    }
    /**
     * testCreateLocale07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF"en_US"
     *         () defaultLocale = LOCALE.JAPANESE
     *         
     * <br>
     * Ғl: en_US
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale07() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        // eXg{
        Locale result = test.createLocale("en_US");
        
        // 
        assertEquals(new Locale("en", "US"), result);
    }
    
    /**
     * testCreateLocale08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF"en_US_us01"
     *         
     * <br>
     * Ғl: en_US_us01
     *         
     * <br>
     * ͒lɑΉ郍P[擾邱ƂmFB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateLocale08() throws Exception {
        // O
        test.localeMap = null;
        test.defaultLocale = Locale.JAPANESE;
        
        // eXg{
        Locale result = test.createLocale("en_US_us01");
        
        // 
        assertEquals(new Locale("en", "US", "us01"), result);
    }
}
