/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

import org.apache.struts.util.MessageResources;

/**
 * {@link jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesExFactory} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * PropertyMessageResourcesEx𐶐t@NgNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesFactoryEx
 */
public class PropertyMessageResourcesExFactoryTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(PropertyMessageResourcesExFactoryTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public PropertyMessageResourcesExFactoryTest(String name) {
        super(name);
    }

    /**
     * testCreateResources01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:"aaaaa"<br>
     *         
     * <br>
     * ҒlF(߂l) PropertyMessageResourcesEx:factory->߂l𐶐PropertyMessageResourcesExFactoryCX^Xg<br>
     *                  config->"aaaaa"<br>
     *                  returnNull->MessageResourcesFactory.getReturnNull()<br>
     *         
     * <br>
     * PropertyMessageResourcesExĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources01() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory 
            = new PropertyMessageResourcesExFactory();
        
        // eXg{
        MessageResources resources 
            = factory.createResources("aaaaa");
       
        // 
        assertEquals(resources.getClass().getName(),
                     PropertyMessageResourcesEx.class.getName());
        assertSame(factory,
                   UTUtil.getPrivateField(resources, "factory"));
        assertEquals("aaaaa",
                     UTUtil.getPrivateField(resources, "config"));
        assertEquals(factory.getReturnNull(),
                     UTUtil.getPrivateField(resources, "returnNull"));

    }

    /**
     * testCreateResources02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:""<br>
     *         
     * <br>
     * ҒlF(߂l) PropertyMessageResourcesEx:factory->߂l𐶐PropertyMessageResourcesExFactoryCX^Xg<br>
     *                  config->""<br>
     *                  returnNull->MessageResourcesFactory.getReturnNull()<br>
     *         
     * <br>
     * PropertyMessageResourcesExĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources02() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory 
            = new PropertyMessageResourcesExFactory();
        
        // eXg{
        MessageResources resources 
            = factory.createResources("");
       
        // 
        assertEquals(resources.getClass().getName(),
                     PropertyMessageResourcesEx.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("", UTUtil.getPrivateField(resources, "config"));
        assertEquals(factory.getReturnNull(),
                     UTUtil.getPrivateField(resources, "returnNull"));   
    }

    /**
     * testCreateResources03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:null<br>
     *         
     * <br>
     * ҒlF(߂l) PropertyMessageResourcesEx:factory->߂l𐶐PropertyMessageResourcesExFactoryCX^Xg<br>
     *                  config->null<br>
     *                  returnNull->MessageResourcesFactory.getReturnNull()<br>
     *         
     * <br>
     * PropertyMessageResourcesExĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources03() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory 
            = new PropertyMessageResourcesExFactory();
        
        // eXg{
        MessageResources resources 
            = factory.createResources(null);
       
        // 
        assertEquals(resources.getClass().getName(),
                     PropertyMessageResourcesEx.class.getName());
        assertSame(factory,
                   UTUtil.getPrivateField(resources, "factory"));
        assertNull(UTUtil.getPrivateField(resources, "config"));
        assertEquals(factory.getReturnNull(),
                     UTUtil.getPrivateField(resources, "returnNull"));  
    }

}
