/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.utlib.LogUTUtil;
import junit.framework.TestCase;

import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.FileDownloadUtil} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * t@C_E[hs[eBeBNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.FileDownloadUtil
 */
public class FileDownloadUtilTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FileDownloadUtilTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public FileDownloadUtilTest(String name) {
        super(name);
    }

    /**
     * testSetEncoder01() <br>
     * <br>
     * 
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() encoder:null<br>
     * 
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     * bZ[WF<br>
     * "encoder must not be null."<br>
     * 
     * <br>
     * encodernullłꍇAOX[邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetEncoder01() throws Exception {
        // O
        FileDownloadUtil util = new FileDownloadUtil();

        // eXg{
        try {
            util.setEncoder(null);
            fail("IllegalArgumentException܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals("encoder must not be null.", e.getMessage());
        }

    }

    /**
     * testSetEncoder02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() encoder:DownloadFileNameEncoder<br>
     * 
     * <br>
     * ҒlF(ԕω) encoder:DownloadFileNameEncoder<br>
     * 
     * <br>
     * GR[_ݒ肳邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetEncoder02() throws Exception {
        // O
        FileDownloadUtil util = new FileDownloadUtil();
        DownloadFileNameEncoder encoder = new DownloadFileNameEncoderImpl();

        // eXg{
        util.setEncoder(encoder);

        // 
        assertEquals(encoder, FileDownloadUtil.encoder);
    }

    /**
     * testDownloadObjectHttpServletRequestHttpServletResponse01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() result:AbstractDownloadObjectpNX<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * 
     * <br>
     * ҒlF(ԕω) request:X|X܂<br>
     * 
     * <br>
     * resultAbstarctDownloadObjectpNX̏ꍇÂ܂܃_E[hΏۂƂ邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadObjectHttpServletRequestHttpServletResponse01()
            throws Exception {
        // O
        AbstractDownloadObject result = new DownloadString("abc", "abc");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(result, request, response);

        // 
        assertFalse(str.equals(Arrays
                .toString(response.getContentAsByteArray())));
    }

    /**
     * testDownloadObjectHttpServletRequestHttpServletResponse02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() result:AbstractDownloadObjectpNXvpeBɎȂJavaBean<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * 
     * <br>
     * ҒlF(ԕω) request:X|X܂Ȃ<br>
     * 
     * <br>
     * resultAbstarctDownloadObjectvpeBɎȂJavaBean̏ꍇA_E[hsȂƂmFeXgB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadObjectHttpServletRequestHttpServletResponse02()
            throws Exception {
        // O
        FileDownloadUtil_Stub01 result = new FileDownloadUtil_Stub01();
        result.setObject1("abc");
        result.setObject2("def");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(result, request, response);

        // 
        assertTrue(str
                .equals(Arrays.toString(response.getContentAsByteArray())));
    }

    /**
     * testDownloadObjectHttpServletRequestHttpServletResponse03() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() result:AbstractDownloadObjectpNX1vpeBɎJavaBean<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * 
     * <br>
     * ҒlF(ԕω) request:X|X܂<br>
     * 
     * <br>
     * resultAbstractDownloadObjectpNX1vpeBɎJavaBeanłꍇÃvpeB_E[hΏۂƂȂ邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadObjectHttpServletRequestHttpServletResponse03()
            throws Exception {
        // O
        FileDownloadUtil_Stub02 result = new FileDownloadUtil_Stub02();
        result.setObject1(new DownloadString("abc", "abc"));
        result.setObject2("def");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(result, request, response);

        // 
        assertFalse(str.equals(Arrays
                .toString(response.getContentAsByteArray())));
    }

    /**
     * testDownloadObjectHttpServletRequestHttpServletResponse04() <br>
     * <br>
     * 
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() result:AbstractDownloadObjectpNX2vpeBɎJavaBean<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * 
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     * bZ[WL[F<br>
     * "errors.too.many.download"<br>
     * bvOF<br>
     * IllegalStateException<br>
     * 
     * <br>
     * resultAbstractDownloadObjectpNX2ȏvpeBɎJavaBeanłꍇAOX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadObjectHttpServletRequestHttpServletResponse04()
            throws Exception {
        // O
        FileDownloadUtil_Stub03 result = new FileDownloadUtil_Stub03();
        result.setObject1(new DownloadString("abc", "abc"));
        result.setObject2(new DownloadString("def", "def"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        try {
            FileDownloadUtil.download(result, request, response);
            fail("SystemException܂łB");
        } catch (SystemException e) {
            // 
            assertEquals("errors.too.many.download", e.getErrorCode());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testDownloadObjectHttpServletRequestHttpServletResponse05() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() result:AbstractDownloadObjectpNXvpeBɎgetterȂJavaBean<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * 
     * <br>
     * ҒlF(ԕω) request:X|X܂Ȃ<br>
     * 
     * <br>
     * resultAbstractDownloadObjectpNX1vpeBɎgetterȂJavaBeanłꍇA_E[hsȂƂmFeXgB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadObjectHttpServletRequestHttpServletResponse05()
            throws Exception {
        // O
        FileDownloadUtil_Stub04 result = new FileDownloadUtil_Stub04();
        result.setObject1(new DownloadString("abc", "abc"));
        result.setObject2("def");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(result, request, response);

        // 
        assertTrue(str
                .equals(Arrays.toString(response.getContentAsByteArray())));
    }

    /**
     * testDownloadObjectHttpServletRequestHttpServletResponse06() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() result:AbstractDownloadObjectpNX1vpeBɎJavaBean<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:HttpServletResponseOpX^uNX<br>
     * () download(HttpServletRequestEEE)̌:SocketExeption<br>
     * 
     * <br>
     * ҒlF(ԕω) request:X|X܂Ȃ<br>
     * 
     * <br>
     * SocketExceptionX[ꂽꍇA_E[hsȂƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadObjectHttpServletRequestHttpServletResponse06()
            throws Exception {
        // O
        FileDownloadUtil_Stub02 result = new FileDownloadUtil_Stub02();
        result.setObject1(new DownloadString("abc", "abc"));
        result.setObject2("def");
        MockHttpServletRequest request = new MockHttpServletRequest();
        FileDownloadUtil_HttpServletResponseStub01 response = new FileDownloadUtil_HttpServletResponseStub01();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(result, request, response);

        // 
        assertTrue(str
                .equals(Arrays.toString(response.getContentAsByteArray())));
    }

    /**
     * testDownloadObjectHttpServletRequestHttpServletResponse07() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() result:AbstractDownloadObjectpNX1vpeBɎJavaBean<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:HttpServletResponseOpX^uNX<br>
     * () download(HttpHttpServletRequestEEE)̌:IOEception<br>
     * 
     * <br>
     * ҒlF(ԕω) request:X|X܂Ȃ<br>
     * (ԕω) O:OxFERROR<br>
     * OeFIOException has occurred while downloading<br>
     * OFIOException<br>
     * 
     * <br>
     * IOExceptionX[ꂽꍇAOo͂sA_E[hsȂƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadObjectHttpServletRequestHttpServletResponse07()
            throws Exception {
        // O
        FileDownloadUtil_Stub02 result = new FileDownloadUtil_Stub02();
        result.setObject1(new DownloadString("abc", "abc"));
        result.setObject2("def");
        MockHttpServletRequest request = new MockHttpServletRequest();
        FileDownloadUtil_HttpServletResponseStub02 response = new FileDownloadUtil_HttpServletResponseStub02();

        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{

        FileDownloadUtil.download(result, request, response);

        // 
        assertTrue(str
                .equals(Arrays.toString(response.getContentAsByteArray())));
        assertTrue(LogUTUtil
                .checkError("IOException has occurred while downloading",
                        new IOException()));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean01()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:null<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|Xɒl܂Ȃ<br>
     * (ԕω) O:OxFWARN<br>
     * OeF"No download object."<br>
     * OFȂ<br>
     * 
     * <br>
     * downloadObjectnull̏ꍇAȂƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean01()
            throws Exception {
        // O
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(null, request, response, true);

        // 
        assertTrue(str
                .equals(Arrays.toString(response.getContentAsByteArray())));
        assertTrue(LogUTUtil.checkWarn("No download object."));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean02()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF()
     * downloadObject:name="xyz"ŁAadditionalHeadersnullAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|Xɒl܂Ȃ<br>
     * (ԕω) O:OxFWARN<br>
     * OeF"Header must not be null."<br>
     * OFȂ<br>
     * 
     * <br>
     * AbstractDownloadObject#additionalHeadersnull̏ꍇAȂƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean02()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        object.additionalHeaders = null;
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertTrue(str
                .equals(Arrays.toString(response.getContentAsByteArray())));
        assertTrue(LogUTUtil.checkWarn("Header must not be null."));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean03()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF()
     * downloadObject:name="xyz"ŁAMap̗vf0additionalHeadersAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃wb_<br>
     * wb_: "Content-Disposition"<br>
     * l: "attachment; filename=xyz"<br>
     * ݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject#additionalHeadersGgȂMap̏ꍇAɏ邱ƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean03()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        object.additionalHeaders = new HashMap<String, List<String>>();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertFalse(str.equals(Arrays
                .toString(response.getContentAsByteArray())));
        assertTrue(response.getHeaderNames().contains("Content-Disposition"));
        assertEquals("attachment; filename=xyz", (String) response
                .getHeader("Content-Disposition"));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean04()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAMap{[null,
     * null]}ێadditionalHeadersAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|Xɒl܂Ȃ<br>
     * (ԕω) O:OxFWARN<br>
     * OeF"Header name and value must not be null."<br>
     * OFȂ<br>
     * 
     * <br>
     * AbstractDownloadObject#additionalHeaders̃GgListnullłꍇAȂƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean04()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        object.additionalHeaders.put(null, null);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertTrue(str
                .equals(Arrays.toString(response.getContentAsByteArray())));
        assertTrue(LogUTUtil
                .checkWarn("Header name and value must not be null."));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean05()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAMap{[null,
     * List["abc"]]}ێadditionalHeadersAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|Xɒl܂Ȃ<br>
     * (ԕω) O:OxFWARN<br>
     * OeF"Header name and value must not be null."<br>
     * OFȂ<br>
     * 
     * <br>
     * AbstractDownloadObject#additionalHeaders̃Gg̃L[nullłꍇAȂƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean05()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        List<String> list = new ArrayList<String>();
        list.add("abc");
        object.additionalHeaders.put(null, list);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertTrue(str
                .equals(Arrays.toString(response.getContentAsByteArray())));
        assertTrue(LogUTUtil
                .checkWarn("Header name and value must not be null."));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean06()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAMap{["abc",
     * List[null]]}ێadditionalHeadersAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃wb_<br>
     * wb_: "Content-Disposition", l: "attachment; filename=xyz"<br>
     * wb_: "abc", l: ""i󕶎j<br>
     * ݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject#additionalHeaders̃GgList̗vfnullłꍇA󕶎ɕϊĐɏ邱ƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean06()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        List<String> list = new ArrayList<String>();
        list.add(null);
        object.additionalHeaders.put("abc", list);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertFalse(str.equals(Arrays
                .toString(response.getContentAsByteArray())));
        assertTrue(response.getHeaderNames().contains("Content-Disposition"));
        assertEquals("attachment; filename=xyz", (String) response
                .getHeader("Content-Disposition"));
        assertTrue(response.getHeaderNames().contains("abc"));
        assertEquals("", (String) response.getHeader("abc"));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean07()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAMap{["abc",
     * List["abc"]]}ێadditionalHeadersAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃wb_<br>
     * wb_: "Content-Disposition", l: "attachment; filename=xyz"<br>
     * wb_: "abc", l: "abc"<br>
     * ݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject#additionalHeaders̃GgListnull܂܂Ȃvf1ꍇAɏ邱ƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean07()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        List<String> list = new ArrayList<String>();
        list.add("abc");
        object.additionalHeaders.put("abc", list);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertFalse(str.equals(Arrays
                .toString(response.getContentAsByteArray())));
        assertTrue(response.getHeaderNames().contains("Content-Disposition"));
        assertEquals("attachment; filename=xyz", (String) response
                .getHeader("Content-Disposition"));
        assertTrue(response.getHeaderNames().contains("abc"));
        assertEquals("abc", (String) response.getHeader("abc"));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean08()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAMap{["abc", List["abc",
     * "def"]]}ێadditionalHeadersAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃wb_<br>
     * wb_: "Content-Disposition", l: "attachment; filename=xyz"<br>
     * wb_: "abc", l: List["abc", "def"]<br>
     * ݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject#additionalHeaders̃GgListnull܂܂Ȃvf2ꍇAɏ邱ƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean08()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        List<String> list = new ArrayList<String>();
        list.add("abc");
        list.add("def");
        object.additionalHeaders.put("abc", list);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String str = Arrays.toString(response.getContentAsByteArray());

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertFalse(str.equals(Arrays
                .toString(response.getContentAsByteArray())));
        assertTrue(response.getHeaderNames().contains("Content-Disposition"));
        assertEquals("attachment; filename=xyz", (String) response
                .getHeader("Content-Disposition"));
        assertTrue(response.getHeaderNames().contains("abc"));
        List list2 = response.getHeaders("abc");
        assertEquals("abc", list2.get(0));
        assertEquals("def", list2.get(1));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean09()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF()
     * downloadObject:name="xyz"ŁAGR[fBOƃReg^Cvnullݒ肳ĂAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|XɃGR[fBOƃReg^Cvݒ肳Ȃ<br>
     * 
     * <br>
     * AbstractDownloadObject̃GR[fBOƃReg^Cvnullݒ肳ĂꍇAX|XɃGR[fBOƃReg^Cvݒ肳ȂƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean09()
            throws Exception {
        // O
        AbstractDownloadObject object = new FileDownloadUtil_DownloadStringStub01(
                "xyz", "xyz");
        object.charset = null;
        object.contentType = null;
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String charset = response.getCharacterEncoding();
        String contentType = response.getContentType();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertEquals(charset, response.getCharacterEncoding());
        assertEquals(contentType, response.getContentType());
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean10()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF()
     * downloadObject:name="xyz"ŁAGR[fBOƃReg^Cv""i󕶎jݒ肳ĂAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|XɃGR[fBOƃReg^Cvݒ肳Ȃ<br>
     * 
     * <br>
     * AbstractDownloadObject̃GR[fBOƃReg^Cv""i󕶎jݒ肳ĂꍇAX|XɃGR[fBOƃReg^Cvݒ肳ȂƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean10()
            throws Exception {
        // O
        AbstractDownloadObject object = new FileDownloadUtil_DownloadStringStub01(
                "xyz", "xyz");
        object.charset = "";
        object.contentType = "";
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        String charset = response.getCharacterEncoding();
        String contentType = response.getContentType();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertEquals(charset, response.getCharacterEncoding());
        assertEquals(contentType, response.getContentType());
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean11()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAGR[fBOƃReg^Cv "
     * "i󔒁jݒ肳ĂAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃GR[fBOƃReg^Cvɂꂼ" "i󔒁jݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject̃GR[fBOƃReg^Cv"
     * "i󔒁jݒ肳ĂꍇAX|X̃GR[fBOƃReg^Cvɂꂼ" "i󔒁jݒ肳 <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean11()
            throws Exception {
        // O
        AbstractDownloadObject object = new FileDownloadUtil_DownloadStringStub01(
                "xyz", "xyz");
        object.charset = "  ";
        object.contentType = "  ";
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertEquals("  ", response.getCharacterEncoding());
        assertEquals("  ", response.getContentType());
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean12()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF()
     * downloadObject:name="xyz"ŁAGR[fBOƃReg^Cvɂꂼ"abc"ݒ肳ĂAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃GR[fBOƃReg^Cvɂꂼ"abc"ݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject̃GR[fBOƃReg^Cv"abc"ݒ肳ĂꍇAX|X̃GR[fBOƃReg^Cvɂꂼ"abc"ݒ肳
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean12()
            throws Exception {
        // O
        AbstractDownloadObject object = new FileDownloadUtil_DownloadStringStub01(
                "xyz", "xyz");
        object.charset = "abc";
        object.contentType = "abc";
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertEquals("abc", response.getCharacterEncoding());
        assertEquals("abc", response.getContentType());
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean13()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAf[^TCY-1AbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|XɃf[^TCYݒ肳Ȃ<br>
     * 
     * <br>
     * AbstractDownloadObject̃f[^TCY-1̂ƂAX|XɃf[^TCYݒ肳ȂƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean13()
            throws Exception {
        // O
        FileDownloadUtil_DownloadStringStub01 object = new FileDownloadUtil_DownloadStringStub01(
                "xyz", "xyz");
        object.lengthOfData = -1;
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        int length = response.getContentLength();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertEquals(length, response.getContentLength());
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean14()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAf[^TCY0AbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|XɃf[^TCYݒ肳Ȃ<br>
     * 
     * <br>
     * AbstractDownloadObject̃f[^TCY0̂ƂAX|XɃf[^TCYݒ肳ȂƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean14()
            throws Exception {
        // O
        FileDownloadUtil_DownloadStringStub01 object = new FileDownloadUtil_DownloadStringStub01(
                "xyz", "xyz");
        object.lengthOfData = 0;
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        // p
        int length = response.getContentLength();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertEquals(length, response.getContentLength());
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean15()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAf[^TCY1AbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃f[^TCY1ɐݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject̃f[^TCY0̂ƂAX|X̃f[^TCY1ɐݒ肳邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean15()
            throws Exception {
        // O
        FileDownloadUtil_DownloadStringStub01 object = new FileDownloadUtil_DownloadStringStub01(
                "xyz", "xyz");
        object.lengthOfData = 1;
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertEquals(1, response.getContentLength());
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean16()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"łAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃wb_<br>
     * wb_: "Content-Disposition"<br>
     * l: "attachment; filename=xyz"<br>
     * ݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject̃t@C̕ʖݒ肷ƂAsetFileNames邱ƂmFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean16()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        object.name = "xyz";
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertTrue(response.getHeaderNames().contains("Content-Disposition"));
        assertEquals("attachment; filename=xyz", (String) response
                .getHeader("Content-Disposition"));
    }

    /**
     * testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean17()
     * <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() downloadObject:name="xyz"ŁAt@C̕ʖ݂ȂAbstractDownloadObject<br>
     * () request:org.springframework.mock.web.MockHttpServletRequest<br>
     * () response:org.springframework.mock.web.MockHttpServletResponse<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(ԕω) response:X|X̃wb_<br>
     * wb_: "Content-Disposition"<br>
     * l: "attachment; filename="<br>
     * ݒ肳<br>
     * 
     * <br>
     * AbstractDownloadObject̃t@C̕ʖݒ肵ȂƂłAsetFileNames邱ƂmFB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDownloadAbstractDownloadObjectHttpServletRequestHttpServletResponseboolean17()
            throws Exception {
        // O
        AbstractDownloadObject object = new DownloadString("xyz", "xyz");
        object.name = null;
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        FileDownloadUtil.download(object, request, response, true);

        // 
        assertTrue(response.getHeaderNames().contains("Content-Disposition"));
        assertEquals("attachment; filename=", (String) response
                .getHeader("Content-Disposition"));
    }

    /**
     * testSetFileNameHttpServletResponseStringboolean01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() response:MockHttpServletResponse<br>
     * () name:"abc"<br>
     * () forceDownload:true<br>
     * 
     * <br>
     * ҒlF(߂l) null:X|X̃wb_<br>
     * L[: "Content-Disposition"<br>
     * l: "attachment; filename=abc"<br>
     * ݒ肳<br>
     * 
     * <br>
     * X|X̃wb_ɐ񂪏܂邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetFileNameHttpServletResponseStringboolean01()
            throws Exception {
        String name = "abc";
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        FileDownloadUtil.setFileName(response, name, true);

        // 
        assertTrue(response.getHeaderNames().contains("Content-Disposition"));
        assertEquals("attachment; filename=abc", (String) response
                .getHeader("Content-Disposition"));
    }

    /**
     * testSetFileNameHttpServletResponseStringboolean02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() response:MockHttpServletResponse<br>
     * () name:"abc"<br>
     * () forceDownload:false<br>
     * 
     * <br>
     * ҒlF(߂l) null:X|X̃wb_<br>
     * L[: "Content-Disposition"<br>
     * l: "inline; filename=abc"<br>
     * ݒ肳<br>
     * 
     * <br>
     * X|X̃wb_ɐ񂪏܂邱ƂmFeXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetFileNameHttpServletResponseStringboolean02()
            throws Exception {
        String name = "abc";
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        FileDownloadUtil.setFileName(response, name, false);

        // 
        assertTrue(response.getHeaderNames().contains("Content-Disposition"));
        assertEquals("inline; filename=abc", (String) response
                .getHeader("Content-Disposition"));
    }

}
