/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.List;

import jp.terasoluna.fw.web.struts.reset.Resetter;
import jp.terasoluna.fw.web.struts.reset.ResetterImpl;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.MockServletContext;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

/**
 * {@link jp.terasoluna.fw.web.struts.form.ValidatorActionFormEx}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatort[[NΉANVtH[NXB<br>
 * <br>
 * set(String, Object)̃eXgP[X́Aُnꌏ̂݃eXgsB
 * ñeXgset(String, int, Object)ɂĕ܂B<br>
 * <br>
 * yOz<br>
 * ValidatorActionFormEx_ValidatorActionFormExStub01NX
 * 쐬ȉ̃f[^ێB<br>
 * int hogeInt = 123<br>
 * String hogeString = "data1"<br>
 * int[] hogeIntArray = {-100,0,10,111}<br>
 * String[] hogeStringArray = {"data1","data2","data3","data4"}<br>
 * Object[] hogeObjectArray = {new Integer(1),new Integer(2),new Integer(3),
 * new Integer(4)}<br>
 * List hogeList = {"data1","data2","data3","data4"}<br>
 * Map hogeMap = {key="field1" value="data1"}<br>
 *               {key="field2" value="data2"}<br>
 *               {key="field3" value="data3"}<br>
 *               {key="field4" value="data4"}<br>
 * Runnable hogeRunnable = new Runnable()
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.ValidatorActionFormEx
 */
public class ValidatorActionFormExTest extends TestCase {

    /**
     * eXgΏۂ̃CX^X
     */
    private ValidatorActionFormEx formEx;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ValidatorActionFormExTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        // create formEx
        this.formEx = new ValidatorActionFormEx_ValidatorActionFormExStub01();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ValidatorActionFormExTest(String name) {
        super(name);
    }

    /**
     * testGetIndexedValue01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() fieldName:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *                    bZ[W<br>
     *                    "No indexed value for 'null[0]'"<br>
     *
     * <br>
     * fieldNamenullݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue01() throws Exception {

        //eXgs
        try {
            this.formEx.getIndexedValue(null, 0);
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for 'null[0]'",
                    e.getMessage());
        }
    }

    /**
     * testGetIndexedValue02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() fieldName:󕶎<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *                    bZ[W<br>
     *                    "No mapped value for '(hello world!)'"<br>
     *
     * <br>
     * fieldNameɋ󕶎ݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue02() throws Exception {

        //eXgs
        try {
            this.formEx.getIndexedValue("", 0);
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for '[0]'",
                    e.getMessage());
        }
    }

    /**
     * testGetIndexedValue03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() fieldName:"foo"<br>
     *                (݂ȂtB[h)<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *                    bZ[W<br>
     *                    "No indexed value for 'foo[0]'"<br>
     *
     * <br>
     * fieldNmaeɑ݂ȂtB[hݒ肵A
     * NullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue03() throws Exception {

        //eXgs
        try {
            this.formEx.getIndexedValue("foo", 0);
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for 'foo[0]'",
                    e.getMessage());
        }
    }

    /**
     * testGetIndexedValue04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() fieldName:"hogeString"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[W<br>
     *                    "Non-indexed property for 'hogeString[0]'"<br>
     *
     * <br>
     * fieldNameɔzłListtB[hݒ肵A
     * IllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue04() throws Exception {

        //eXgs
        try {
            this.formEx.getIndexedValue("hogeString", 0);
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
            assertEquals("Non-indexed property for 'hogeString[0]'",
                    e.getMessage());
        }
    }

    /**
     * testGetIndexedValue05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeStringArray"<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:null<br>
     *
     * <br>
     * fieldNameStringz^̃tB[hݒ肵AIndex"-1"ݒ肵A
     * "null"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue05() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeStringArray", -1);

        //eXgʊmF
        assertNull(object);
    }

    /**
     * testGetIndexedValue06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeStringArray"<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:"data1"<br>
     *
     * <br>
     * fieldNameStringz^̃tB[hݒ肵AIndex"0"ݒ肵A
     * lԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue06() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeStringArray", 0);

        //eXgʊmF
        assertEquals("data1", object);
    }

    /**
     * testGetIndexedValue07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeStringArray"<br>
     *         () index:10<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:null<br>
     *
     * <br>
     * fieldNameStringz^̃tB[hݒ肵AIndex"10"ݒ肵A
     * "null"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue07() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeStringArray", 10);

        //eXgʊmF
        assertNull(object);
    }

    /**
     * testGetIndexedValue08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeList"<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:null<br>
     *
     * <br>
     * fieldNameList^̃tB[hݒ肵AIndex"-1"ݒ肵A
     * "null"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue08() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeList", -1);

        //eXgʊmF
        assertNull(object);
    }

    /**
     * testGetIndexedValue09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeList"<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:"data1"<br>
     *
     * <br>
     * fieldNameList^̃tB[hݒ肵AIndex"0"ݒ肵A
     * lԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue09() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeList", 0);

        //eXgʊmF
        assertEquals("data1", object);
    }

    /**
     * testGetIndexedValue10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeList"<br>
     *         () index:10<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:null<br>
     *
     * <br>
     * fieldNameList^̃tB[hݒ肵AIndex"10"ݒ肵A
     * "null"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue10() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeList", 10);

        //eXgʊmF
        assertNull(object);
    }

    /**
     * testGetIndexedValue11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() fieldName:"hogeInt"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[W<br>
     *                    "Non-indexed property for 'hogeInt[0]'"<br>
     *
     * <br>
     * fieldNameint^̃tB[hݒ肵AIllegalArgumentException
     * X[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue11() throws Exception {

        //eXgs
        try {
            this.formEx.getIndexedValue("hogeInt", 0);
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
            assertEquals("Non-indexed property for 'hogeInt[0]'",
                    e.getMessage());
        }
    }

    /**
     * testGetIndexedValue12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeIntArray"<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:null<br>
     *
     * <br>
     * fieldNameint[]^̃tB[hݒ肵AIndex"-1"ݒ肵A
     * "null"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue12() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeIntArray", -1);

        //eXgʊmF
        assertNull(object);
    }

    /**
     * testGetIndexedValue13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeIntArray"<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:Integer(-100)<br>
     *
     * <br>
     * fieldNameint[]^̃tB[hݒ肵AIndex"0"ݒ肵A
     * lԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue13() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeIntArray", 0);

        //eXgʊmF
        assertEquals(new Integer(-100), object);
    }

    /**
     * testGetIndexedValue14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeIntArray"<br>
     *         () index:10<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:null<br>
     *
     * <br>
     * fieldNameint[]^̃tB[hݒ肵AIndex"10"ݒ肵A
     * "null"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexedValue14() throws Exception {

        //eXgs
        Object object = this.formEx.getIndexedValue("hogeIntArray", 10);

        //eXgʊmF
        assertNull(object);
    }

    /**
     * testGetIndexCount01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:null<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:0<br>
     *
     * <br>
     * fieldName"null"ݒ肵A"0"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount01() throws Exception {

        //eXgs
        int i = this.formEx.getIndexCount(null);

        //eXgʊmF
        assertEquals(0, i);
    }

    /**
     * testGetIndexCount02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:󕶎<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:0<br>
     *
     * <br>
     * fieldNameɋ󕶎ݒ肵A"0"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount02() throws Exception {

        //eXgs
        int i = this.formEx.getIndexCount("");

        //eXgʊmF
        assertEquals(0, i);
    }

    /**
     * testGetIndexCount03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"foo"(݂ȂtB[h)<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:0<br>
     *
     * <br>
     * fieldNmaeɑ݂ȂtB[hݒ肵A"0"Ԃ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount03() throws Exception {

        //eXgs
        int i = this.formEx.getIndexCount("foo");

        //eXgʊmF
        assertEquals(0, i);
    }

    /**
     * testGetIndexCount04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeString"<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:1<br>
     *
     * <br>
     * fieldNameString^tB[hݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount04() throws Exception {

        //eXgs
        int i = this.formEx.getIndexCount("hogeString");

        //eXgʊmF
        assertEquals(1, i);
    }

    /**
     * testGetIndexCount05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeStringArray"<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:4<br>
     *
     * <br>
     * fieldNameString[]^̃tB[hݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount05() throws Exception {

        //eXgs
        int i = this.formEx.getIndexCount("hogeStringArray");

        //eXgʊmF
        assertEquals(4, i);
    }

    /**
     * testGetIndexCount06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeList"<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:4<br>
     *
     * <br>
     * fieldNameList^̃tB[hݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount06() throws Exception {

        //eXgs
        int i = this.formEx.getIndexCount("hogeList");

        //eXgʊmF
        assertEquals(4, i);
    }

    /**
     * testGetIndexCount07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:"hogeMap"<br>
     *
     * <br>
     * ҒlF(߂l) fieldNameŎw肳ꂽtB[h:4<br>
     *
     * <br>
     * fieldNameMap^̃tB[hݒ肵AlԂ鎖mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetIndexCount07() throws Exception {

        //eXgs
        int i = this.formEx.getIndexCount("hogeMap");

        //eXgʊmF
        assertEquals(4, i);
    }

    /**
     * testSetStringintObject01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *                    bZ[W<br>
     *                    "No indexed value for 'null[0]'"<br>
     *
     * <br>
     * name"null"ݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue01() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue(null, 0, "hello");
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for 'null[0]'",
                    e.getMessage());
        }
    }

    /**
     * testSetIndexedValue02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:󕶎<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *                    bZ[W<br>
     *                    "No indexed value for '[0]'"<br>
     *
     * <br>
     * nameɋ󕶎ݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue02() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("", 0, "hello");
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for '[0]'",
                    e.getMessage());
        }
    }

    /**
     * testSetIndexedValue03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"foo"<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *                    bZ[W<br>
     *                    "No indexed value for 'foo[0]'"<br>
     *
     * <br>
     * nameɑ݂ȂtB[hݒ肵A
     * NullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue03() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("foo", 0, "hello");
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            assertEquals("No indexed value for 'foo[0]'",
                    e.getMessage());
        }
    }

    /**
     * testSetIndexedValue04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeString"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[W<br>
     *                    "Non-indexed property for 'hogeString[0]'"<br>
     *
     * <br>
     * nameString^̃tB[hݒ肵A
     * IllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue04() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeString", 0, "hello");
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
            assertEquals("Non-indexed property for 'hogeString[0]'",
                    e.getMessage());
        }
    }

    /**
     * testSetIndexedValue05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(ԕω) O:ArrayIndexOutOfBoundsException<br>
     *
     * <br>
     * nameString[]^̃tB[hݒ肵AIndex"-1"ݒ肵A
     * ArrayIndexOutOfBoundsExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue05() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeStringArray", -1, "hello");
            fail();
        } catch (ArrayIndexOutOfBoundsException e) {
        }
    }

    /**
     * testSetIndexedValue06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:0<br>
     *         () value:null<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:Index="0"valuei[<br>
     *
     * <br>
     * nameString[]^̃tB[hݒ肵AIndex"0"ݒ肵A
     * Y"0"ɈɂƂ"null"i[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue06() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeStringArray", 0, null);

        //eXgʊmF
        String[] str = (String[]) UTUtil.getPrivateField(
                formEx, "hogeStringArray");
        assertNull(str[0]);
    }

    /**
     * testSetIndexedValue07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:1<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                      Index="1"valuei[<br>
     *
     * <br>
     * nameString[]^̃tB[hݒ肵AIndex"1"ݒ肵A
     * Y"1"ɈɂƂ"hello"i[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue07() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeStringArray", 1, "hello");

        //eXgʊmF
        String[] str = (String[]) UTUtil.getPrivateField(
                formEx, "hogeStringArray");
        assertEquals("hello", str[1]);
    }

    /**
     * testSetIndexedValue08()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:2<br>
     *         () value:Integer(5)<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * nameString[]^̃tB[hݒ肵AIndex"2"ݒ肵A
     * IllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue08() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeStringArray", 2, new Integer(5));
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetIndexedValue09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:10<br>
     *         () value:null<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                         Index="10"valuei[<br>
     *
     * <br>
     * nameɃTCY"4"String[]^̃tB[hݒ肵AIndex"10"ݒ肵A
     * Y"10"ɈɂƂ"null"i[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue09() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeStringArray", 10, null);

        //eXgʊmF
        String[] str = (String[]) UTUtil.getPrivateField(
                formEx, "hogeStringArray");
        assertNull(str[10]);
    }

    /**
     * testSetIndexedValue10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:11<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                        Index="11"valuei[<br>
     *
     * <br>
     * nameɃTCY"4"String[]^̃tB[hݒ肵AIndex"11"ݒ肵A
     * Y"11"ɈɂƂ"hello"i[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue10() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeStringArray", 11, "hello");

        //eXgʊmF
        String[] str = (String[]) UTUtil.getPrivateField(
                formEx, "hogeStringArray");
        assertEquals("hello", str[11]);
    }

    /**
     * testSetIndexedValue11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeStringArray"<br>
     *         () index:12<br>
     *         () value:Integer(5)<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * nameɃTCY"4"String[]^̃tB[hݒ肵AIndex"12"ݒ肵A
     * IllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue11() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeStringArray", 12, new Integer(5));
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetIndexedValue12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IndexOutOfBoundsException<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex"-1"ݒ肵A
     * IndexOutOfBoundsExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue12() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeList", -1, "hello");
            fail();
        } catch (IndexOutOfBoundsException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetIndexedValue13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:0<br>
     *         () value:null<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                          Index="0"valuei[<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex"0"ݒ肵A
     * Y"0"ɈɂƂ"null"i[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue13() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeList", 0, null);

        //eXgʊmF
        List list = (List) UTUtil.getPrivateField(formEx, "hogeList");
        assertNull(list.get(0));
    }

    /**
     * testSetIndexedValue14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:1<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                         Index="1"valuei[<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex"1"ݒ肵A
     * Y"1"ɈɂƂ"hello"i[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue14() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeList", 1, "hello");

        //eXgʊmF
        List list = (List) UTUtil.getPrivateField(formEx, "hogeList");
        assertEquals("hello", list.get(1));
    }

    /**
     * testSetIndexedValue15()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:2<br>
     *         () value:Integer(5)<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                            Index="2"valuei[<br>
     *
     * <br>
     * nameList^̃tB[hݒ肵AIndex"2"ݒ肵A
     * Y"2"ɈɂƂIntegeri[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue15() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeList", 2, new Integer(5));

        //eXgʊmF
        List list = (List) UTUtil.getPrivateField(formEx, "hogeList");
        assertEquals(5, ((Integer)list.get(2)).intValue());
    }

    /**
     * testSetIndexedValue16()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:10<br>
     *         () value:null<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                         Index="10"valuei[<br>
     *
     * <br>
     * nameɃTCY"4"List^̃tB[hݒ肵AIndex"10"ݒ肵A
     * Y"10"ɈɂƂ"null"i[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue16() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeList", 10, null);

        //eXgʊmF
        List list = (List) UTUtil.getPrivateField(formEx, "hogeList");
        assertNull(list.get(10));
    }

    /**
     * testSetIndexedValue17()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:11<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                         Index="11"valuei[<br>
     *
     * <br>
     * nameɃTCY"4"List^̃tB[hݒ肵AIndex"11"ݒ肵A
     * Y"11"ɈɂƂ"helloEi[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue17() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeList", 11, "hello");

        //eXgʊmF
        List list = (List) UTUtil.getPrivateField(formEx, "hogeList");
        assertEquals("hello", list.get(11));
    }

    /**
     * testSetIndexedValue18()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeList"<br>
     *         () index:12<br>
     *         () value:Integer(5)<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                          Index="12"valuei[<br>
     *
     * <br>
     * nameɃTCY"4"List^̃tB[hݒ肵AIndex"12"ݒ肵A
     * Y"12"ɈɂƂIntegeri[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue18() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeList", 12, new Integer(5));

        //eXgʊmF
        List list = (List) UTUtil.getPrivateField(formEx, "hogeList");
        assertEquals(5, ((Integer)list.get(12)).intValue());
    }

    /**
     * testSetIndexedValue19()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeInt"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[W<br>
     *                    "Non-indexed property for 'hogeInt[2]'"<br>
     *
     * <br>
     * nameint^̃tB[hݒ肵AIllegalArgumentException
     * X[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue19() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeInt", 2, new Integer(5));
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
            assertEquals("Non-indexed property for 'hogeInt[2]'",
                    e.getMessage());
        }
    }

    /**
     * testSetIndexedValue20()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(ԕω) O:ArrayIndexOutOfBoundsException<br>
     *
     * <br>
     * nameint[]^̃tB[hݒ肵AArrayIndexOutOfBoundsException
     * X[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue20() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeIntArray", -1, "hello");
            fail();
        } catch (ArrayIndexOutOfBoundsException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetIndexedValue21()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:0<br>
     *         () value:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * nameint[]^̃tB[hݒ肵AIllegalArgumentException
     * X[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue21() throws Exception {
        try {
            //eXgs
            this.formEx.setIndexedValue("hogeIntArray", 0, null);
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetIndexedValue22()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:1<br>
     *         () value:Integer(5)<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:
     *                       Index="1"valuei[<br>
     *
     * <br>
     * nameint[]^̃tB[hݒ肵AIndex"1"ݒ肵A
     * Y"1"valuei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue22() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeIntArray", 1, new Integer(5));

        //eXgʊmF
        int[] in = (int[]) UTUtil.getPrivateField(formEx, "hogeIntArray");
        assertEquals(5, in[1]);
    }

    /**
     * testSetIndexedValue23()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:2<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * nameint[]^̃tB[hݒ肵AIndex"2"ݒ肵A
     * IllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue23() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeIntArray", 2, "hello");
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetIndexedValue24()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:10<br>
     *         () value:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * nameɃTCY"4"int[]^̃tB[hݒ肵A
     * Index"10"ݒ肵ANullPointerExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue24() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeIntArray", 10, null);
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetIndexedValue25()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:11<br>
     *         () value:Integer(5)<br>
     *
     * <br>
     * ҒlF(ԕω) nameŎw肳ꂽtB[h:Index="11"
     *                   valuei[<br>
     *
     * <br>
     * nameɃTCY"4"int[]^̃tB[hݒ肵A
     * Index"11"ݒ肵Avaluei[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue25() throws Exception {

        //eXgs
        this.formEx.setIndexedValue("hogeIntArray", 11, new Integer(5));

        //eXgʊmF
        int[] in = (int[]) UTUtil.getPrivateField(formEx, "hogeIntArray");
        assertEquals(5, in[11]);
    }

    /**
     * testSetIndexedValue26()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"hogeIntArray"<br>
     *         () index:12<br>
     *         () value:"hello"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * nameɃTCY"4"int[]^̃tB[hݒ肵AIndex"12"ݒ肵A
     * IllegalArgumentExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue26() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeIntArray", 12, "hello");
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
        }
    }

    /**
     * testSetIndexedValue27()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"stringValue"<br>
     *         () index:0<br>
     *         () value:"hello"<br>
     * OF(ValidatorActionFormExTuNX)
     *            setStringValuesŗOB
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                         bZ[WFCannot set property for 'stringValues[0]'<br>
     *
     * <br>
     * l̐ݒ莞ɗOꍇAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue27() throws Exception {

        ValidatorActionFormEx test =
            new ValidatorActionFormEx_ValidatorActionFormExStub02();

        //eXgs
        try {
            test.setIndexedValue("stringValues", 0, "hello");
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
            assertEquals("Cannot set property for 'stringValues[0]'",
                    e.getMessage());
        }
    }

    /**
     * testSetIndexedValue28()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"valueList"<br>
     *         () index:0<br>
     *         () value:"hello"<br>
     * OF(ValidatorActionFormExTuNX)
     *            setValueListŗOB
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                         bZ[WFCannot set property for 'valueList[0]'<br>
     *
     * <br>
     * l̐ݒ莞ɗOꍇAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue28() throws Exception {

        ValidatorActionFormEx test =
            new ValidatorActionFormEx_ValidatorActionFormExStub02();

        //eXgs
        try {
            test.setIndexedValue("valueList", 0, "hello");
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
            assertEquals("Cannot set property for 'valueList[0]'",
                    e.getMessage());
        }
    }
    
    /**
     * testSetIndexedValue29()
     * 
     * z񒷃`FbNőlȏ̃CfbNXݒ肵IllegalArgumentException邱ƁB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue29() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeStringArray", 10000, "hello");
            fail();
        } catch (Exception e) {
            //eXgʊmF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("index size is too long. : 10000", e.getMessage());
        }
    }
    
    /**
     * testSetIndexedValue30()
     * 
     * Xg`FbNőlȏ̃CfbNXݒ肵IllegalArgumentException邱ƁB
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetIndexedValue30() throws Exception {

        //eXgs
        try {
            this.formEx.setIndexedValue("hogeList", 10000, "hello");
            fail();
        } catch (Exception e) {
            //eXgʊmF
            assertEquals(IllegalArgumentException.class, e.getClass());
            assertEquals("index size is too long. : 10000", e.getMessage());
        }
    }
    
    /**
     * testIsModified01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() modified:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * nꌏ̂݃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsModified01() throws Exception {
        // O
        UTUtil.setPrivateField(formEx, "modified", true);

        // eXg{
        boolean result = formEx.isModified();

        // 
        assertTrue(result);
    }

    /**
     * testSetModified01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() modified:true<br>
     *         () modified:false<br>
     *
     * <br>
     * ҒlF(ԕω) modified:true<br>
     *
     * <br>
     * nꌏ̂݃eXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetModified01() throws Exception {
        // eXgf[^ݒ
        boolean modifiedFlag = true;

        // eXgs
        formEx.setModified(modifiedFlag);

        // eXg
        // ݒ肵ActionMessageƓł邱ƁB
        Boolean result = (Boolean) UTUtil.getPrivateField(formEx, "modified");
        assertEquals(modifiedFlag, result.booleanValue());
    }

    /**
     * testReset01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:
     *                  ftHgW[i[NGXgIuWFNg<br>
     *         () resetter:null<br>
     *
     * <br>
     * ҒlF(ԕω) ResetterImpl#reset()̌Ăяo:-<br>
     *
     * <br>
     * ftHgW[i[NGXgIuWFNgݒ肵A
     * Resetter"null"ꍇAɏI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReset01() throws Exception {

        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        ValidatorActionFormEx_ActionServlet_Stub01 servlet =
            new ValidatorActionFormEx_ActionServlet_Stub01();
        // vtBbNX̐
        String prefix = "";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, null);
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        //eXgs
        this.formEx.reset(mapping, request);
    }

    /**
     * testReset02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:
     *                  ftHgW[i[NGXgIuWFNg<br>
     *         () resetter:ResetterȊÕIuWFNg<br>
     *
     * <br>
     * ҒlF(ԕω) ResetterImpl#reset()̌Ăяo:-<br>
     *                   OFO<br>
     *                         G[OF""<br>
     *                         O<br>
     *                         ClassCastException<br>
     *
     * <br>
     * ftHgW[i[NGXgIuWFNgݒ肵A
     * ResetterȊÕIuWFNg擾ꍇAClassCastExceptionāA
     * Oo͂āAI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReset02() throws Exception {

        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        ValidatorActionFormEx_ActionServlet_Stub01 servlet =
            new ValidatorActionFormEx_ActionServlet_Stub01();
        // vtBbNX̐
        String prefix = "";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, new Object());
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        //eXgs
        this.formEx.reset(mapping, request);

        //eXgʊmF
        assertTrue(
                LogUTUtil.checkError("",new ClassCastException()));
    }

    /**
     * testReset03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:
     *                   ftHgW[i[NGXgIuWFNg<br>
     *         () resetter:ResetterIuWFNg<br>
     *
     * <br>
     * ҒlF(ԕω) ResetterImpl#reset()̌Ăяo:Ăяo<br>
     *                    request"SUCCESS"L[̒lݒ肳邱ƂmFB
     *
     * <br>
     * ftHgW[i[NGXgIuWFNgݒ肵A
     * ResetterAtB[h邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReset03() throws Exception {

        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        ValidatorActionFormEx_ActionServlet_Stub01 servlet =
            new ValidatorActionFormEx_ActionServlet_Stub01();
        // vtBbNX̐
        String prefix = "";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();
        // Zb^[̐
        ResetterImpl resetter = new ValidatorActionFormEx_ResetterStub01();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, resetter);
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        //eXgs
        this.formEx.reset(mapping, request);

        //eXgʊmF
        assertNotNull(request.getAttribute("SUCCESS"));
    }

    /**
     * testReset04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:TuW[i[NGXgIuWFNg<br>
     *         () resetter:null<br>
     *
     * <br>
     * ҒlF(ԕω) ResetterImpl#reset()̌Ăяo:-<br>
     *
     * <br>
     * TuW[i[NGXgIuWFNgݒ肵A
     * Resetter"null"ꍇAɏI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReset04() throws Exception {

        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        ValidatorActionFormEx_ActionServlet_Stub01 servlet =
            new ValidatorActionFormEx_ActionServlet_Stub01();
        // vtBbNX̐
        String prefix = "sub1";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, null);
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        //eXgs
        this.formEx.reset(mapping, request);
    }

    /**
     * testReset05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:TuW[i[NGXgIuWFNg<br>
     *         () resetter:ResetterȊÕIuWFNg<br>
     *
     * <br>
     * ҒlF(ԕω) ResetterImpl#reset()̌Ăяo:-<br>
     *                   OFO<br>
     *                         G[OF""<br>
     *                         O<br>
     *                         ClassCastException<br>
     *
     * <br>
     * TuW[i[NGXgIuWFNgݒ肵A
     * ResetterȊÕIuWFNg擾ꍇAɏI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReset05() throws Exception {

        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        ValidatorActionFormEx_ActionServlet_Stub01 servlet =
            new ValidatorActionFormEx_ActionServlet_Stub01();
        // vtBbNX̐
        String prefix = "sub1";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, new Object());
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        //eXgs
        this.formEx.reset(mapping, request);

        //eXgʊmF
        assertTrue(
                LogUTUtil.checkError("",new ClassCastException()));
    }

    /**
     * testReset06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:TuW[i[NGXgIuWFNg<br>
     *         () resetter:ResetterIuWFNg<br>
     *
     * <br>
     * ҒlF(ԕω) ResetterImpl#reset()̌Ăяo:Ăяo<br>
     *                    request"SUCCESS"L[̒lݒ肳邱ƂmFB
     *
     * <br>
     * TuW[i[NGXgIuWFNgݒ肵A
     * ResetterAtB[h邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReset06() throws Exception {

        // NGXg̐
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ZbV̐
        MockHttpSession session = new MockHttpSession();
        // ReLXg̐
        MockServletContext context = new MockServletContext();
        // ANVT[ubg̐
        ValidatorActionFormEx_ActionServlet_Stub01 servlet =
            new ValidatorActionFormEx_ActionServlet_Stub01();
        // vtBbNX̐
        String prefix = "sub1";
        // W[ݒ̐
        ModuleConfig moduleConfig = new ModuleConfigImpl(prefix);
        // }bsO̐
        ActionMapping mapping = new ActionMapping();
        // Zb^[̐
        ResetterImpl resetter = new ValidatorActionFormEx_ResetterStub01();

        // ݒ
        request.setSession(session);
        request.setAttribute(Globals.MODULE_KEY, moduleConfig);
        session.setServletContext(context);
        context.setAttribute(Resetter.RESETTER_KEY + prefix, resetter);
        context.setAttribute(Globals.MODULE_KEY, moduleConfig);
        this.formEx.setServlet(servlet);
        servlet.setContext(context);

        //eXgs
        this.formEx.reset(mapping, request);

        //eXgʊmF
        assertNotNull(request.getAttribute("SUCCESS"));
    }

}
