/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.struts.MessageFormatCloneReturnIfUseDateFormatMap;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.spring.mock.MockWebApplicationContext;
import junit.framework.TestCase;

import org.apache.struts.util.MessageResources;
import org.springframework.beans.BeansException;
import org.springframework.context.MessageSource;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

/**
 * {@link SpringMessageResources} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Spring̃bZ[W\[XStruts痘pMessageResourcesNXB<br>
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.util.SpringMessageResources
 */
public class SpringMessageResourcesTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(SpringMessageResourcesTest.class);
    }

    /**
     * ̃eXgP[XŗpApplicationContext
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    private WebApplicationContext context = null;
    
    /**
     * s.
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    @SuppressWarnings("unchecked")
    protected void setUpData() throws Exception {
        // ContextLoader.getCurrentWebApplicationContext()̕ԋpl
        // bNApplicationContextZbgĂB
        Map currentContextPerThread = (Map) UTUtil.getPrivateField(
                ContextLoader.class, "currentContextPerThread");
        String[] configLocations = new String[] {
        "jp/terasoluna/fw/web/struts/util/SpringMessageResourcesTest01.xml"};
        this.context = new MockWebApplicationContext(configLocations);
        currentContextPerThread.put(
            Thread.currentThread().getContextClassLoader(), this.context);
    }

    /**
     * Is.
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
        this.context = null;
    }
    
    /**
     * testSpringMessageResourcesMessageResourcesFactoryString01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:SpringMessageResourcesFactoryCX^X<br>
     *         () config:"propertyMessageSource01"i݂Beanj<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) messageResources.messageFormatClone:"disable"<br>
     *         
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config="propertyMessageSource01"<br>
     *                    messageSource=MessageSourcẽTuNX<br>
     *                    formats=HashMapCX^X<br>
     *         
     * <br>
     * ݂BeannꍇAinitMessageSource()Ăяo邱ƂmFB<br>
     * MessageFormatCacheMapFactory#getInstance̖߂lnull̂ƂA
     * formats͍ւȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSpringMessageResourcesMessageResourcesFactoryString01() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        addProperty("messageResources.messageFormatClone", "disable");
        
        // eXg{
        MessageResources resources = 
            new SpringMessageResources(factory, "propertyMessageSource01");
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("propertyMessageSource01", UTUtil.getPrivateField(resources, "config"));
        assertTrue(UTUtil.getPrivateField(resources, "messageSource") instanceof MessageSource);
        assertEquals(UTUtil.getPrivateField(resources, "formats").getClass(), HashMap.class);
    }
    
    /**
     * testSpringMessageResourcesMessageResourcesFactoryString02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FAC
     * <br><br>
     * ͒lF() factory:SpringMessageResourcesFactoryCX^X<br>
     *         () config:""i󕶎j<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) messageResources.messageFormatClone:"dateFormatOnly"<br>
     *         
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config=""<br>
     *                    messageSource=OŃZbgapplicationContext<br>
     *                    formats=MessageFormatCloneReturnIfUseDateFormatMapCX^X<br>
     *         
     * <br>
     * 󕶎BeannꍇAinitMessageSource()Ăяo邱ƂmFB<br>
     * MessageFormatCacheMapFactory#getInstance̖߂lnullȊÔƂA
     * formats̖߂lɍւ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSpringMessageResourcesMessageResourcesFactoryString02() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        addProperty("messageResources.messageFormatClone", "dateFormatOnly");
        
        // eXg{
        MessageResources resources = 
            new SpringMessageResources(factory, "");
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("", UTUtil.getPrivateField(resources, "config"));
        assertSame(this.context, UTUtil.getPrivateField(resources, "messageSource"));
        assertEquals(UTUtil.getPrivateField(resources, "formats").getClass(), MessageFormatCloneReturnIfUseDateFormatMap.class);
    }
    
    /**
     * testSpringMessageResourcesMessageResourcesFactoryString03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:SpringMessageResourcesFactoryCX^X<br>
     *         () config:null<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config=null<br>
     *                    messageSource=OŃZbgapplicationContext<br>
     *         
     * <br>
     * nullBeannꍇAinitMessageSource()Ăяo邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSpringMessageResourcesMessageResourcesFactoryString03() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        
        // eXg{
        MessageResources resources = 
            new SpringMessageResources(factory, null);
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertNull(UTUtil.getPrivateField(resources, "config"));
        assertSame(this.context, UTUtil.getPrivateField(resources, "messageSource"));
    }
    
    /**
     * testSpringMessageResourcesMessageResourcesFactoryStringboolean01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:SpringMessageResourcesFactoryCX^X<br>
     *         () config:"propertyMessageSource01"i݂Beanj<br>
     *         () returnNull:true<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) messageResources.messageFormatClone:"disable"<br>
     *         
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config="propertyMessageSource01"<br>
     *                    returnNull=true<br>
     *                    messageSource=MessageSourcẽTuNX<br>
     *                    formats=HashMapCX^X<br>
     *         
     * <br>
     * ݂BeannꍇAinitMessageSource()Ăяo邱ƂmFB<br>
     * MessageFormatCacheMapFactory#getInstance̖߂lnull̂ƂA
     * formats͍ւȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSpringMessageResourcesMessageResourcesFactoryStringboolean01() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        addProperty("messageResources.messageFormatClone", "disable");
        
        // eXg{
        MessageResources resources = 
            new SpringMessageResources(factory, "propertyMessageSource01" ,true);
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("propertyMessageSource01", UTUtil.getPrivateField(resources, "config"));
        assertEquals(true, UTUtil.getPrivateField(resources, "returnNull"));
        assertTrue(UTUtil.getPrivateField(resources, "messageSource") instanceof MessageSource);
        assertEquals(UTUtil.getPrivateField(resources, "formats").getClass(), HashMap.class);
    }
    
    /**
     * testSpringMessageResourcesMessageResourcesFactoryStringboolean02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FAC
     * <br><br>
     * ͒lF() factory:SpringMessageResourcesFactoryCX^X<br>
     *         () config:""i󕶎j<br>
     *         () returnNull:false<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) messageResources.messageFormatClone:"dateFormatOnly"<br>
     *         
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config=""<br>
     *                    returnNull=false<br>
     *                    messageSource=OŃZbgapplicationContext<br>
     *                    formats=MessageFormatCloneReturnIfUseDateFormatMapCX^X<br>
     *         
     * <br>
     * 󕶎BeannꍇAinitMessageSource()Ăяo邱ƂmFB<br>
     * MessageFormatCacheMapFactory#getInstance̖߂lnullȊÔƂA
     * formats̖߂lɍւ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSpringMessageResourcesMessageResourcesFactoryStringboolean02() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        addProperty("messageResources.messageFormatClone", "dateFormatOnly");
        
        // eXg{
        MessageResources resources = 
            new SpringMessageResources(factory, "", false);
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("", UTUtil.getPrivateField(resources, "config"));
        assertEquals(false, UTUtil.getPrivateField(resources, "returnNull"));
        assertSame(this.context, UTUtil.getPrivateField(resources, "messageSource"));
        assertEquals(UTUtil.getPrivateField(resources, "formats").getClass(), MessageFormatCloneReturnIfUseDateFormatMap.class);
    }
    
    /**
     * testSpringMessageResourcesMessageResourcesFactoryStringboolean03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() factory:SpringMessageResourcesFactoryCX^X<br>
     *         () config:null<br>
     *         () returnNull:true<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config=null<br>
     *                    returnNull=true<br>
     *                    messageSource=OŃZbgapplicationContext<br>
     *         
     * <br>
     * nullBeannꍇAinitMessageSource()Ăяo邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSpringMessageResourcesMessageResourcesFactoryStringboolean03() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        
        // eXg{
        MessageResources resources = 
            new SpringMessageResources(factory, null, true);
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertNull(UTUtil.getPrivateField(resources, "config"));
        assertEquals(true, UTUtil.getPrivateField(resources, "returnNull"));
        assertSame(this.context, UTUtil.getPrivateField(resources, "messageSource"));
    }
    
    /**
     * testInitMessageSource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() Ȃ
     *         (O) factory:not null<br>
     *         (O) config:""i󕶎j<br>
     *         (O) returnNull:true<br> 
     *         (O) context:null<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ<br>
     *         (ԕω) messageSource:-<br>
     *         (ԕω) O:-<br>
     *         (ԕω) O:yWARNOz"ApplicationContext is not found."<br>
     *         
     * <br>
     * contextnull̏ꍇAWARNOo͂邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMessageSource01() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "" ,true);
        // contextnullɏB
        UTUtil.setPrivateField(resources, "context", null);
        
        // eXg{
        UTUtil.invokePrivate(resources, "initMessageSource");
        
        // 
        assertTrue(LogUTUtil.checkWarn("ApplicationContext is not found."));
    }
    
    /**
     * testInitMessageSource02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() Ȃ
     *         (O) factory:not null<br>
     *         (O) config:""i󕶎j<br>
     *         (O) returnNull:true<br> 
     *         (O) context:bNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ<br>
     *         (ԕω) messageSource:OŃZbgapplicationContext<br>
     *         (ԕω) O:-<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * config󕶎̏ꍇAftHg̃bZ[W\[XZbg邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMessageSource02() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "" ,true);
        // xmessageSourceB
        UTUtil.setPrivateField(resources, "messageSource", null);
        
        // eXg{
        UTUtil.invokePrivate(resources, "initMessageSource");
        
        // 
        assertSame(this.context, UTUtil.getPrivateField(resources, "messageSource"));
    }
    
    /**
     * testInitMessageSource03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() Ȃ
     *         (O) factory:not null<br>
     *         (O) config:null<br>
     *         (O) returnNull:true<br> 
     *         (O) context:bNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ<br>
     *         (ԕω) messageSource:OŃZbgapplicationContext<br>
     *         (ԕω) O:-<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * confignull̏ꍇAftHg̃bZ[W\[XZbg邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMessageSource03() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), null ,true);
        // xmessageSourceB
        UTUtil.setPrivateField(resources, "messageSource", null);
        
        // eXg{
        UTUtil.invokePrivate(resources, "initMessageSource");
        
        // 
        assertSame(this.context, UTUtil.getPrivateField(resources, "messageSource"));
    }
    
    /**
     * testInitMessageSource04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() Ȃ
     *         (O) factory:not null<br>
     *         (O) config:"propertyMessageSource01"i݂Beanj<br>
     *         (O) returnNull:true<br> 
     *         (O) context:bNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ<br>
     *         (ԕω) messageSource:MessageSourcẽTuNX<br>
     *         (ԕω) O:-<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * config݂Bean̏ꍇAbZ[W\[XZbg邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMessageSource04() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource01" ,true);
        // xmessageSourceB
        UTUtil.setPrivateField(resources, "messageSource", null);
        
        // eXg{
        UTUtil.invokePrivate(resources, "initMessageSource");
        
        // 
        assertTrue(UTUtil.getPrivateField(resources, "messageSource") instanceof MessageSource);
    }
    
    /**
     * testInitMessageSource05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() Ȃ
     *         (O) factory:not null<br>
     *         (O) config:"notExistBeanName"i݂ȂBeanj<br>
     *         (O) returnNull:true<br> 
     *         (O) context:bNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ<br>
     *         (ԕω) messageSource:MessageSourcẽTuNX<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.bean.exception"<br>
     *                    bvOFBeansExceptioñTuNX<br>
     *         (ԕω) O:yERROROz"notExistBeanName is not found or it is not MessageSource instance."<br>
     *         
     * <br>
     * config݂ȂBean̏ꍇAG[Oo͂A
     * OX[邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMessageSource05() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "" ,true);
        // xmessageSourceB
        UTUtil.setPrivateField(resources, "messageSource", null);
        UTUtil.setPrivateField(resources, "config", "notExistBeanName");
        
        // eXg{
        try {
            UTUtil.invokePrivate(resources, "initMessageSource");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.bean.exception", e.getErrorCode());
            assertTrue(e.getCause() instanceof BeansException);
            assertTrue(LogUTUtil.checkError("notExistBeanName is not found or it is not MessageSource instance."));
        }
    }
    
    /**
     * testGetMessage01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:null<br>
     *         () key:"property.message.key"<br>
     *         (O) config:""i󕶎j<br>
     *         (O) messageSource:null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * messageSourcenullreturnNulltruȅꍇAnullԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage01() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "" ,true);
        // messageSourcenullɏB
        UTUtil.setPrivateField(resources, "messageSource", null);
        
        // eXg{
        String message = resources.getMessage((Locale) null, "property.message.key");
        
        // 
        assertNull(message);
    }
    
    /**
     * testGetMessage02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:null<br>
     *         () key:"not.exist.key"i݂ȂL[j<br>
     *         (O) config:"propertyMessageSource01"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * localenullreturnNulltruȅꍇAftHgP[ɑ݂ȂL[
     * nnullԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage02() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource01" ,true);
        
        // eXg{
        String message = resources.getMessage((Locale) null, "not.exist.key");
        
        // 
        assertNull(message);
    }
    
    /**
     * testGetMessage03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.getDefault()<br>
     *         () key:"not.exist.key"i݂ȂL[j<br>
     *         (O) config:"propertyMessageSource01"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * localeftHgreturnNulltruȅꍇAftHgP[ɑ݂ȂL[
     * nnullԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage03() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource01" ,true);
        
        // eXg{
        String message = resources.getMessage(Locale.getDefault(), "not.exist.key");
        
        // 
        assertNull(message);
    }
    
    /**
     * testGetMessage04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.ENGLISH<br>
     *         () key:"not.exist.key_en"i݂ȂL[j<br>
     *         (O) config:"propertyMessageSource_locale_en"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest02_en.properties<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * localew肵returnNulltruȅꍇAw肵P[ɑ݂ȂL[
     * nnullԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage04() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource_locale_en" ,true);
        
        // eXg{
        String message = resources.getMessage(Locale.ENGLISH, "not.exist.key_en");
        
        // 
        assertNull(message);
    }
    
    /**
     * testGetMessage05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:null<br>
     *         () key:"property.message.key"<br>
     *         (O) config:"propertyMessageSource01"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[W"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * localenull̏ꍇAɃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage05() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource01" ,true);
        
        // eXg{
        String message = resources.getMessage((Locale) null, "property.message.key");
        
        // 
        assertEquals("eXgbZ[W", message);
    }
    
    /**
     * testGetMessage06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.getDefault()<br>
     *         () key:"property.message.key"<br>
     *         (O) config:"propertyMessageSource01"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[W"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * ftHgP[ŐɃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage06() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource01" ,true);
        
        // eXg{
        String message = resources.getMessage(Locale.getDefault(), "property.message.key");
        
        // 
        assertEquals("eXgbZ[W", message);
    }
    
    /**
     * testGetMessage07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.ENGLISH<br>
     *         () key:"property.message.key"<br>
     *         (O) config:"propertyMessageSource_locale_en"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest02_en.properties<br>
     * <br>
     * ҒlF(߂l) String:"test message"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * w肵P[ŐɃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage07() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource_locale_en" ,true);
        
        // eXg{
        String message = resources.getMessage(Locale.ENGLISH, "property.message.key");
        
        // 
        assertEquals("test message", message);
    }
    
    /**
     * testGetMessage08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:null<br>
     *         () key:"not.exist.key"i݂ȂL[j<br>
     *         (O) config:"propertyMessageSource01"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:false<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     * <br>
     * ҒlF(߂l) String:"???.not.exist.key???"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * localenullreturnNullfalsȅꍇAftHgP[ɑ݂ȂL[
     * nƃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage08() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource01" ,false);
        
        // eXg{
        String message = resources.getMessage((Locale) null, "not.exist.key");
        
        // 
        assertEquals("???.not.exist.key???", message);
    }
    
    /**
     * testGetMessage09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.getDefault()<br>
     *         () key:"not.exist.key"i݂ȂL[j<br>
     *         (O) config:"propertyMessageSource01"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:false<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     * <br>
     * ҒlF(߂l) String:"???.not.exist.key???"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * localeftHgreturnNullfalsȅꍇAftHgP[ɑ݂ȂL[
     * nƃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage09() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource01" ,false);
        
        // eXg{
        String message = resources.getMessage(Locale.getDefault(), "not.exist.key");
        
        // 
        assertEquals("???ja_JP.not.exist.key???", message);
    }
    
    /**
     * testGetMessage10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.ENGLISH<br>
     *         () key:"not.exist.key_en"i݂ȂL[j<br>
     *         (O) config:"propertyMessageSource_locale_en"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:false<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest02_en.properties<br>
     * <br>
     * ҒlF(߂l) String:"???en.not.exist.key_en???"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * localew肵returnNullfalsȅꍇAw肵P[ɑ݂ȂL[
     * nƃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage10() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource_locale_en" ,false);
        
        // eXg{
        String message = resources.getMessage(Locale.ENGLISH, "not.exist.key_en");
        
        // 
        assertEquals("???en.not.exist.key_en???", message);
    }
    
    /**
     * testGetMessage11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.getDefault()<br>
     *         () key:"property.message.key"<br>
     *         (O) config:"dbMessageSource01"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     *         (O) DBbZ[W:SpringMessageResourcesTest_DataSourceMessageSourceStub01<br>
     * <br>
     * ҒlF(߂l) String:"eXgDBbZ[W"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * ꃁbZ[W\[XDBbZ[W\[XA񃁃bZ[W\[X
     * vpeBbZ[W\[Xw肵ꍇAõbZ[W\[X
     * ʂɑ݂Ă郁bZ[WL[nƁAꃁbZ[W\[X
     * ɃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage11() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "dbMessageSource01" ,true);
        
        // eXg{
        String message = resources.getMessage(Locale.getDefault(), "property.message.key");
        
        // 
        assertEquals("eXgDBbZ[W", message);
    }
    
    /**
     * testGetMessage12()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.getDefault()<br>
     *         () key:"property.message.key"<br>
     *         (O) config:"dbMessageSource02"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     *         (O) DBbZ[W:SpringMessageResourcesTest_DataSourceMessageSourceStub02<br>
     * <br>
     * ҒlF(߂l) String:"eXgbZ[W"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * ꃁbZ[W\[XDBbZ[W\[XA񃁃bZ[W\[X
     * vpeBbZ[W\[Xw肵ꍇAꃁbZ[W\[X
     * ݂ȂbZ[WL[nƁA񃁃bZ[W\[X
     * ɃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage12() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "dbMessageSource02" ,true);
        
        // eXg{
        String message = resources.getMessage(Locale.getDefault(), "property.message.key");
        
        // 
        assertEquals("eXgbZ[W", message);
    }
    
    /**
     * testGetMessage13()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.getDefault()<br>
     *         () key:"db.message.key"<br>
     *         (O) config:"propertyMessageSource02"<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     *         (O) DBbZ[W:SpringMessageResourcesTest_DataSourceMessageSourceStub02<br>
     * <br>
     * ҒlF(߂l) String:"eXgDBbZ[W"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * ꃁbZ[W\[XɃvpeBbZ[W\[XA񃁃bZ[W\[X
     * DBbZ[W\[Xw肵ꍇAꃁbZ[W\[X
     * ݂ȂbZ[WL[nƁA񃁃bZ[W\[X
     * ɃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage13() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "propertyMessageSource02" ,true);
        
        // eXg{
        String message = resources.getMessage(Locale.getDefault(), "db.message.key");
        
        // 
        assertEquals("eXgDBbZ[W", message);
    }
    
    /**
     * testGetMessage14()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() locale:Locale.getDefault()<br>
     *         () key:"default.message.key"<br>
     *         (O) config:""i󕶎j<br>
     *         (O) messageSource:not null<br>
     *         (O) returnNull:true<br>
     *         (O) Bean`t@C:SpringMessageResourcesTest01.xml<br>
     *         (O) bZ[WvpeBt@C:SpringMessageResourcesTest01.properties<br>
     * <br>
     * ҒlF(߂l) String:"ftHgbZ[W"<br>
     *         (ԕω) O:-<br>
     *         
     * <br>
     * config󕶎łꍇABean"messageSource"ł郁bZ[W\[X
     * ftHgŎ擾AɃbZ[Wԋp邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage14() throws Exception {
        // O
        MessageResources resources = 
            new SpringMessageResources(
                    new SpringMessageResourcesFactory(), "" ,true);
        
        // eXg{
        String message = resources.getMessage(Locale.getDefault(), "default.message.key");
        
        // 
        assertEquals("ftHgbZ[W", message);
    }
}
