/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.VariableInfo;

import junit.framework.TestCase;

/**
 * StringFormatterTeiBase ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class StringFormatterTeiBaseTest extends TestCase {

    // eXgΏ
    StringFormatterTeiBaseImpl01 tag = null;

    /**
     * Constructor for StringFormatterTeiBaseTest.
     * @param arg0
     */
    public StringFormatterTeiBaseTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = new StringFormatterTeiBaseImpl01();
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testGetVariableInfo01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FEF
     * <br><br>
     * ͒lF() data:new TagData({{"idon","id"}})<br>
     *         
     * <br>
     * ҒlF(߂l) VariableInfo[]:̔z<br>
     *         (ԕω) variavleInfoz:0<br>
     *         
     * <br>
     * TagDataɕێĂhidh̒lNULLŁAVariableInfoz(vf0)ԋp邱Əꍇ̃eXgP[X
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetVariableInfo01() throws Exception {

        // eXgf[^ݒ
        Object[][] att = {{"idon","id"}};
        TagData data = new TagData(att);

        // eXgs
        VariableInfo[] vInfo = tag.getVariableInfo(data);

        // eXgʊmF
        assertEquals(0, vInfo.length);

    } /* testGetVariableInfo01 End */

    /**
     * testGetVariableInfo02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FEF
     * <br><br>
     * ͒lF() data:new TagData({{"id","id"}})<br>
     *         
     * <br>
     * ҒlF(߂l) VariableInfo[]:Not Null<br>
     *         (ԕω) variableInfo[0].varName:"id"<br>
     *         (ԕω) variableInfo[0].className:"java.lang.String"<br>
     *         (ԕω) variableInfo[0].declare:true<br>
     *         (ԕω) variableInfo[0].scope:VariableInfo.AT_BEGIN<br>
     *         (ԕω) variavleInfoz:1<br>
     *         
     * <br>
     * TagDataɕێĂhidh̒lNULLł͂ȂAVariableInfoz(vf1)ԋp邱Əꍇ̃eXgP[X
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetVariableInfo02() throws Exception {

        // eXgf[^ݒ
        Object[][] att = {{"id","id"}};
        TagData data = new TagData(att);

        // eXgs
        VariableInfo[] vInfo = tag.getVariableInfo(data);

        // eXgʊmF
        assertEquals(1, vInfo.length);
        assertEquals("id", vInfo[0].getVarName());
        assertEquals("java.lang.String", vInfo[0].getClassName());
        assertTrue(vInfo[0].getDeclare());
        assertEquals(VariableInfo.AT_BEGIN,vInfo[0].getScope());

    } /* testGetVariableInfo02 End */

    /**
     * testGetVariableInfo03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() data:Null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *         
     * <br>
     * nullłƂNullPointerException̂mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetVariableInfo03() throws Exception {
        
        try{
            // eXgs
            tag.getVariableInfo(null);
            fail();
        } catch (NullPointerException e) {
            // 
        }

        

    } /* testGetVariableInfo03 End */
} /* StringFormatterTeiBaseTest */
