/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.MockServletContext;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import junit.framework.TestCase;

import com.mockrunner.mock.web.MockServletConfig;

/**
 * {@link jp.terasoluna.fw.web.taglib.TagUtil} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * JX^^O@\Sʂɒʂ郆[eBeBNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.taglib.TagUtil
 */
@SuppressWarnings("unused")
public class TagUtilTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TagUtilTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public TagUtilTest(String name) {
        super(name);
    }

    /**
     * testGetScope01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() scopeName:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *         
     * <br>
     * scopeNamenull̎AOX[邱ƁBlookup\bh̃eXgP[XœłȂp^[
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetScope01() throws Exception {
        // eXg{
        try {
            int result = TagUtil.getScope(null);
            fail();
        } catch (JspException e) {
           //  
        }
    }

    /**
     * testLookupPageContextStringStringString01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () property:null<br>
     *         () scopeName:null<br>
     *         () pageContext.attributes.get(name):TagUtil_BeanStub01[param1="page"]<br>
     *         () pageContext.request.getAttribute(name):TagUtil_BeanStub01[param1="request"]<br>
     *         () pageContext.session.getAttribute(name):TagUtil_BeanStub01[param1="session"]<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:TagUtil_BeanStub01[param1="page"]<br>
     *         
     * <br>
     * propertynullAscopeNamenull̎ApageScope擾Objectԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString01() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean1 = new TagUtil_BeanStub01(); 
        bean1.setParam1("page");
        TagUtil_BeanStub01 bean2 = new TagUtil_BeanStub01(); 
        bean2.setParam1("request");
        TagUtil_BeanStub01 bean3 = new TagUtil_BeanStub01(); 
        bean3.setParam1("session");
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", bean1);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("name", bean2);
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("name", bean3);
        request.setSession(session);
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "attributes", attributes);
        UTUtil.setPrivateField(pc, "request", request);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        Object result = TagUtil.lookup(pc, "name", null, null);
        
        // 
        assertEquals("page", ((TagUtil_BeanStub01) result).getParam1());
    }

    /**
     * testLookupPageContextStringStringString02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () property:null<br>
     *         () scopeName:"page"<br>
     *         () pageContext.attributes.get(name):TagUtil_BeanStub01[param1="page"]<br>
     *         () pageContext.request.getAttribute(name):TagUtil_BeanStub01[param1="request"]<br>
     *         () pageContext.session.getAttribute(name):TagUtil_BeanStub01[param1="session"]<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:TagUtil_BeanStub01[param1="page"]<br>
     *         
     * <br>
     * propertynullAscopeName"page"̎ApageScope擾Objectԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString02() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean1 = new TagUtil_BeanStub01(); 
        bean1.setParam1("page");
        TagUtil_BeanStub01 bean2 = new TagUtil_BeanStub01(); 
        bean2.setParam1("request");
        TagUtil_BeanStub01 bean3 = new TagUtil_BeanStub01(); 
        bean3.setParam1("session");
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", bean1);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("name", bean2);
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("name", bean3);
        request.setSession(session);
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "attributes", attributes);
        UTUtil.setPrivateField(pc, "request", request);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        Object result = TagUtil.lookup(pc, "name", null, "page");
        
        // 
        assertEquals("page", ((TagUtil_BeanStub01) result).getParam1());
    }

    /**
     * testLookupPageContextStringStringString03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () scopeName:"page"<br>
     *         () pageContext.attributes.get(name):null<br>
     *         () pageContext.request.getAttribute(name):TagUtil_BeanStub01[param1="request"]<br>
     *         () pageContext.session.getAttribute(name):TagUtil_BeanStub01[param1="session"]<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *         
     * <br>
     * propertynullAscopeName"page"̎ApageScopebeani[ĂȂ΁AO邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString03() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean2 = new TagUtil_BeanStub01(); 
        bean2.setParam1("request");
        TagUtil_BeanStub01 bean3 = new TagUtil_BeanStub01(); 
        bean3.setParam1("session");
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("name", bean2);
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("name", bean3);
        request.setSession(session);
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "request", request);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        try {
            Object result = TagUtil.lookup(pc, "name", null, "page");
        } catch (JspException e) {
            // 
        }
    }

    /**
     * testLookupPageContextStringStringString04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () property:null<br>
     *         () scopeName:"request"<br>
     *         () pageContext.attributes.get(name):TagUtil_BeanStub01[param1="page"]<br>
     *         () pageContext.request.getAttribute(name):TagUtil_BeanStub01[param1="request"]<br>
     *         () pageContext.session.getAttribute(name):TagUtil_BeanStub01[param1="session"]<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:TagUtil_BeanStub01[param1="request"]<br>
     *         
     * <br>
     * propertynullAscopeName"request"̎ArequestScope擾Objectԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString04() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean1 = new TagUtil_BeanStub01(); 
        bean1.setParam1("page");
        TagUtil_BeanStub01 bean2 = new TagUtil_BeanStub01(); 
        bean2.setParam1("request");
        TagUtil_BeanStub01 bean3 = new TagUtil_BeanStub01(); 
        bean3.setParam1("session");
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", bean1);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("name", bean2);
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("name", bean3);
        request.setSession(session);
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "attributes", attributes);
        UTUtil.setPrivateField(pc, "request", request);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        Object result = TagUtil.lookup(pc, "name", null, "request");
        
        // 
        assertEquals("request", ((TagUtil_BeanStub01) result).getParam1());
    }

    /**
     * testLookupPageContextStringStringString05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () scopeName:"request"<br>
     *         () pageContext.attributes.get(name):TagUtil_BeanStub01[param1="page"]<br>
     *         () pageContext.request.getAttribute(name):null<br>
     *         () pageContext.session.getAttribute(name):TagUtil_BeanStub01[param1="session"]<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *         
     * <br>
     * propertynullAscopeName"request"̎ArequestScopebeani[ĂȂ΁AO邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString05() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean1 = new TagUtil_BeanStub01(); 
        bean1.setParam1("page");
        TagUtil_BeanStub01 bean3 = new TagUtil_BeanStub01(); 
        bean3.setParam1("session");
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", bean1);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("name", bean3);
        request.setSession(session);
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "attributes", attributes);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        try {
            Object result = TagUtil.lookup(pc, "name", null, "request");
        } catch (JspException e) {
            // 
        }
    }

    /**
     * testLookupPageContextStringStringString06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () property:null<br>
     *         () scopeName:"session"<br>
     *         () pageContext.attributes.get(name):TagUtil_BeanStub01[param1="page"]<br>
     *         () pageContext.request.getAttribute(name):TagUtil_BeanStub01[param1="request"]<br>
     *         () pageContext.session.getAttribute(name):TagUtil_BeanStub01[param1="session"]<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:TagUtil_BeanStub01[param1="session"]<br>
     *         
     * <br>
     * propertynullAscopeName"session"̎AsessionScope擾Objectԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString06() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean1 = new TagUtil_BeanStub01(); 
        bean1.setParam1("page");
        TagUtil_BeanStub01 bean2 = new TagUtil_BeanStub01(); 
        bean2.setParam1("request");
        TagUtil_BeanStub01 bean3 = new TagUtil_BeanStub01(); 
        bean3.setParam1("session");
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", bean1);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("name", bean2);
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("name", bean3);
        request.setSession(session);
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "attributes", attributes);
        UTUtil.setPrivateField(pc, "request", request);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        Object result = TagUtil.lookup(pc, "name", null, "session");
        
        // 
        assertEquals("session", ((TagUtil_BeanStub01) result).getParam1());
    }

    /**
     * testLookupPageContextStringStringString07()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () scopeName:"session"<br>
     *         () pageContext.attributes.get(name):TagUtil_BeanStub01[param1="page"]<br>
     *         () pageContext.request.getAttribute(name):TagUtil_BeanStub01[param1="request"]<br>
     *         () pageContext.session.getAttribute(name):null<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *         
     * <br>
     * propertynullAscopeName"session"̎AsessionScopebeani[ĂȂ΁AO邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString07() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean1 = new TagUtil_BeanStub01(); 
        bean1.setParam1("page");
        TagUtil_BeanStub01 bean2 = new TagUtil_BeanStub01(); 
        bean2.setParam1("request");
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", bean1);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("name", bean2);
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "attributes", attributes);
        UTUtil.setPrivateField(pc, "request", request);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        try {
            Object result = TagUtil.lookup(pc, "name", null, "session");
        } catch (JspException e) {
            // 
        }
    }

    /**
     * testLookupPageContextStringStringString08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () property:null<br>
     *         () scopeName:"application"<br>
     *         () pageContext.attributes.get(name):TagUtil_BeanStub01[param1="page"]<br>
     *         () pageContext.request.getAttribute(name):TagUtil_BeanStub01[param1="request"]<br>
     *         () pageContext.session.getAttribute(name):TagUtil_BeanStub01[param1="session"]<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * propertynullAscopeName"application"̎AapplicationScope擾Objectԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString08() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean1 = new TagUtil_BeanStub01(); 
        bean1.setParam1("page");
        TagUtil_BeanStub01 bean2 = new TagUtil_BeanStub01(); 
        bean2.setParam1("request");
        TagUtil_BeanStub01 bean3 = new TagUtil_BeanStub01(); 
        bean3.setParam1("session");
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", bean1);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("name", bean2);
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("name", bean3);
        request.setSession(session);
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "attributes", attributes);
        UTUtil.setPrivateField(pc, "request", request);
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        Object result = TagUtil.lookup(pc, "name", null, "application");
        
        // 
        assertEquals("application", ((TagUtil_BeanStub01) result).getParam1());
    }

    /**
     * testLookupPageContextStringStringString09()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () scopeName:"application"<br>
     *         () pageContext.attributes.get(name):TagUtil_BeanStub01[param1="page"]<br>
     *         () pageContext.request.getAttribute(name):TagUtil_BeanStub01[param1="request"]<br>
     *         () pageContext.session.getAttribute(name):TagUtil_BeanStub01[param1="session]"]<br>
     *         () pageContext.application.getAttribute(name):null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *         
     * <br>
     * propertynullAscopeName"application"̎AapplicationScopebeani[ĂȂ΁AO邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString09() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean1 = new TagUtil_BeanStub01(); 
        bean1.setParam1("page");
        TagUtil_BeanStub01 bean2 = new TagUtil_BeanStub01(); 
        bean2.setParam1("request");
        TagUtil_BeanStub01 bean3 = new TagUtil_BeanStub01(); 
        bean3.setParam1("session");
        
        // beansetAttribute
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", bean1);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("name", bean2);
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("name", bean3);
        request.setSession(session);
        
        // PageContextɐݒ
        UTUtil.setPrivateField(pc, "attributes", attributes);
        UTUtil.setPrivateField(pc, "request", request);
        
        // eXg{
        try {
            Object result = TagUtil.lookup(pc, "name", null, "application");
        } catch (JspException e) {
            // 
        }
    }

    /**
     * testLookupPageContextStringStringString10()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () scopeName:"nothing"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *         
     * <br>
     * scopeNamezO̎̕AO邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString10() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // eXg{
        try {
            Object result = TagUtil.lookup(pc, "name", null, "nothing");
        } catch (JspException e) {
            // 
        }
    }

    /**
     * testLookupPageContextStringStringString11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () property:"param1"<br>
     *         () scopeName:"APPLICATION"<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param1="application"]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:"application"<br>
     *         
     * <br>
     * bean擾łApropertyɎw肳ꂽtB[h݂鎞ÃtB[hlԋp邱ƁB܂AscopeName啶łI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString11() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        Object result = TagUtil.lookup(pc, "name", "param1", "APPLICATION");
        
        // 
        assertEquals("application", result);
    }

    /**
     * testLookupPageContextStringStringString12()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () property:"param2"<br>
     *         () scopeName:"application"<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[getParam2Exception]<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspExceptionF<br>
     *                    bvOFInvocatinTargetException<br>
     *         
     * <br>
     * bean擾łApropertyɎw肳ꂽtB[hl擾ɗOAJspExceptionInvocatinTargetExceptionbvăX[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString12() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        try {
            Object result = TagUtil.lookup(pc, "name", "param2", "application");
        } catch (JspException e) {
            // 
            assertEquals(InvocationTargetException.class.getName(), e
                    .getRootCause().getClass().getName());
        }
    }
    
    /**
     * testLookupPageContextStringStringString13()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () name:"name"<br>
     *         () property:"param3"<br>
     *         () scopeName:"application"<br>
     *         () pageContext.application.getAttribute(name):TagUtil_BeanStub01[param3݂Ȃ]<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspExceptionF<br>
     *                    bvOFNoSuchMethodException<br>
     *         
     * <br>
     * bean擾łApropertyɎw肳ꂽtB[h݂ȂAJspExceptionNoSuchMethodExceptionbvăX[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupPageContextStringStringString13() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);
        
        // bean
        TagUtil_BeanStub01 bean4 = new TagUtil_BeanStub01(); 
        bean4.setParam1("application");
        
        // beansetAttribute
        MockServletContext application = new MockServletContext();
        application.setAttribute("name", bean4);
        
        // PageContextɐݒ
        MockServletConfig config = new MockServletConfig();
        config.setServletContext(application);
        UTUtil.setPrivateField(pc, "config", config);
        
        // eXg{
        try {
            Object result = TagUtil.lookup(pc, "name", "param4", "application");
        } catch (JspException e) {
            // 
            assertEquals(NoSuchMethodException.class.getName(), e
                    .getRootCause().getClass().getName());
        }
    }

    /**
     * testWrite01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () text:"text"<br>
     *         
     * <br>
     * ҒlF(ԕω) o͓e:"text"<br>
     *         
     * <br>
     * o͂邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWrite01() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);

        // eXg{
        TagUtil.write(pc, "text");

        // 
        assertEquals("text", pc.getOut().toString());
    }

    /**
     * testWrite02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() pageContext:writer.print(text)sIOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspExceptionF<br>
     *                    bvOFIOException<br>
     *         
     * <br>
     * writerIOExceptionAJspExceptionŃbvăX[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWrite02() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);

        // IOExceptionJspWriter𐶐
        Exception_JspWriterImpl writer = new Exception_JspWriterImpl();
        writer.setTrue();
        UTUtil.setPrivateField(pc, "jspWriter", writer);

        // eXg{
        try {
            TagUtil.write(pc, "text");
        } catch (JspException e) {
            // 
            assertEquals(IOException.class.getName(), e.getRootCause()
                    .getClass().getName());
        }
    }

    /**
     * testWriteln01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() pageContext:not null<br>
     *         () text:"text(s)"<br>
     *         
     * <br>
     * ҒlF(ԕω) o͓e:"text(s)"<br>
     *         
     * <br>
     * o͂邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWriteln01() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);

        // eXg{
        TagUtil.writeln(pc, "text");

        // 
        String lineSeparator = System.getProperty("line.separator");
        assertEquals("text" + lineSeparator, pc.getOut().toString());
    }

    /**
     * testWriteln02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() pageContext:writer.print(text)sIOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspExceptionF<br>
     *                    bvOFIOException<br>
     *         
     * <br>
     * writerIOExceptionAJspExceptionŃbvăX[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWriteln02() throws Exception {
        // O
        // TagUTUtil#getPageContext()gp邽ߓKtag𗘗p
        TagSupport tag = TagUTUtil.create(TagSupport.class);
        PageContext pc = TagUTUtil.getPageContext(tag);

        // IOExceptionJspWriter𐶐
        Exception_JspWriterImpl writer = new Exception_JspWriterImpl();
        writer.setTrue();
        UTUtil.setPrivateField(pc, "jspWriter", writer);
        
        // eXg{
        try {
            TagUtil.writeln(pc, "text");
        } catch (JspException e) {
            // 
            assertEquals(IOException.class.getName(), e.getRootCause()
                    .getClass().getName());
        }
    }

    /**
     * testFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * valuenull̎Anullԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testFilter01() throws Exception {
        // eXg{
        String result = TagUtil.filter(null);
        // 
        assertNull(result);
    }

    /**
     * testFilter02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(߂l) String:""i󕶎j<br>
     *         
     * <br>
     * value󕶎̎A󕶎ԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testFilter02() throws Exception {
        // eXg{
        String result = TagUtil.filter("");
        // 
        assertEquals("", result);
    }

    /**
     * testFilter03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:<>&"'<br>
     *         
     * <br>
     * ҒlF(߂l) String:&lt;&gt;&amp;&quot;&#39;<br>
     *         
     * <br>
     * valueɃtB^[Ώە񂪂ꍇAtB^[ĕԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testFilter03() throws Exception {
        // eXg{
        String result = TagUtil.filter("<>&\"'");
        // 
        assertEquals("&lt;&gt;&amp;&quot;&#39;", result);
    }

}
