/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.beans.propertyeditors.CustomDateEditor;

/**
 * {@link jp.terasoluna.fw.beans.DatePropertyEditorRegistrar} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Date^̃vpeBGfB^𐶐NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.DatePropertyEditorRegistrar
 */
public class DatePropertyEditorRegistrarTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DatePropertyEditorRegistrarTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DatePropertyEditorRegistrarTest(String name) {
        super(name);
    }

    /**
     * testSetDateFormat01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() dateFormat:SimpleDateFormat("yyyyMMdd")<br>
     *         () this.dateFormat:SimpleDateFormat("yyyy/MM/dd")<br>
     *         () Ȃ:[<br>
     *         
     * <br>
     * ҒlF(ԕω) this.dateFormat:SimpleDateFormat("yyyyMMdd")<br>
     *         
     * <br>
     * dateFormateset\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDateFormat01() throws Exception {
        // O
    	DatePropertyEditorRegistrar registrar
    		= new DatePropertyEditorRegistrar();
    	DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

        // eXg{
    	registrar.setDateFormat(dateFormat);

        // 
    	assertSame(dateFormat, UTUtil.getPrivateField(registrar, "dateFormat"));
    }

    /**
     * testRegisterCustomEditors01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() registry:PropertyEditorRegistrỹbN<br>
     *         () this.dateFormat:SimpleDateFormat("yyyy/MM/dd")<br>
     *         
     * <br>
     * ҒlF(ԕω) registry.registerCustomEditorij:󂯎ƂmFB<br>
     *         
     * <br>
     * vpeBGfB^\bhĂяoeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRegisterCustomEditors01() throws Exception {
        // O
    	DatePropertyEditorRegistrar registrar
            = new DatePropertyEditorRegistrar();
    	PropertyEditorRegistrar_PropertyEditorRegistryStub01 registry
    		= new PropertyEditorRegistrar_PropertyEditorRegistryStub01();

        // eXg{
    	registrar.registerCustomEditors(registry);

        // 
    	assertSame(Date.class, registry.clazz);
    	assertSame(CustomDateEditor.class, registry.editor.getClass());
    	SimpleDateFormat resultDateFormat 
    		= (SimpleDateFormat) UTUtil.getPrivateField(registry.editor, "dateFormat");
    	assertSame("yyyy/MM/dd", UTUtil.getPrivateField(resultDateFormat, "pattern"));
    }

}
