/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib.spring;

import java.sql.SQLException;

import javax.sql.DataSource;

import jp.terasoluna.utlib.DBSequence;

import org.springframework.jdbc.core.JdbcTemplate;

/**
 * <p>PostgresSQL DBŃVPXl̐ݒƎ擾@\</p>
 *
 * @version 1.0
 */
public class SpringPostgresDBSequence implements DBSequence{

    /**
     * f[^\[X
     */
    private DataSource dataSource;
    
    /**
     * Spring jdbcTemplate
     */
    protected JdbcTemplate jdbcTemplate;
    
    /**
     * w肵VPX̌ݒl擾B
     * 
     * @param sequenceName VPX
     * @return@VPX̌ݒl
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public int getSequenceValue(String sequenceName) throws SQLException{

        //VPX擾邽߂SQL\zB
        //Fselect currval('reserve_number_seq');
        StringBuffer buf = new StringBuffer();
        
        buf.append("select currval('");
        buf.append(sequenceName);
        buf.append("');");
        
        return jdbcTemplate.queryForInt(buf.toString()  );

    }
    
    /**
     * w肵VPXɒlݒ肷B
     * 
     * @param sequenceName@VPX
     * @param value@VPXɐݒ肷l
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public void setSequenceValue(String sequenceName,int value) throws SQLException{
        //VPXݒ肷邽߂SQL\zB
        //Fselect setval('reserve_number_seq',10);
        StringBuffer buf = new StringBuffer();
        
        buf.append("select setval('");
        buf.append(sequenceName);
        buf.append("',");
        buf.append(value);
        buf.append(");");
        
        jdbcTemplate.queryForInt(buf.toString());

    }

    /**
     * <p>f[^\[X擾B</p>
     *
     * @return dataSource f[^\[X
     */
    public DataSource getDataSource() {
        return dataSource;
    }

    /**
     * <p>f[^\[Xݒ肷B</p>
     *
     * @param dataSource f[^\[X
     */
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        jdbcTemplate = new JdbcTemplate(dataSource);
    }
    
}
