package jp.terasoluna.fw.ex.unit.mock;

import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.dao.event.DataRowHandler;

/**
 * f[^[nh[R[obNŎgpNXłB
 * <p>
 * {@link MockQueryRowHandleDao}ƍ킹ĎgpĂB<br>
 * gp{@link MockQueryRowHandleDao}QƁB
 * </p>
 * @since 2.1.0
 */
public abstract class DataRowHandleCallback implements Callback {

    public final void execute(Object[] args) {
        String sqlId = (String) args[0];
        Object[] bindParams = (Object[]) args[1];
        DataRowHandler handler = (DataRowHandler) args[2];
        handle(sqlId, bindParams, handler);
    }

    /**
     * f[^[nh[s܂B
     * <p>
     * gpNXŃI[oChĎĂB<br>
     * {@link QueryRowHandleDAO#executeWithRowHandler(String, Object, DataRowHandler)}
     * sƁA{s܂B
     * {@link QueryRowHandleDAO#executeWithRowHandler(String, Object, DataRowHandler)}
     * ɓnꂽ̂̂܂ܓn܂B<br>
     * Ff[^10郂bN̗
     * </p>
     * 
     * <pre>
     * void handle(String sqlId, Object[] bindParams, DataRowHandler handler) {
     *     for (int i = 0; i &lt; 10; i++) {
     *         handler.handleRow(&quot;str&quot; + i); // SQL̕Ԃl̊es̒lstr1, str2, ...,
     *                                       // str10Ƃꍇ̃bN
     *     }
     * }
     * </pre>
     * 
     * @param sqlId SQLID
     * @param bindParams up[^
     * @param handler f[^[nh[
     */
    public abstract void handle(String sqlId, Object[] bindParams,
            DataRowHandler handler);
}
