/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;

import org.springframework.util.Assert;

public class ClassLoaderUtils {
    protected volatile static ClassLoader previousClassLoader = null;

    private static Method getAddURLMethod() {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL",
                    new Class<?>[] { URL.class });
            method.setAccessible(true);
            return method;
        } catch (Exception e) {
            throw new UTRuntimeException(e);
        }
    }

    /**
     * ̃Xbh̃ReLXg̃NX[_Ԃ܂B
     * 
     * @return NX[_
     */
    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /**
     * ̃Xbh̃ReLXg̃NX[_ݒ肵܂B
     * 
     * @param cl
     *            NX[_
     */
    public static void setClassLoader(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    /**
     * <pre>
     * ̃Xbh̃NX[_̃NXpXɈurlǉVNX[_쐬A
     * ̃Xbh̃ReLXg̃NX[_ݒ肵܂B
     * 
     * ̃Xbh̃ReLXg̃NX[_
     * {\bhɂčXVÕNX[_ɖ߂ꍇA
     * {@link #resetClassLoader()}gpĂB
     * </pre>
     * 
     * @param url
     *            ǉpX
     */
    public static void addClassPath(URL url) {
        Assert.notNull(url);
        ClassLoader cl = getClassLoader();

        URLClassLoader newCl = null;
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader) cl;
            newCl = new URLClassLoader(ucl.getURLs(), cl);
        } else {
            newCl = new URLClassLoader(null, cl);
        }

        Method method = getAddURLMethod();

        try {
            method.invoke(newCl, url);
        } catch (Exception e) {
            throw new UTRuntimeException(e);
        }

        previousClassLoader = cl;
        setClassLoader(newCl);
    }

    /**
     * ̃Xbh̃ReLXg̃NX[_addClassPathɂčXVÕNX[_ɖ߂܂B
     */
    public static void resetClassLoader() {
        if (previousClassLoader != null) {
            setClassLoader(previousClassLoader);
        }
    }

    /**
     * <pre>
     * ̃Xbh̃NX[_̃NXpXɈ̃t@CǉVNX[_쐬A
     * ̃Xbh̃ReLXg̃NX[_ݒ肵܂B
     * 
     * ̃Xbh̃ReLXg̃NX[_
     * {\bhɂčXVÕNX[_ɖ߂ꍇA
     * {@link #resetClassLoader()}gpĂB
     * 
     * t@C݂Ȃꍇ{@link UTRuntimeException}X[܂B
     * </pre>
     * 
     * @param file
     *            ǉpX
     * @throws UTRuntimeException
     *             t@C݂Ȃꍇ
     */
    public static void addClassPath(File file) {
        Assert.notNull(file);
        try {
            if (file.exists()) {
                addClassPath(file.toURI().toURL());
            }
        } catch (MalformedURLException e) {
            throw new UTRuntimeException(e);
        }
    }

    /**
     * <pre>
     * ̃Xbh̃NX[_̃NXpXɈ̃pXǉVNX[_쐬A
     * ̃Xbh̃ReLXg̃NX[_ݒ肵܂B
     * 
     * ̃Xbh̃ReLXg̃NX[_
     * {\bhɂčXVÕNX[_ɖ߂ꍇA
     * {@link #resetClassLoader()}gpĂB
     * 
     * pX݂Ȃꍇ{@link UTRuntimeException}X[܂B
     * </pre>
     * 
     * @param path
     *            ǉpX
     * @throws UTRuntimeException
     *             pX݂Ȃꍇ
     */
    public static void addClassPath(String path) {
        Assert.notNull(path);
        addClassPath(new File(path));
    }

    /**
     * <pre>
     * srcPathsɊ܂܂pXꂼɑ΂āA
     * ̃Xbh̃ReLXg̃NX[_̃NXpX
     * ݂ꍇAdestPathsɒǉ܂B
     * </pre>
     * 
     * @param destPaths
     * @param srcPaths
     */
    public static void addPathIfExists(List<String> destPaths,
            List<String> srcPaths) {
        Assert.notNull(destPaths);
        Assert.notNull(srcPaths);

        ClassLoader cl = getClassLoader();
        for (String path : srcPaths) {
            if (path != null && cl.getResource(path) != null) {
                destPaths.add(path);
            }
        }
    }
}
