/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.service.thin;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicMapperException;
import jp.terasoluna.fw.service.thin.BLogicProperty;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.util.StringUtil;
import jp.terasoluna.fw.web.struts.actions.AbstractDownloadObject;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBLogicMapper {
    private static Log log = LogFactory.getLog(AbstractBLogicMapper.class);
    private static final String NULL_RESULT_KEY = "errors.blogic.mapper.result";
    private static final String ERROR_SOURCE = "errors.blogic.mapper.source";
    private static final String ERROR_DEST = "errors.blogic.mapper.dest";
    private static final String ERROR_BEAN_CREATE = "errors.blogic.mapper.create";
    private static final String ERROR_GETPROPERTY = "errors.blogic.mapper.getproperty";
    private static final String ERROR_SETPROPERTY = "errors.blogic.mapper.setproperty";
    private static final String ERROR_GETVALUE = "errors.blogic.mapper.getvalue";
    private static final String ERROR_SETVALUE = "errors.blogic.mapper.setvalue";
    private static final String ERROR_BEAN_NOTNULL = "errors.blogic.mapper.notnull";

    public Object mapBLogicParams(HttpServletRequest request, HttpServletResponse response, BLogicIO io) {
        if (io == null) {
            return null;
        }
        if (io.getInputBeanName() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"blogic-io.inputBeanName is null.");
            }
            return null;
        }
        return this.setParams(request, response, io);
    }

    protected Object setParams(HttpServletRequest request, HttpServletResponse response, BLogicIO io) {
        Iterator<BLogicProperty> it = io.getBLogicParams().iterator();
        Object bean = null;
        if (it.hasNext()) {
            try {
                bean = ClassUtil.create((String)io.getInputBeanName());
            }
            catch (ClassLoadException e) {
                log.error((Object)"bean creation failure.");
                throw new SystemException((Throwable)e, ERROR_BEAN_CREATE);
            }
        } else {
            return null;
        }
        while (it.hasNext()) {
            BLogicProperty property = it.next();
            String propertyName = property.getProperty();
            String blogicPropertyName = property.getBLogicProperty();
            if (blogicPropertyName == null) {
                blogicPropertyName = propertyName;
            }
            if (!"".equals(property.getSource()) && property.getSource() != null) {
                Object[] methodParams = new Object[]{propertyName, request, response};
                Class[] parameterTypes = new Class[]{String.class, HttpServletRequest.class, HttpServletResponse.class};
                Object value = null;
                try {
                    value = MethodUtils.invokeMethod((Object)this, (String)("getValueFrom" + StringUtil.capitalizeInitial((String)property.getSource())), (Object[])methodParams, (Class[])parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)"no such method.");
                    throw new SystemException((Throwable)new BLogicMapperException(e), ERROR_GETVALUE, new String[]{propertyName});
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"illegal access to the method.");
                    throw new SystemException((Throwable)new BLogicMapperException(e), ERROR_GETVALUE, new String[]{propertyName});
                }
                catch (InvocationTargetException e) {
                    log.error((Object)"exception is thrown out by invokeMethod.");
                    throw new SystemException((Throwable)new BLogicMapperException(e), ERROR_GETVALUE, new String[]{propertyName});
                }
                try {
                    BeanUtil.setBeanProperty((Object)bean, (String)blogicPropertyName, (Object)value);
                    continue;
                }
                catch (PropertyAccessException e) {
                    log.error((Object)"setBeanProperty failure.");
                    throw new SystemException((Throwable)new BLogicMapperException(e), ERROR_SETPROPERTY, new String[]{blogicPropertyName});
                }
            }
            log.error((Object)"source is illegal.");
            throw new SystemException((Throwable)new BLogicMapperException(), ERROR_SOURCE);
        }
        return bean;
    }

    public abstract Object getValueFromRequest(String var1, HttpServletRequest var2, HttpServletResponse var3);

    public abstract Object getValueFromSession(String var1, HttpServletRequest var2, HttpServletResponse var3);

    public void mapBLogicResult(HttpServletRequest request, HttpServletResponse response, BLogicIO io, BLogicResult result) {
        if (result == null) {
            log.error((Object)"BLogicResult is null.");
            throw new SystemException((Throwable)new BLogicMapperException(new NullPointerException()), NULL_RESULT_KEY);
        }
        Object bean = result.getResultObject();
        if (bean == null) {
            return;
        }
        if (bean instanceof AbstractDownloadObject) {
            return;
        }
        if (io == null && bean != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The bean should be null.");
            }
            log.error((Object)"bean is not null.");
            throw new SystemException((Throwable)new BLogicMapperException(), ERROR_BEAN_NOTNULL);
        }
        this.getResults(request, response, io, bean);
    }

    protected void getResults(HttpServletRequest request, HttpServletResponse response, BLogicIO io, Object bean) {
        Iterator<BLogicProperty> it = io.getBLogicResults().iterator();
        if (!it.hasNext() && bean != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The bean should be null.");
            }
            log.error((Object)"bean is not null.");
            throw new SystemException((Throwable)new BLogicMapperException(), ERROR_BEAN_NOTNULL);
        }
        while (it.hasNext()) {
            BLogicProperty property = it.next();
            String propertyName = property.getProperty();
            String blogicPropertyName = property.getBLogicProperty();
            if (blogicPropertyName == null) {
                blogicPropertyName = propertyName;
            }
            if (!"".equals(property.getDest()) && property.getDest() != null) {
                Object value = null;
                try {
                    value = BeanUtil.getBeanProperty((Object)bean, (String)blogicPropertyName);
                }
                catch (PropertyAccessException e) {
                    log.error((Object)"getBeanProperty failure.");
                    throw new SystemException((Throwable)new BLogicMapperException(e), ERROR_GETPROPERTY, new String[]{blogicPropertyName});
                }
                Object[] methodParams = new Object[]{value, propertyName, request, response};
                Class[] parameterTypes = new Class[]{Object.class, String.class, HttpServletRequest.class, HttpServletResponse.class};
                try {
                    MethodUtils.invokeMethod((Object)this, (String)("setValueTo" + StringUtil.capitalizeInitial((String)property.getSource())), (Object[])methodParams, (Class[])parameterTypes);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)"no such method.");
                    throw new SystemException((Throwable)new BLogicMapperException(e), ERROR_SETVALUE, new String[]{propertyName});
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"illegal access to the method.");
                    throw new SystemException((Throwable)new BLogicMapperException(e), ERROR_SETVALUE, new String[]{propertyName});
                }
                catch (InvocationTargetException e) {
                    log.error((Object)"exception is thrown out by invokeMethod.");
                    throw new SystemException((Throwable)new BLogicMapperException(e), ERROR_SETVALUE, new String[]{propertyName});
                }
            }
            log.error((Object)"dest is illegal.");
            throw new SystemException((Throwable)new BLogicMapperException(), ERROR_DEST);
        }
    }

    public abstract void setValueToRequest(Object var1, String var2, HttpServletRequest var3, HttpServletResponse var4);

    public abstract void setValueToSession(Object var1, String var2, HttpServletRequest var3, HttpServletResponse var4);

    public abstract Object getValueFromApplication(String var1, HttpServletRequest var2, HttpServletResponse var3);
}

