/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.web.struts.action.ExceptionConfigEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;

public class DefaultExceptionHandler
extends ExceptionHandler {
    private static final Log logger = LogFactory.getLog(DefaultExceptionHandler.class);
    protected static final String LOG_LEVEL_TRACE = "trace";
    protected static final String LOG_LEVEL_DEBUG = "debug";
    protected static final String LOG_LEVEL_INFO = "info";
    protected static final String LOG_LEVEL_WARN = "warn";
    protected static final String LOG_LEVEL_ERROR = "error";
    protected static final String LOG_LEVEL_FATAL = "fatal";
    private static MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.action.LocalStrings");

    public ActionForward execute(Exception ex, ExceptionConfig eConfig, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ActionForward af = super.execute(ex, eConfig, mapping, formInstance, request, response);
        if (eConfig instanceof ExceptionConfigEx) {
            af.setModule(((ExceptionConfigEx)eConfig).getModule());
            this.logException(ex, ((ExceptionConfigEx)eConfig).getLogLevel());
        } else {
            this.logException(ex, null);
        }
        return af;
    }

    protected void logException(Exception e, String logLevel) {
        this.logException(e, logLevel, messages.getMessage("exception.log"));
    }

    protected void logException(String logLevel, String message) {
        this.logException(null, logLevel, message);
    }

    protected void logException(Exception e, String logLevel, String message) {
        if (LOG_LEVEL_TRACE.equalsIgnoreCase(logLevel)) {
            if (this.getLogger().isTraceEnabled()) {
                if (e != null) {
                    this.getLogger().trace((Object)message, (Throwable)e);
                } else {
                    this.getLogger().trace((Object)message);
                }
            }
        } else if (LOG_LEVEL_DEBUG.equalsIgnoreCase(logLevel)) {
            if (this.getLogger().isDebugEnabled()) {
                if (e != null) {
                    this.getLogger().debug((Object)message, (Throwable)e);
                } else {
                    this.getLogger().debug((Object)message);
                }
            }
        } else if (LOG_LEVEL_INFO.equalsIgnoreCase(logLevel)) {
            if (this.getLogger().isInfoEnabled()) {
                if (e != null) {
                    this.getLogger().info((Object)message, (Throwable)e);
                } else {
                    this.getLogger().info((Object)message);
                }
            }
        } else if (LOG_LEVEL_WARN.equalsIgnoreCase(logLevel)) {
            if (this.getLogger().isWarnEnabled()) {
                if (e != null) {
                    this.getLogger().warn((Object)message, (Throwable)e);
                } else {
                    this.getLogger().warn((Object)message);
                }
            }
        } else if (LOG_LEVEL_ERROR.equalsIgnoreCase(logLevel)) {
            if (this.getLogger().isErrorEnabled()) {
                if (e != null) {
                    this.getLogger().error((Object)message, (Throwable)e);
                } else {
                    this.getLogger().error((Object)message);
                }
            }
        } else if (LOG_LEVEL_FATAL.equalsIgnoreCase(logLevel)) {
            if (this.getLogger().isFatalEnabled()) {
                if (e != null) {
                    this.getLogger().fatal((Object)message, (Throwable)e);
                } else {
                    this.getLogger().fatal((Object)message);
                }
            }
        } else if (this.getLogger().isErrorEnabled()) {
            if (e != null) {
                this.getLogger().error((Object)message, (Throwable)e);
            } else {
                this.getLogger().error((Object)message);
            }
        }
    }

    protected void logException(Exception e) {
    }

    protected Log getLogger() {
        return logger;
    }
}

