/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.AbstractControlFilter;
import jp.terasoluna.fw.web.thin.BlockageController;
import jp.terasoluna.fw.web.thin.BlockageException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockageControlFilter
extends AbstractControlFilter<BlockageController> {
    public static final String BLOCKAGE_THRU_KEY = "BLOCKAGE_THRU_KEY";
    public static final String DEFAULT_BLOCKAGE_BEAN_ID = "blockageController";
    private static final String BLOCKAGE_CONTROLLER_ERROR = "errors.blockage.controller";
    private static final Class BLOCKAGE_CONTROLLER_CLASS = BlockageController.class;
    private static Log log = LogFactory.getLog(BlockageControlFilter.class);
    protected static BlockageController controller = null;

    public static BlockageController getBlockageController() {
        return controller;
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        if (controller == null) {
            controller = (BlockageController)this.getController();
        }
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(BLOCKAGE_THRU_KEY) == null) {
            req.setAttribute(BLOCKAGE_THRU_KEY, (Object)"true");
            if (controller.isCheckRequired(req) && controller.isBlockaded(RequestUtil.getPathInfo(req), req)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"isBlockaded() failed.");
                }
                throw new BlockageException();
            }
        }
        chain.doFilter(req, res);
    }

    @Override
    protected Class getControllerClass() {
        return BLOCKAGE_CONTROLLER_CLASS;
    }

    @Override
    protected String getErrorCode() {
        return BLOCKAGE_CONTROLLER_ERROR;
    }

    @Override
    public String getDefaultControllerBeanId() {
        return DEFAULT_BLOCKAGE_BEAN_ID;
    }
}

