/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.service.thin;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicIOField;
import jp.terasoluna.fw.service.thin.BLogicIOFieldBean;
import jp.terasoluna.fw.service.thin.BLogicParamField;
import jp.terasoluna.fw.service.thin.BLogicProperty;
import jp.terasoluna.fw.service.thin.BLogicResultField;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BLogicIOUtil {
    private static final int BLOGIC_IO_PARAMS = 0;
    private static final int BLOGIC_IO_RESULT = 1;
    protected static ConcurrentMap<Class<?>, BLogicIO> blogicParamMap = new ConcurrentHashMap();
    protected static ConcurrentMap<Class<?>, BLogicIO> blogicResultMap = new ConcurrentHashMap();
    protected static ConcurrentMap<Class<?>, Class<?>> inputClassMap = new ConcurrentHashMap();

    private BLogicIOUtil() {
    }

    public static BLogicIO createBLogicIOForBLogicParams(Class<?> inputBeanClass) {
        BLogicIO io = null;
        if (inputBeanClass != null) {
            io = BLogicIOUtil.getBlogicParamCache(inputBeanClass);
        }
        if (io == null) {
            io = new BLogicIO();
            if (inputBeanClass != null) {
                io.setInputBeanName(inputBeanClass.getName());
                Collection<BLogicProperty> logicPropertyCollectionForBLogicParams = BLogicIOUtil.createBLogicPropertyCollection(inputBeanClass, 0);
                for (BLogicProperty logicProperty : logicPropertyCollectionForBLogicParams) {
                    io.setBLogicParam(logicProperty);
                }
                BLogicIOUtil.setBlogicParamCache(inputBeanClass, io);
            }
        }
        return io;
    }

    public static BLogicIO createBLogicIOForBLogicResult(Class<?> resultBeanClass) {
        BLogicIO logicIO = new BLogicIO();
        if (resultBeanClass != null) {
            Collection<BLogicProperty> logicPropertyCollectionForBLogicResult = BLogicIOUtil.createBLogicPropertyCollection(resultBeanClass, 1);
            for (BLogicProperty logicProperty : logicPropertyCollectionForBLogicResult) {
                logicIO.setBLogicResult(logicProperty);
            }
        }
        return logicIO;
    }

    private static Collection<BLogicProperty> createBLogicPropertyCollection(Class<?> beanClass, int target) {
        return BLogicIOUtil.createBLogicPropertyMap(beanClass, target).values();
    }

    private static Map<String, BLogicProperty> createBLogicPropertyMap(Class<?> beanClass, int target) {
        LinkedHashMap<String, BLogicProperty> logicPropertyMap = new LinkedHashMap<String, BLogicProperty>();
        Class<?> superClass = beanClass.getSuperclass();
        if (superClass != null) {
            logicPropertyMap.putAll(BLogicIOUtil.createBLogicPropertyMap(superClass, target));
        }
        for (Field field : beanClass.getDeclaredFields()) {
            BLogicIOFieldBean blogicIOFieldBean = null;
            if (target == 0 && field.isAnnotationPresent(BLogicParamField.class)) {
                blogicIOFieldBean = new BLogicIOFieldBean(field.getAnnotation(BLogicParamField.class));
            } else if (target == 1 && field.isAnnotationPresent(BLogicResultField.class)) {
                blogicIOFieldBean = new BLogicIOFieldBean(field.getAnnotation(BLogicResultField.class));
            } else if (field.isAnnotationPresent(BLogicIOField.class)) {
                blogicIOFieldBean = new BLogicIOFieldBean(field.getAnnotation(BLogicIOField.class));
            }
            if (blogicIOFieldBean == null) continue;
            BLogicProperty logicProperty = BLogicIOUtil.createBLogicProperty(field, blogicIOFieldBean);
            if (target == 0) {
                logicProperty.setSource(blogicIOFieldBean.getTarget().getValue());
            } else if (target == 1) {
                logicProperty.setDest(blogicIOFieldBean.getTarget().getValue());
            }
            logicPropertyMap.put(logicProperty.getBLogicProperty(), logicProperty);
        }
        return logicPropertyMap;
    }

    private static BLogicProperty createBLogicProperty(Field field, BLogicIOFieldBean blogicIOFieldBean) {
        BLogicProperty logicProperty = new BLogicProperty();
        logicProperty.setBLogicProperty(field.getName());
        String property = blogicIOFieldBean.getProperty();
        if (StringUtils.isEmpty((String)property)) {
            property = field.getName();
        }
        logicProperty.setProperty(property);
        return logicProperty;
    }

    public static BLogicIO getBlogicParamCache(Class<?> targetClass) {
        return (BLogicIO)blogicParamMap.get(targetClass);
    }

    public static void setBlogicParamCache(Class<?> targetClass, BLogicIO blogicIo) {
        blogicParamMap.put(targetClass, blogicIo);
    }

    public static BLogicIO getBlogicResultCache(Class<?> targetClass) {
        return (BLogicIO)blogicResultMap.get(targetClass);
    }

    public static void setBlogicResultCache(Class<?> targetClass, BLogicIO blogicIo) {
        blogicResultMap.put(targetClass, blogicIo);
    }

    public static Class<?> getInputClassCache(Class<?> targetClass) {
        return (Class)inputClassMap.get(targetClass);
    }

    public static void setInputClassCache(Class<?> targetClass, Class<?> cacheClass) {
        inputClassMap.put(targetClass, cacheClass);
    }

    public static ConcurrentMap<Class<?>, BLogicIO> getBlogicParamMap() {
        return blogicParamMap;
    }

    public static ConcurrentMap<Class<?>, BLogicIO> getBlogicResultMap() {
        return blogicResultMap;
    }

    public static ConcurrentMap<Class<?>, Class<?>> getInputClassMap() {
        return inputClassMap;
    }
}

