/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action.resolver;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.terasoluna.fw.web.struts.action.resolver.ActionResolver;
import jp.terasoluna.fw.web.struts.action.resolver.ConfigurationReflector;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractActionResolver
implements ActionResolver {
    protected String actionName = null;
    protected String[] pathPatterns = null;
    protected ConcurrentHashMap<String, Pattern> regexMap = new ConcurrentHashMap();
    protected Map<?, ?> configReflectorMap = null;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private int order = Integer.MAX_VALUE;

    public boolean supports(String beanName, ActionMapping mapping, ActionServlet servlet, WebApplicationContext wac) {
        if (this.pathPatterns == null || this.pathPatterns.length == 0 || this.actionName == null || this.actionName.length() == 0 || beanName == null) {
            return false;
        }
        boolean pathMatching = false;
        for (String pathPattern : this.pathPatterns) {
            if (pathPattern == null || pathPattern.length() == 0) continue;
            Pattern pt = this.regexMap.get(pathPattern);
            if (pt == null) {
                pt = Pattern.compile(pathPattern);
                this.regexMap.put(pathPattern, pt);
            }
            Matcher m = null;
            if (pt != null) {
                m = pt.matcher(beanName);
            }
            if (m == null || !m.matches()) continue;
            pathMatching = true;
            break;
        }
        return pathMatching;
    }

    public Action getDelegateAction(String beanName, ActionMapping mapping, ActionServlet servlet, WebApplicationContext wac) {
        if (!this.isBeanExist(beanName, mapping, servlet, wac)) {
            return null;
        }
        Object key = this.getActionCacheKey(beanName, mapping, servlet, wac);
        Action resultAction = this.getActionCache(key);
        if (resultAction == null) {
            if (!(key instanceof Action)) {
                resultAction = (Action)wac.getBean(this.actionName, Action.class);
            }
            resultAction = this.extensionProcess(key, resultAction, beanName, mapping, servlet, wac);
            this.callConfigurationReflector(key, resultAction, beanName, mapping, servlet, wac);
            if (resultAction != null && this.isCacheEnabled(key, resultAction, beanName, mapping, servlet, wac)) {
                this.putActionCache(key, resultAction);
            }
        }
        return resultAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callConfigurationReflector(Object key, Action action, String beanName, ActionMapping mapping, ActionServlet servlet, WebApplicationContext wac) {
        block10: {
            try {
                this.lock.readLock().lock();
                if (this.configReflectorMap != null) break block10;
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    this.configReflectorMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)wac, ConfigurationReflector.class);
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        try {
            this.lock.readLock().lock();
            Set<Map.Entry<?, ?>> ctEs = this.configReflectorMap.entrySet();
            for (Map.Entry<?, ?> ctObj : ctEs) {
                ConfigurationReflector cr;
                Map.Entry<?, ?> ctMe;
                if (!(ctObj instanceof Map.Entry) || !((ctMe = ctObj).getValue() instanceof ConfigurationReflector) || !(cr = (ConfigurationReflector)ctMe.getValue()).supports(action, beanName, mapping, servlet, (ApplicationContext)wac)) continue;
                action = cr.setConfiguration(action, beanName, mapping, servlet, (ApplicationContext)wac);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected abstract boolean isCacheEnabled(Object var1, Action var2, String var3, ActionMapping var4, ActionServlet var5, WebApplicationContext var6);

    protected abstract boolean isBeanExist(String var1, ActionMapping var2, ActionServlet var3, WebApplicationContext var4);

    protected abstract Object getActionCacheKey(String var1, ActionMapping var2, ActionServlet var3, WebApplicationContext var4);

    protected abstract Action getActionCache(Object var1);

    protected abstract void putActionCache(Object var1, Action var2);

    protected abstract Action extensionProcess(Object var1, Action var2, String var3, ActionMapping var4, ActionServlet var5, WebApplicationContext var6);

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setPathPattern(String pathPattern) {
        this.pathPatterns = new String[]{pathPattern};
    }

    public void setPathPatterns(String[] pathPatterns) {
        this.pathPatterns = pathPatterns;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

