/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action.resolver;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.util.GenericBeanFactoryAccessorEx;
import jp.terasoluna.fw.web.struts.action.annotation.ActionComponent;
import jp.terasoluna.fw.web.struts.action.annotation.BLogicComponent;
import jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver;
import jp.terasoluna.fw.web.struts.actions.AnnotationBLogicAction;
import jp.terasoluna.fw.web.struts.actions.BLogicAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BLogicActionResolver
extends AbstractActionResolver
implements InitializingBean,
ApplicationContextAware {
    private static Log log = LogFactory.getLog(BLogicActionResolver.class);
    protected ConcurrentHashMap<BLogic<?>, Action> blogicActionMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<Object, Action> otherActionMap = new ConcurrentHashMap();
    protected Map<String, String> actionPathMap = new ConcurrentHashMap<String, String>();
    protected WebApplicationContext webApplicationContext = null;

    public void afterPropertiesSet() throws Exception {
        ConcurrentHashMap<String, Object> componentMap = new ConcurrentHashMap<String, Object>();
        if (this.webApplicationContext != null) {
            this.addTargetComponent(componentMap, this.webApplicationContext);
            Set alsEs = componentMap.entrySet();
            for (Map.Entry alsObj : alsEs) {
                Map.Entry elsMe = alsObj;
                Object elsObj = elsMe.getValue();
                String[] pathAry = this.getActionPathArray(elsObj);
                if (pathAry == null) continue;
                for (String path : pathAry) {
                    if (path == null) continue;
                    if (!this.actionPathMap.containsKey(path)) {
                        Object keyObj = elsMe.getKey();
                        if (!(keyObj instanceof String)) continue;
                        this.actionPathMap.put(path, (String)keyObj);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("The action path ");
                    sb.append("duplication.");
                    sb.append(" path:[");
                    sb.append(path);
                    sb.append("]");
                    sb.append(" bean1:[");
                    sb.append(this.actionPathMap.get(path));
                    sb.append("]");
                    sb.append(" bean2:[");
                    sb.append(elsMe.getKey());
                    sb.append("]");
                    log.warn((Object)sb.toString());
                }
            }
        }
    }

    protected void addTargetComponent(Map<String, Object> cpMap, WebApplicationContext wac) {
        GenericBeanFactoryAccessorEx gbfa = new GenericBeanFactoryAccessorEx((ListableBeanFactory)wac);
        Map<String, Object> bcMap = gbfa.getBeansWithAnnotation(BLogicComponent.class);
        Map<String, Object> acMap = gbfa.getBeansWithAnnotation(ActionComponent.class);
        cpMap.putAll(bcMap);
        cpMap.putAll(acMap);
    }

    protected String[] getActionPathArray(Object obj) {
        String[] pathAry = null;
        Class<? extends Object> targetClass = this.getTargetClass(obj);
        if (obj instanceof BLogic) {
            pathAry = this.getBLogicComponentPath(targetClass);
        } else if (obj instanceof Action) {
            pathAry = this.getActionComponentPath(targetClass);
        }
        return pathAry;
    }

    protected String[] getBLogicComponentPath(Class<? extends Object> targetClass) {
        BLogicComponent blc = targetClass.getAnnotation(BLogicComponent.class);
        String[] pathArray = null;
        if (blc != null) {
            pathArray = blc.path();
        }
        if (pathArray != null && pathArray.length > 0 && pathArray[0] != null) {
            return new String[]{pathArray[0]};
        }
        return null;
    }

    protected String[] getActionComponentPath(Class<? extends Object> targetClass) {
        return null;
    }

    @Override
    protected boolean isBeanExist(String beanName, ActionMapping mapping, ActionServlet servlet, WebApplicationContext wac) {
        if (wac == null) {
            return false;
        }
        if (!wac.containsBean(this.actionName)) {
            if (log.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Action bean not found.");
                sb.append(" actionName:[");
                sb.append(this.actionName);
                sb.append("]");
                log.warn((Object)sb.toString());
            }
            return false;
        }
        return true;
    }

    @Override
    protected Object getActionCacheKey(String beanName, ActionMapping mapping, ActionServlet servlet, WebApplicationContext wac) {
        Object key = null;
        if (!wac.containsBean(beanName)) {
            String convertBeanName = this.getAnnotationBeanEntry(beanName, wac);
            if (convertBeanName != null) {
                key = wac.getBean(convertBeanName);
            }
            if (key == null) {
                if (log.isWarnEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("BLogic or Action not found.");
                    sb.append(" beanName:[");
                    sb.append(beanName);
                    sb.append("]");
                    log.warn((Object)sb.toString());
                }
                return null;
            }
        } else {
            key = wac.getBean(beanName);
        }
        return key;
    }

    protected String getAnnotationBeanEntry(String actionPath, WebApplicationContext wac) {
        return this.actionPathMap.get(actionPath);
    }

    protected Class<? extends Object> getTargetClass(Object targetObject) {
        Class<?> targetClass = null;
        if (targetObject != null) {
            targetClass = AopUtils.isAopProxy((Object)targetObject) ? AopUtils.getTargetClass((Object)targetObject) : targetObject.getClass();
        }
        return targetClass;
    }

    @Override
    protected Action getActionCache(Object cacheKey) {
        if (cacheKey instanceof BLogic) {
            return this.blogicActionMap.get((BLogic)cacheKey);
        }
        if (cacheKey != null) {
            return this.otherActionMap.get(cacheKey);
        }
        return null;
    }

    @Override
    protected void putActionCache(Object cacheKey, Action action) {
        if (cacheKey instanceof BLogic) {
            this.blogicActionMap.put((BLogic)cacheKey, action);
        } else {
            this.otherActionMap.put(cacheKey, action);
        }
    }

    @Override
    protected Action extensionProcess(Object key, Action action, String beanName, ActionMapping mapping, ActionServlet servlet, WebApplicationContext wac) {
        Action resultAction = action;
        if (action instanceof BLogicAction || action instanceof AnnotationBLogicAction || key instanceof Action) {
            if (key instanceof BLogic && action != null) {
                BLogic blogic = (BLogic)key;
                if (action instanceof BLogicAction) {
                    BLogicAction blogicAction = (BLogicAction)action;
                    blogicAction.setBusinessLogic(blogic);
                } else if (action instanceof AnnotationBLogicAction) {
                    AnnotationBLogicAction blogicAction = (AnnotationBLogicAction)action;
                    blogicAction.setBusinessLogic(blogic);
                }
            } else if (key instanceof Action && action == null) {
                resultAction = (Action)key;
            } else {
                if (log.isWarnEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("The business logic or ");
                    sb.append("the action is not found. ");
                    sb.append(" beanName:[");
                    sb.append(beanName);
                    sb.append("]");
                    sb.append(" actionName:[");
                    sb.append(this.actionName);
                    sb.append("]");
                    log.warn((Object)sb.toString());
                }
                return null;
            }
        }
        return resultAction;
    }

    @Override
    protected boolean isCacheEnabled(Object key, Action resultAction, String beanName, ActionMapping mapping, ActionServlet servlet, WebApplicationContext wac) {
        if (wac.containsBean(beanName)) {
            return wac.isSingleton(beanName);
        }
        String annotationPath = this.getAnnotationBeanEntry(beanName, wac);
        if (annotationPath != null && wac.containsBean(annotationPath)) {
            return wac.isSingleton(annotationPath);
        }
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof WebApplicationContext) {
            this.webApplicationContext = (WebApplicationContext)applicationContext;
        }
    }
}

