/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;

public class DataPageText
extends DataPage {
    public DataPageText(DataHandler dataHandler, byte[] byArray) {
        super(dataHandler, byArray);
    }

    public void setInt(int n, int n2) {
        int n3 = 7;
        while (n3 >= 0) {
            this.data[n3] = (byte)Character.forDigit(n2 & 0xF, 16);
            --n3;
            n2 >>>= 4;
        }
    }

    public void updateChecksum() {
        int n = this.handler.getChecksum(this.data, 0, this.pos - 2);
        this.data[this.pos - 2] = (byte)(97 + ((n ^ n >> 4) & 0xF));
    }

    public void check(int n) throws SQLException {
        int n2 = this.handler.getChecksum(this.data, 0, n - 2);
        if (this.data[n - 2] == (byte)(97 + ((n2 ^ n2 >> 4) & 0xF))) {
            return;
        }
        this.handler.handleInvalidChecksum();
    }

    public int getFillerLength() {
        return 2;
    }

    public void writeInt(int n) {
        if (SysProperties.CHECK) {
            this.checkCapacity(8);
        }
        int n2 = 7;
        while (n2 >= 0) {
            this.data[this.pos + n2] = (byte)Character.forDigit(n & 0xF, 16);
            --n2;
            n >>>= 4;
        }
        this.pos += 8;
    }

    public int readInt() {
        int n = 0;
        if (this.data[this.pos] == 32) {
            this.pos += 8;
            return 0;
        }
        for (int i = 8; i > 0; --i) {
            byte by;
            n <<= 4;
            n |= (by = this.data[this.pos++]) >= 97 ? by - 97 + 10 : by - 48;
        }
        return n;
    }

    public int getIntLen() {
        return 8;
    }

    public int getLongLen(long l) {
        return 16;
    }

    public int getStringLen(String string) {
        int n = 2 + string.length() + 1;
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++n;
                    continue block3;
                }
                default: {
                    int n2 = c & 0xFFFF;
                    if (n2 >= 32 && n2 <= 255) continue block3;
                    n += 5;
                }
            }
        }
        return n;
    }

    public String readString() {
        char c;
        StringBuffer stringBuffer = new StringBuffer(32);
        if (SysProperties.CHECK && this.data[this.pos] != 34) {
            throw Message.getInternalError("\" expected");
        }
        ++this.pos;
        block10: while ((c = (char)(this.data[this.pos++] & 0xFF)) != '\"') {
            if (c == '\\') {
                c = (char)this.data[this.pos++];
                switch (c) {
                    case 't': {
                        stringBuffer.append('\t');
                        continue block10;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        continue block10;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        continue block10;
                    }
                    case 'b': {
                        stringBuffer.append('\b');
                        continue block10;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        continue block10;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        continue block10;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        continue block10;
                    }
                    case 'u': {
                        c = '\u0000';
                        for (int i = 3; i >= 0; --i) {
                            byte by;
                            c = (char)(c << 4);
                            c = (char)(c | ((by = this.data[this.pos++]) >= 97 ? by - 97 + 10 : by - 48));
                        }
                        stringBuffer.append(c);
                        continue block10;
                    }
                }
                throw Message.getInternalError("unexpected " + c);
            }
            stringBuffer.append(c);
        }
        ++this.pos;
        return stringBuffer.toString();
    }

    public void writeString(String string) {
        this.checkCapacity(string.length() * 6 + 2);
        this.data[this.pos++] = 34;
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 116;
                    continue block9;
                }
                case '\r': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 114;
                    continue block9;
                }
                case '\n': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 110;
                    continue block9;
                }
                case '\b': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 98;
                    continue block9;
                }
                case '\f': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 102;
                    continue block9;
                }
                case '\"': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 34;
                    continue block9;
                }
                case '\\': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 92;
                    continue block9;
                }
                default: {
                    int n = c & 0xFFFF;
                    if (n >= 32 && n <= 255) {
                        this.data[this.pos++] = (byte)n;
                        continue block9;
                    }
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 117;
                    int n2 = 3;
                    while (n2 >= 0) {
                        this.data[this.pos + n2] = (byte)Character.forDigit(n & 0xF, 16);
                        --n2;
                        n >>>= 4;
                    }
                    this.pos += 4;
                }
            }
        }
        this.data[this.pos++] = 34;
        this.data[this.pos++] = 32;
    }

    public void fill(int n) {
        if (this.pos > n) {
            this.pos = n;
        }
        this.checkCapacity(n - this.pos);
        while (this.pos < n) {
            this.data[this.pos++] = 32;
        }
        this.data[this.pos - 1] = 10;
    }
}

