/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web;


import java.io.Serializable;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>OI[U񒊏ۃNX</p>
 *
 * <p>
 *  OĨ[U\IuWFNg(<code>UVO</code>)ۃNXłB
 *  pNX̐́A<code>ApplicationResources.properties</code>
 *  <code>user.value.object</code>L[ƂČpNXݒ肵A
 *  <code>createUserValueObject()</code>sƂɂ萶B
 * </p>
 * <h5><code>ApplicationResources.properties</code>̐ݒ</h5>
 * <ul>
 *   <li>user.value.object=jp.terasoluna.sample.xxxx.SampleUVO</li>
 * </ul>
 * <h5> <code>SampleUVO</code> ̎</h5>
 * <code><pre>
 * public class SampleUVO extends UserValueObject {
 *   // KvɉĎ
 *   public String[] getFieldNames() {
 *       return new String[]{"companyId", "userId", "address", ...};
 *   }
 *
 *   // ID
 *   String companyId = null;
 *   // [UID
 *   String userId = null;
 *   // Z
 *   String address = null;
 *   EEE
 *   // tB[hgetterAsetter
 *   EEE
 * }
 * </pre></code>
 * <h5>OIƖWbN̎</h5>
 * <code><pre>
 * public ResultBean execute(LogonBean params) {
 *    EEE
 *    // UVO̐
 *    SampleUVO uvo = (SampleUVO) UserValueObject.createUserValueObject();
 *    EEE
 *    // UVOɃ[Uݒ
 *    uvo.setCompanyId(companyId);
 *    uvo.setUserId(userId);
 *    uvo.setAddress(address);
 *    EEE
 * }
 * </pre></code>
 *
 */
public abstract class UserValueObject implements Serializable {

    /**
     * ONX
     */
    private static Log log
          = LogFactory.getLog(UserValueObject.class);

    /**
     * <code>ApplicationResources</code> t@C
     * <code>UserValueObject</code> pNXw肷L[B
     */
    public static final String USER_VALUE_OBJECT_PROP_KEY = "user.value.object";

    /**
     * <code>UserValueObject</code> pNX̃CX^X쐬s
     * G[R[hB
     */
    private static final String UVO_CLASS_ERROR = "errors.uvo.class";

    /**
     * <code>UserValueObject</code> pNX
     * HTTPZbV擾ۂɗpL[B
     */
    public static final String USER_VALUE_OBJECT_KEY = "USER_VALUE_OBJECT";

    /**
     * [UIuWFNg𐶐B
     *
     * @return [UIuWFNg
     */
    public static UserValueObject createUserValueObject() {

        UserValueObject userValueObject = null;
        String className =
            PropertyUtil.getProperty(USER_VALUE_OBJECT_PROP_KEY);
        if (className != null) {
            try {
                userValueObject = (UserValueObject) ClassUtil.create(className);
            } catch (ClassLoadException e) {
                log.error("illegal uvo class:" + className, e);
                throw new SystemException(e, UVO_CLASS_ERROR, className);
            } catch (ClassCastException e) {
                log.error("illegal uvo class:" + className, e);
                throw new SystemException(e, UVO_CLASS_ERROR, className);
            }
        } else {
            log.error("specify " + USER_VALUE_OBJECT_PROP_KEY + ".");
            return null;
        }

        return userValueObject;
    }

}
