/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * <p> 
 *  {NX́ABLogic̋NsNXłB<br>
 *  Action璼BLogic̋NsBEJBɂ͑ΉĂȂB
 * </p>
 * <p>
 *  BLogicNXs邽߂ɂ́A
 *  Bean`t@CBLogicActionBean`ŁA
 *  businessLogicvpeBɖړI̋ƖWbNNX
 *  L̗̂悤ɁA&lt;property&gt;vfŎw肷B
 *  킹struts-config.xml̐ݒȉɎB
 * </p>
 * <p>
 * <strong>Bean`t@C̐ݒ</strong>
 * <code><pre>
 * &lt;bean name="/logon/logonAction" scope="singleton"
 *   <strong>class="jp.terasoluna.fw.web.struts.actions.BLogicAction"</strong>&gt
 *   <strong>&lt;property name="businessLogic"&gt;
 *     &lt;ref bean="LogonBLogic"&gt;&lt;/ref&gt;
 *   &lt;/property&gt;</strong>
 * &lt;/bean&gt
 * &lt;bean id="LogonBLogic" scope="prototype"
 *   <strong>class="jp.terasoluna.sample1.logon.blogic.LogonBLogic"</strong>&gt
 * &lt;/bean&gt
 * </pre></code>
 * </p>
 * <p>
 * <strong>struts-config.xmlBLogicActionݒ</strong>
 * <code><pre>
 *    &lt;action path="/logon/logonAction"
 *       name="_logonForm"
 *       validate="true"
 *       scope="session"
 *       input="/logon/logon.jsp"&gt;
 *    &lt;forward name="success" path="/logon/selectGroupSCR.do"/&gt;
 *    &lt;forward name="failure" path="/logon/logonSCR.do"/&gt;
 *  &lt;/action&gt;
 * </pre></code>
 * </p>
 * <p>
 *  ܂AtH[AZbVȂǂWebwƁA
 *  rWlXWbN̓o͒lƂ̃}bsO
 *  blogic-io.xmlɑ΂āAANVpXƂɋLqKvB
 *  Lq@AڍאɂẮABLogicIOPlugInQƂ̂ƁB
 * </p>
 *
 * @see jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn
 * @see jp.terasoluna.fw.service.thin.BLogicResult
 *
 * @param <P> rWlXWbNւ̓͒lƂȂJavaBeanw肷
 *
 */
public class BLogicAction<P> extends AbstractBLogicAction<P> {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(BLogicAction.class);

    /**
     * ݒ肳rWlXWbNB
     */
    private BLogic<P> businessLogic = null;

    /**
     * rWlXWbNݒ肷B
     *
     * @param businessLogic businessLogic ݒB
     */
    public void setBusinessLogic(BLogic<P> businessLogic) {
        this.businessLogic = businessLogic;
    }
    
    /**
     * rWlXWbN擾B
     *
     * @return rWlXWbN
     */
    public BLogic<P> getBusinessLogic() {
        return this.businessLogic;
    }
    
    /**
     * BLogicNB
     * <p>
     * ƂāANXϐbusinessLogicɂBLogicC^tF[X
     * NXݒ肳ĂKvB
     * BLogicnull̂Ƃ́AnullԋpB
     * </p>
     *
     * @param param BLogic͏
     * @return BLogico͏
     * @throws Exception \ȂO
     */
    @Override
    public BLogicResult doExecuteBLogic(P param) throws Exception {

        if (log.isDebugEnabled()) {
            log.debug("*** doExecuteBLogic() called. ***");
        }

        if (businessLogic == null) {
            return null;
        }

        if (log.isDebugEnabled()) {
            // DIꂽrWlXWbÑNXo
            log.debug("*** Starting blogic["
                    + businessLogic.getClass().getName() + "]. ***");
        }

        BLogicResult result = businessLogic.execute(param);

        if (log.isDebugEnabled()) {
            log.debug("*** Finished blogic["
                    + businessLogic.getClass().getName() + "]. ***");
        }

        return result;
    }
}
