/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.util.PropertyUtil;

/**
 * grWlXWbNo͏񔽉fNXB
 * <p>
 * rWlXWbN͒l̃v[e[Vw̎擾AуrWlXWbNo͒l̃v[e[Vwւ̔fSB
 * </p>
 * <p>
 * o̓IuWFNg̃vpeB̒lnull̏ꍇɁA ANVtH[AyуNGXgɒl𔽉fȂꍇ́A system.propertiesɈȉ̐ݒǉ܂B ftHgłnullłANVtH[AyуNGXg
 * l𔽉f܂B
 * </p>
 * <fieldset style="border:1pt solid black;padding:10px;width:80%;"> <legend>system.propertiesݒ</legend> <code>
 * blogicMapperEx.nullIsNotSet=true
 * </code> </fieldset>
 * @see jp.terasoluna.fw.service.thin.BLogicMapper
 */
public class BLogicMapperEx extends BLogicMapper {

    /** null̐ݒ}~ݒ̃vpeBL[ */
    protected static final String NULL_IS_NOT_SET = "blogicMapperEx.nullIsNotSet";

    /** null̐ݒ}~iftHg:falsej */
    protected boolean nullIsNotSet = false;

    /**
     * BLogicMapperEx̃CX^X\z܂B
     */
    public BLogicMapperEx() {
        String nullIsNotSetStr = PropertyUtil.getProperty(NULL_IS_NOT_SET,
                Boolean.FALSE.toString());
        this.nullIsNotSet = Boolean.valueOf(nullIsNotSetStr).booleanValue();
    }

    /**
     * BLogicMapperEx̃CX^X\z܂B
     * @param resources \[X̃pX
     */
    public BLogicMapperEx(String resources) {
        /*
         * \[Xw肳ĂȂĂACX^X̐܂B \[XɎw肷RXgN^ĂȂƁABLogicIOPlugIn#initMapper()
         * CX^X̐Ɏs邽߁A\[XɎRXgN^񋟂Ă܂B
         */
        String nullIsNotSetStr = PropertyUtil.getProperty(NULL_IS_NOT_SET,
                Boolean.FALSE.toString());
        this.nullIsNotSet = Boolean.valueOf(nullIsNotSetStr).booleanValue();
    }

    /**
     * HttpServletRequestAw肳ꂽvpeBl擾܂B<br> {@link HttpServletRequest#getAttribute(String)}
     * Œl擾łȂꍇANGXgp[^l̎擾݂܂B
     * @return {@link HttpServletRequest#getAttribute(String)}Ŏ擾l <br>
     *         擾łȂꍇA {@link HttpServletRequest#getParameterValues(String)} sAȉ̒lԂ܂B
     *         <ul>
     *         <li>NGXgp[^擾łȂꍇnull</li>
     *         <li>p[^lP̏ꍇAp[^l\</li>
     *         <li>p[^l̏ꍇAp[^lێ镶̔z</li>
     *         </ul>
     * @see jp.terasoluna.fw.service.thin.BLogicMapper#getValueFromRequest(java.lang.String,
     *      javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    public Object getValueFromRequest(String propName,
            HttpServletRequest request, HttpServletResponse response) {
        Object value = super.getValueFromRequest(propName, request, response);
        if (value != null) {
            return value;
        }
        String[] parameterValues = request.getParameterValues(propName);
        if (parameterValues == null) {
            return null;
        }
        if (parameterValues.length == 1) {
            return parameterValues[0];
        } else {
            return parameterValues;
        }
    }

    /**
     * ANVtH[̎w肳ꂽvpeBɒli[܂B
     * <p>
     * VXevpeBblogicMapperEx.nullIsNotSet̒ltruȅꍇɂ́A lnull̏ꍇ͉܂BiftHglfalsej
     * </p>
     */
    @Override
    public void setValueToForm(Object value, String propName,
            HttpServletRequest request, HttpServletResponse response)
                                                                     throws PropertyAccessException {
        if (!this.nullIsNotSet || value != null) {
            super.setValueToForm(value, propName, request, response);
        }
    }

    /**
     * NGXg̎w肳ꂽvpeBɒli[܂B
     * <p>
     * VXevpeBblogicMapperEx.nullIsNotSet̒ltruȅꍇɂ́A lnull̏ꍇ͉܂BiftHglfalsej
     * </p>
     */
    @Override
    public void setValueToRequest(Object value, String propName,
            HttpServletRequest request, HttpServletResponse response) {
        if (!this.nullIsNotSet || value != null) {
            super.setValueToRequest(value, propName, request, response);
        }
    }
}
