/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * ʉʃt[Ƌʉʃt[Iɗp{@link FlowCallbackInfo}̃}bsOێNXB
 */
public class FlowCallbackInfoMapping implements Serializable {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1396363905174522409L;

    /**
     * ʉʃt[ƁAʉʃt[Iɗp{@link FlowCallbackInfo}̈ꗗێMap
     */
    private Map<String, FlowCallbackInfo> callBackInfoMap = new ConcurrentHashMap<String, FlowCallbackInfo>();

    /**
     * ʉʃt[L[ɂāAʉʃt[Iɗp{@link FlowCallbackInfo}o^B
     * @param flowName
     *            ʉʃt[ (nullȊO)
     * @param callBackInfo
     *            ʉʃt[Iɗp{@link FlowCallbackInfo} (nullȊO)
     */
    public void registerFlowCallbackInfo(String flowName,
            FlowCallbackInfo callBackInfo) {
        callBackInfoMap.put(flowName, callBackInfo);
    }

    /**
     * Ŏw肳ꂽʉʃt[̏Iɗp{@link FlowCallbackInfo}擾B
     * @param flowName
     *            ʉʃt[ (nullȊO)
     * @return }bsOĂ{@link FlowCallbackInfo}
     */
    public FlowCallbackInfo findFlowCallbackInfo(String flowName) {
        return callBackInfoMap.get(flowName);
    }
}
