/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.thin;

import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>w肳ꂽK\p^[ɊÂāANCAg̃NGXgp[^gB<p>
 * 
 * <p>
 * NCAgM͒lIɃg~OB
 * rWlXWbNɂ́Ag~OꂽԂœ͒l󂯓nB
 * ̂߁Aʂ̃rWlXWbNŉ߂ăg~OsKv͂ȂB
 * </p>
 * 
 * NGXgp[^g@\
 * <p>
 * NCAgM͒lIɃg~OT[ubgtB^񋟂B
 * </p>
 * gp@
 * <p>
 * NCAg̓͒lIɃg~OꍇA
 * WebAvP[Vݒt@Ciweb.xmljŐp̃T[ubgtB^iTrimRequestParameterFilterjo^B
 * ̍ہAp[^ƂāANGXgp[^̃gɎgp鐳K\p^[itrimPatternjw肷B<br>
 * gp^[̒ĺAȒl̏ꍇɂwarnx̃Oo͂AgtB^͓삵ȂݒƂȂB<br>
 * ȉ́ANGXgp[^ȎSpEpXy[XIɏꍇtrimPattern̎włB<br>
 * <br>
 * WebAvP[Vݒt@Ciweb.xmlj<br>
 * <code>
 * &lt;filter&gt;<br>
 * &nbsp;&lt;filter-name&gt;trimRequestParameterFilter&lt;/filter-name&gt;<br>
 * &nbsp;&lt;filter-class&gt;jp.terasoluna.fw.ex.web.thin.TrimRequestParameterFilter&lt;/filter-class&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &nbsp;&nbsp;&lt;param-name&gt;trimPattern&lt;/param-name&gt;<br>
 * &nbsp;&nbsp;&lt;param-value&gt;^[@\s]*|[@\s]*$&lt;/param-value&gt;<br>
 * &nbsp;&lt;/init-param&gt;<br>
 * &lt;/filter&gt;<br>
 * <br>
 * &lt;filter-mapping&gt;<br>
 * &nbsp;&lt;filter-name&gt; trimRequestParameterFilter &lt;/filter-name&gt;<br>
 * &nbsp;&lt;url-pattern&gt;/*&lt;/url-pattern&gt;<br>
 * &lt;/filter-mapping&gt;<br>
 * </code>
 * 
 * @see javax.servlet.Filter
 */
public class TrimRequestParameterFilter implements Filter {

    /**
     * ONXB
     */
    private static Log log = LogFactory
            .getLog(TrimRequestParameterFilter.class);

    /**
     * NGXgp[^̃gɎgp鐳K\p^[
     */
    private String trimPattern;
    
    /**
     * ̃tB^[𖳌tOB
     */
    private boolean ignoreFlag = false;

    /**
     * NGXgp[^̃gɎgp鐳K\p^[w肵āÃT[ubgtB^B
     * 
     * @param config
     *          tB^RtBO
     * 
     * @throws ServletException
     *                O
     * 
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    public void init(FilterConfig config) throws ServletException {
        String trimPattern = config.getInitParameter("trimPattern");

        if (trimPattern == null) {
            log.warn("trimPattern cannot be null.");
            this.ignoreFlag = true;
        } else {
            try{
                Pattern.compile(trimPattern);
                this.trimPattern = trimPattern;
            } catch (PatternSyntaxException e) {
                log.warn("The format of trimPattern is not correct.");
                this.ignoreFlag = true;
            }
        }
    }

    /**
     * ̃T[ubgtB^sB
     * 
     * contentType<code>multipart/form-data</code>łȂꍇA
     * HttpServletRequestParameterTrimmedHttpServletRequestɒuB
     * 
     * @param request
     *            NGXg
     * @param response
     *            X|X
     * @param chain
     *            tB^[`F[
     * 
     * @throws IOException
     *                O
     * @throws ServletException
     *                O
     * 
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest,
     *      javax.servlet.ServletResponse, javax.servlet.FilterChain)
     */
    public void doFilter(ServletRequest request,
            ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        String contentType = request.getContentType();
        if (!ignoreFlag) {
            if (contentType != null
                    && contentType.startsWith("multipart/form-data")) {
                chain.doFilter(request, response);
            } else {
                if (request instanceof HttpServletRequest) {
                    HttpServletRequest httpServletRequest = 
                        (HttpServletRequest) request;
                    chain.doFilter(getParameterTrimmedHttpServletRequest(
                            httpServletRequest), response);
                } else {
                    chain.doFilter(request, response);
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    /**
     * ̃T[ubgtB^jB
     * 
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy() {
        this.trimPattern = null;
    }

    /**
     * HttpServletRequestParameterTrimmedHttpServletRequest\zĕԂB
     * 
     * @param request
     *          NGXg
     * 
     * @return ParameterTrimmedHttpServletRequest
     */
    protected HttpServletRequest getParameterTrimmedHttpServletRequest(
            HttpServletRequest request) {
        return new ParameterTrimmedHttpServletRequest(request, 
            this.trimPattern);
    }
}
