/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.pagelink.service;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.thin.functionsample.pagelink.bean.AddressBean;
import jp.terasoluna.thin.functionsample.pagelink.bean.UserBean;
import jp.terasoluna.fw.dao.QueryDAO;

/**
 * ꗗ擾rWlXWbNB
 *
 * f[^x[Xʂɕ\錏݈̂ꗗ擾B
 * ܂Aꗗ̑S擾B
 *
 */
public class ListServiceImpl implements ListService {

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    protected QueryDAO dao = null;

    /**
     * QueryDAOԋpB
     *
     * @return ێQueryDAO
     */
    public QueryDAO getDao() {
        return dao;
    }

    /**
     * QueryDAOݒ肷B
     *
     * @param dao QueryDAO
     */
    public void setDao(QueryDAO dao) {
        this.dao = dao;
    }

    /**
     * f[^x[Xꗗ擾B
     * 1y[W̕\ƊJnCfbNX擾AQueryDAOɓnB
     * ܂Aꗗ̑S擾ԋpB
     *
     * @param map \AJnCfbNXێMap
     * @return ꗗASێMap
     */
    public Map<String, Object> getUserList(Map<String, String> map) {

        String strIndex1 = map.get("startIndex1");
        String strRow1 = map.get("row1");
        String strIndex2 = map.get("startIndex2");
        String strRow2 = map.get("row2");
        
        int startIndex1 = 0;
        int row1 = 10;
        if (strIndex1 != null) {
            try {
                startIndex1 = Integer.parseInt(strIndex1);
            } catch (NumberFormatException e) {
                startIndex1 = 0;
            }
        }
        if (strRow1 != null) {
            try {
                row1 = Integer.parseInt(strRow1);
            } catch (NumberFormatException e) {
                row1 = 10;
            }
        }
        int startIndex2 = 0;
        int row2 = 7;
        if (strIndex2 != null) {
            try {
                startIndex2 = Integer.parseInt(strIndex2);
            } catch (NumberFormatException e) {
                startIndex2 = 0;
            }
        }
        if (strRow2 != null) {
            try {
                row2 = Integer.parseInt(strRow2);
            } catch (NumberFormatException e) {
                row2 = 7;
            }
        }
        UserBean[] bean1 = dao.executeForObjectArray(
                "pageLink.selectUserList", null,
                UserBean.class, startIndex1, row1);

        Map<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("totalCount1", getUserCount());
        retMap.put("userBeans1", bean1);
        AddressBean[] bean2 = dao.executeForObjectArray(
                "pageLink.selectAddressList", null,
                AddressBean.class, startIndex2, row2);

        retMap.put("totalCount2", getAddressCount());
        retMap.put("userBeans2", bean2);
        
        retMap.put("startIndex1", strIndex1);
        retMap.put("startIndex2", strIndex2);
        return retMap;

    }

    /**
     * ꗗ̑S擾ĕԋpB
     *
     * @return 擾
     */
    private String getUserCount() {

        String count
            = dao.executeForObject("pageLink.selectUserCount", null, String.class);
        if (count == null || "".equals(count)) {
            count = "0";
        }
        return count;
    }

    /**
     * ꗗ̑S擾ĕԋpB
     *
     * @return 擾
     */
    private String getAddressCount() {

        String count
            = dao.executeForObject("pageLink.selectAddressCount", null, String.class);
        if (count == null || "".equals(count)) {
            count = "0";
        }
        return count;
    }
}