/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.util.FileUtility;

public class FastFileUtility
extends FileUtility {
    public static void copyFile(String srcFile, String newFile) {
        if (srcFile == null) {
            throw new FileException("srcFile is null.");
        }
        if (newFile == null) {
            throw new FileException("newFile is null.");
        }
        File srcFileObject = new File(srcFile);
        if (!srcFileObject.exists()) {
            throw new FileException(srcFile + " is not exist.");
        }
        File outputFileObject = new File(newFile);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel ic = null;
        FileChannel oc = null;
        try {
            try {
                fis = new FileInputStream(srcFileObject);
                fos = new FileOutputStream(outputFileObject);
                ic = fis.getChannel();
                oc = fos.getChannel();
                ic.transferTo(0L, ic.size(), oc);
            }
            catch (IOException e) {
                throw new FileException("File control operation was failed.", (Exception)e);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            FastFileUtility.closeQuietly(oc);
            FastFileUtility.closeQuietly(ic);
            FastFileUtility.closeQuietly(fos);
            FastFileUtility.closeQuietly(fis);
            throw throwable;
        }
        FastFileUtility.closeQuietly(oc);
        FastFileUtility.closeQuietly(ic);
        FastFileUtility.closeQuietly(fos);
        FastFileUtility.closeQuietly(fis);
    }

    public static void closeQuietly(Channel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(FileInputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(FileOutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

