/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector;

import java.beans.Introspector;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.CollectorThreadFactory;
import jp.terasoluna.fw.collector.concurrent.ArrayBlockingQueueEx;
import jp.terasoluna.fw.collector.concurrent.NotificationBlockingQueue;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandlerStatus;
import jp.terasoluna.fw.collector.validate.ValidateErrorStatus;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.collector.vo.CollectorStatus;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.logger.TLogger;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollector<P>
implements Collector<P>,
Closeable,
Callable<Integer>,
Cloneable {
    private static final TLogger LOGGER = TLogger.getLogger(AbstractCollector.class);
    public static final int DEFAULT_QUEUE_SIZE = 20;
    protected static final int DEFAULT_SLEEP_WAIT = 1;
    protected static final int CURRENT_QUEUE_CHECK_SIZE = 1;
    protected static final int PREVIOUS_QUEUE_CHECK_SIZE = 2;
    protected static AtomicBoolean verboseLog = new AtomicBoolean(false);
    protected int queueSize = 20;
    protected int sleepWait = 1;
    protected BlockingQueue<DataValueObject> queue = null;
    protected Queue<DataValueObject> currentQueue = null;
    protected Queue<DataValueObject> previousQueue = null;
    protected volatile Future<?> fo = null;
    protected volatile boolean finish = false;
    protected volatile boolean beginning = false;
    protected Validator validator = null;
    protected ValidationErrorHandler validationErrorHandler = null;
    protected CollectorExceptionHandler exceptionHandler = null;
    protected AbstractCollector<?> child = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        if (this.beginning) {
            return;
        }
        AbstractCollector abstractCollector = this;
        synchronized (abstractCollector) {
            if (!this.beginning) {
                block17: {
                    try {
                        this.beforeExecute();
                        if (this.queue == null) {
                            this.queue = this.createQueue();
                        }
                        if (this.fo != null) break block17;
                        Callable callable = null;
                        try {
                            callable = (Callable)this.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            SystemException exception = new SystemException((Throwable)e);
                            exception.setMessage("The clone cannot be made.");
                            throw exception;
                        }
                        if (callable instanceof AbstractCollector) {
                            this.child = (AbstractCollector)callable;
                        }
                        ExecutorService ex = this.getExecutor();
                        try {
                            this.fo = ex.submit(callable);
                        }
                        catch (Throwable e) {
                            SystemException exception = new SystemException(e);
                            exception.setMessage("The thread cannot be started.");
                            throw exception;
                        }
                        finally {
                            ex.shutdown();
                        }
                    }
                    finally {
                        this.afterExecute();
                    }
                }
                this.beginning = true;
            }
        }
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    @Override
    public boolean hasNext() {
        return this.getNextObject() != null;
    }

    @Override
    public P next() {
        this.execute();
        DataValueObject nextValue = this.getNextObject();
        if (nextValue != null) {
            if (this.previousQueue != null) {
                while (this.previousQueue.size() > 2) {
                    this.previousQueue.remove();
                }
                this.previousQueue.add(nextValue);
            }
            if (this.currentQueue != null) {
                while (this.currentQueue.size() > 1) {
                    this.currentQueue.remove();
                }
                this.currentQueue.add(nextValue);
            }
        } else {
            if (verboseLog.get() && LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL041007", new Object[]{this.queue.size()});
            }
            this.setFinish(true);
            this.close();
            throw new NoSuchElementException();
        }
        try {
            this.queue.poll(this.sleepWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("WAL041003", (Throwable)e);
        }
        if (nextValue.getThrowable() != null) {
            Throwable throwable = nextValue.getThrowable();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new SystemException(throwable);
        }
        return (P)nextValue.getValue();
    }

    @Override
    public P getNext() {
        DataValueObject value = this.getNextObject();
        if (value == null) {
            return null;
        }
        if (value.getValue() == null) {
            if (value.getThrowable() != null) {
                Throwable throwable = value.getThrowable();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new SystemException(throwable);
            }
            return null;
        }
        return (P)value.getValue();
    }

    protected DataValueObject getNextObject() {
        this.execute();
        DataValueObject value = null;
        do {
            ValidateErrorStatus validateStatus;
            if (this.queue != null) {
                value = (DataValueObject)this.queue.peek();
            }
            if (this.isFinish() && this.queue.isEmpty()) {
                if (!verboseLog.get() || !LOGGER.isTraceEnabled()) break;
                LOGGER.trace("TAL041014");
                break;
            }
            if (value != null && value.getValidateStatus() != null && ValidateErrorStatus.END.equals((Object)(validateStatus = value.getValidateStatus()))) {
                return null;
            }
            CollectorExceptionHandlerStatus es = null;
            if (value != null && value.getThrowable() != null) {
                try {
                    es = this.handleException(value);
                }
                catch (Throwable e) {
                    LOGGER.warn("WAL041004", e);
                }
                if (es == null || CollectorExceptionHandlerStatus.THROW.equals((Object)es)) break;
                if (CollectorExceptionHandlerStatus.SKIP.equals((Object)es)) {
                    this.queue.poll();
                    value = null;
                    continue;
                }
                if (CollectorExceptionHandlerStatus.END.equals((Object)es)) {
                    return null;
                }
            }
            if (value != null && CollectorStatus.END.equals((Object)value.getCollectorStatus())) {
                this.setFinish(true);
                return null;
            }
            if (value != null) continue;
            try {
                if (verboseLog.get() && LOGGER.isTraceEnabled()) {
                    LOGGER.trace("TAL041019", new Object[]{this.sleepWait});
                }
                Thread.sleep(this.sleepWait);
            }
            catch (InterruptedException e) {
                LOGGER.warn("WAL041003", (Throwable)e);
                break;
            }
            if (!verboseLog.get() || !LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("TAL041008", new Object[]{this.queue.size()});
        } while (value == null);
        return value;
    }

    @Override
    public P getPrevious() {
        DataValueObject value = this.getPreviousObject();
        if (value == null) {
            return null;
        }
        if (value.getValue() == null) {
            if (value.getThrowable() != null) {
                Throwable throwable = value.getThrowable();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new SystemException(throwable);
            }
            return null;
        }
        return (P)value.getValue();
    }

    protected DataValueObject getPreviousObject() {
        this.execute();
        DataValueObject value = null;
        if (this.previousQueue != null && this.previousQueue.size() > 1) {
            while (this.previousQueue.size() > 2) {
                this.previousQueue.remove();
            }
            value = this.previousQueue.peek();
        }
        return value;
    }

    @Override
    public P getCurrent() {
        this.execute();
        DataValueObject value = this.getCurrentObject();
        if (value == null) {
            return null;
        }
        if (value.getValue() == null) {
            if (value.getThrowable() != null) {
                Throwable throwable = value.getThrowable();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new SystemException(throwable);
            }
            return null;
        }
        return (P)value.getValue();
    }

    protected DataValueObject getCurrentObject() {
        this.execute();
        DataValueObject value = null;
        if (this.currentQueue != null && this.currentQueue.size() > 0) {
            while (this.currentQueue.size() > 1) {
                this.currentQueue.remove();
            }
            value = this.currentQueue.peek();
        }
        return value;
    }

    @Override
    public void close() {
        if (!this.isFinish() && this.fo != null) {
            this.fo.cancel(true);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void finalize() throws Throwable {
        if (verboseLog.get() && LOGGER.isTraceEnabled()) {
            LOGGER.trace("TAL041011", new Object[]{Thread.currentThread().getName()});
        }
        if (!this.isFinish() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("WAL041005", new Object[]{Thread.currentThread().getName()});
        }
        super.finalize();
    }

    @Override
    public Iterator<P> iterator() {
        return this;
    }

    protected ExecutorService getExecutor() {
        return Executors.newSingleThreadExecutor(this.createThreadFactory());
    }

    protected ThreadFactory createThreadFactory() {
        return new CollectorThreadFactory();
    }

    protected BlockingQueue<DataValueObject> createQueue() {
        if (this.currentQueue == null) {
            this.currentQueue = this.createCurrentQueue();
        }
        if (this.previousQueue == null) {
            this.previousQueue = this.createPreviousQueue();
        }
        return new ArrayBlockingQueueEx<DataValueObject>(this.queueSize);
    }

    protected Queue<DataValueObject> createCurrentQueue() {
        return new ConcurrentLinkedQueue<DataValueObject>();
    }

    protected Queue<DataValueObject> createPreviousQueue() {
        return new ConcurrentLinkedQueue<DataValueObject>();
    }

    protected Queue<DataValueObject> getQueue() {
        return this.queue;
    }

    protected void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    protected int getSleepWait() {
        return this.sleepWait;
    }

    protected void setSleepWait(int sleepWait) {
        this.sleepWait = sleepWait;
    }

    protected void addQueue(DataValueObject dataValueObject) throws InterruptedException {
        this.addQueue(dataValueObject, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addQueue(DataValueObject dataValueObject, boolean force) throws InterruptedException {
        if (force && this.queue != null) {
            this.queue.offer(dataValueObject);
            return;
        }
        boolean finish = this.isFinish();
        if (!finish) {
            ValidateErrorStatus vs = null;
            if (this.validator != null) {
                try {
                    vs = this.validate(dataValueObject);
                }
                catch (Throwable e) {
                    if (dataValueObject == null) {
                        this.queue.put(new DataValueObject(e));
                        return;
                    }
                    dataValueObject.setThrowable(e);
                    this.queue.put(dataValueObject);
                    return;
                }
            }
            if (vs == null || ValidateErrorStatus.CONTINUE.equals((Object)vs)) {
                this.queue.put(dataValueObject);
                return;
            }
            if (ValidateErrorStatus.END.equals((Object)vs)) {
                DataValueObject errorStop = new DataValueObject(vs);
                this.queue.put(errorStop);
                this.setFinish(true);
                return;
            }
            if (!ValidateErrorStatus.SKIP.equals((Object)vs)) return;
            return;
        }
        if (!LOGGER.isTraceEnabled()) throw new InterruptedException("The stop demand of the thread is carried out.");
        long dc = -1L;
        if (dataValueObject != null) {
            dc = dataValueObject.getDataCount();
        }
        LOGGER.trace("TAL041013", new Object[]{finish, "", dc});
        throw new InterruptedException("The stop demand of the thread is carried out.");
    }

    protected ValidateErrorStatus validate(DataValueObject dataValueObject) {
        ValidateErrorStatus vs = ValidateErrorStatus.CONTINUE;
        if (this.validator != null) {
            Class<?> clazz = null;
            String objectName = null;
            BindException errors = null;
            if (dataValueObject != null && dataValueObject.getValue() != null && (clazz = dataValueObject.getValue().getClass()) != null && (objectName = clazz.getSimpleName()) != null) {
                objectName = Introspector.decapitalize(objectName);
                errors = new BindException(dataValueObject.getValue(), objectName);
            }
            if (clazz != null && errors != null && this.validator.supports(clazz)) {
                this.validator.validate(dataValueObject.getValue(), errors);
                if (errors.hasErrors()) {
                    vs = this.handleValidationError(dataValueObject, (Errors)errors);
                }
            }
        }
        return vs;
    }

    protected ValidateErrorStatus handleValidationError(DataValueObject dataValueObject, Errors errors) {
        if (this.validationErrorHandler != null) {
            return this.validationErrorHandler.handleValidationError(dataValueObject, errors);
        }
        return ValidateErrorStatus.SKIP;
    }

    protected CollectorExceptionHandlerStatus handleException(DataValueObject dataValueObject) {
        CollectorExceptionHandlerStatus result = dataValueObject.getExceptionHandlerStatus();
        if (result != null) {
            return result;
        }
        if (this.exceptionHandler != null) {
            result = this.exceptionHandler.handleException(dataValueObject);
            dataValueObject.setExceptionHandlerStatus(result);
        }
        return result;
    }

    protected boolean isFinish() {
        boolean finish = this.finish;
        AbstractCollector<?> localChild = this.child;
        Future<?> future = this.fo;
        if (future != null) {
            boolean done = future.isDone();
            if (localChild != null && localChild.isFinish()) {
                finish = localChild.isFinish();
            }
            return finish || done;
        }
        if (localChild != null && localChild.isFinish()) {
            finish = localChild.isFinish();
        }
        return finish;
    }

    protected void setFinish() {
        block4: {
            if (verboseLog.get() && LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL041012", new Object[]{Thread.currentThread().getName()});
            }
            this.setFinish(true);
            try {
                this.addQueue(new DataValueObject(CollectorStatus.END), true);
            }
            catch (InterruptedException ie) {
                if (!LOGGER.isTraceEnabled()) break block4;
                LOGGER.trace("TAL041012", (Throwable)ie, new Object[]{Thread.currentThread().getName()});
            }
        }
        if (this.queue instanceof NotificationBlockingQueue) {
            ((NotificationBlockingQueue)this.queue).finishQueueing();
        }
    }

    protected void setFinish(boolean finish) {
        this.finish = finish;
    }

    public static void closeQuietly(Collector<?> collector) {
        try {
            if (collector != null) {
                collector.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setVerbose(boolean verbose) {
        verboseLog.set(verbose);
    }
}

