/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import jp.terasoluna.fw.collector.concurrent.NotificationBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBlockingQueueEx<E>
extends ArrayBlockingQueue<E>
implements NotificationBlockingQueue<E> {
    private static final long serialVersionUID = 7441765139909417804L;
    protected final ReentrantLock queueLock = new ReentrantLock();
    protected final Condition notEmpty = this.queueLock.newCondition();
    protected final Condition notFull = this.queueLock.newCondition();
    protected final int capacity;
    protected volatile boolean finishQueueingFlag = false;

    public ArrayBlockingQueueEx(int capacity, boolean fair) {
        super(capacity, fair);
        this.capacity = capacity;
    }

    public ArrayBlockingQueueEx(int capacity) {
        super(capacity);
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishQueueing() {
        this.queueLock.lock();
        try {
            this.finishQueueingFlag = true;
            this.notEmpty.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        if (o == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        this.queueLock.lockInterruptibly();
        try {
            while (this.size() == this.capacity) {
                if ((nanos = this.notFull.awaitNanos(nanos)) > 0L) continue;
                boolean bl = false;
                return bl;
            }
            boolean success = super.offer(o);
            if (success) {
                this.notEmpty.signal();
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o) {
        this.queueLock.lock();
        try {
            if (this.size() == this.capacity) {
                boolean bl = false;
                return bl;
            }
            boolean success = super.offer(o);
            if (success) {
                this.notEmpty.signal();
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E o) throws InterruptedException {
        if (o == null) {
            throw new NullPointerException();
        }
        this.queueLock.lock();
        try {
            while (this.size() == this.capacity) {
                this.notFull.await();
            }
            super.put(o);
            this.notEmpty.signal();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        this.queueLock.lock();
        try {
            while (!this.finishQueueingFlag && this.size() == 0) {
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException e) {
                    E e2 = null;
                    this.queueLock.unlock();
                    return e2;
                }
            }
            Object e = super.peek();
            return e;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.queueLock.lock();
        try {
            while (!this.finishQueueingFlag && this.size() == 0) {
                if ((nanos = this.notEmpty.awaitNanos(nanos)) > 0L) continue;
                E e = null;
                return e;
            }
            if (this.finishQueueingFlag && this.size() == 0) {
                E e = null;
                return e;
            }
            Object elm = super.poll(timeout, unit);
            if (elm != null) {
                this.notFull.signal();
            }
            Object e = elm;
            return e;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        this.queueLock.lock();
        try {
            Object elm = super.poll();
            if (elm != null) {
                this.notFull.signal();
            }
            Object e = elm;
            return e;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.queueLock.lock();
        try {
            while (!this.finishQueueingFlag && this.size() == 0) {
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException e) {
                    boolean bl = true;
                    this.queueLock.unlock();
                    return bl;
                }
            }
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }
}

