/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.file;

import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.file.FileCollector;
import jp.terasoluna.fw.collector.file.FileCollectorConfig;
import jp.terasoluna.fw.collector.validate.ExceptionValidationErrorHandler;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.file.dao.FileQueryDAO;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileValidateCollector<P>
extends FileCollector<P> {
    public FileValidateCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz, Validator validator) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz).addValidator(validator));
    }

    public FileValidateCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz, Validator validator, ValidationErrorHandler validationErrorHandler) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz).addValidator(validator).addValidationErrorHandler(validationErrorHandler));
    }

    public FileValidateCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz, CollectorExceptionHandler exceptionHandler, Validator validator) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz).addExceptionHandler(exceptionHandler).addValidator(validator));
    }

    public FileValidateCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz, CollectorExceptionHandler exceptionHandler, Validator validator, ValidationErrorHandler validationErrorHandler) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz).addExceptionHandler(exceptionHandler).addValidator(validator).addValidationErrorHandler(validationErrorHandler));
    }

    public FileValidateCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz, int queueSize, CollectorExceptionHandler exceptionHandler, Validator validator) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz).addQueueSize(queueSize).addExceptionHandler(exceptionHandler).addValidator(validator));
    }

    public FileValidateCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz, int queueSize, CollectorExceptionHandler exceptionHandler, Validator validator, ValidationErrorHandler validationErrorHandler) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz).addQueueSize(queueSize).addExceptionHandler(exceptionHandler).addValidator(validator).addValidationErrorHandler(validationErrorHandler));
    }

    public FileValidateCollector(FileCollectorConfig<P> config) {
        if (config == null) {
            throw new IllegalArgumentException("The parameter is null.");
        }
        this.fileQueryDAO = config.getFileQueryDAO();
        this.fileName = config.getFileName();
        this.clazz = config.getClazz();
        if (config.getQueueSize() > 0) {
            this.setQueueSize(config.getQueueSize());
        }
        this.validator = config.getValidator();
        if (config.getValidator() != null) {
            this.validationErrorHandler = config.getValidationErrorHandler() != null ? config.getValidationErrorHandler() : new ExceptionValidationErrorHandler();
        }
        this.exceptionHandler = config.getExceptionHandler();
        if (config.isExecuteByConstructor()) {
            this.execute();
        }
    }
}

