/*
 * Copyright (c) 2014 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector.util.strategy;

import java.util.Comparator;

/**
 * CompareStrategyNX.<br>
 * OComparatorcompare\bhŔrXgeWB
 * compare\bh0ԂΓA0ȊOԂΓȂAƂʂɂȂB<br>
 * ̃NX́AComparatorCompareStrategyƂėp邽߂ɗpӂĂB<br>
 * Rg[uCN̂߂ɁAVKɔrWbNꍇ́A
 * ̃NXɗ^ComparatorVKɍ쐬̂ł͂ȂA
 * CompareStrategyNX쐬邱Ƃ𐄏B<br>
 * (CompareStrategyComparatorƈقȂA2̃IuWFNg̑召֌W߂dlsvB)<br>
 * ȂAOComparatorXe[gXł΁ÃNXXe[gXłB
 * ̂߁AOComparatorXe[gXł΁A
 * r̂тɊOComparator₱̃NX̃CX^X쐬ȂKv͖B
 * @see Comparator
 * @see CompareStrategy
 */
public class ComparatorCompareStrategy implements CompareStrategy<Object> {

    /**
     * OComparator.
     */
    @SuppressWarnings("rawtypes")
    private Comparator comparator = null;

    /**
     * RXgN^.
     * @param comparator 2̃IuWFNgrComparator
     */
    public ComparatorCompareStrategy(Comparator<?> comparator) {
        this.comparator = comparator;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public boolean equalsObjects(Object value1, Object value2) {
        return (comparator.compare(value1, value2) == 0);
    }
}
