#!/usr/bin/env ruby 
require 'xmlrpc/client'
# Author:: Sadahiko Hantani (garyohosu@gmail.com)
# Copyright:: Copyright (c) 2008 Sadahiko Hantani
# License::   Distributes under GPL
# 
# 藚
#- 0.01 2008/12/14 VK쐬
#- 0.02 2008/12/15 擪ɃoCiĂ̂ŏC
#- 0.03 2008/12/15 Rgǉ
#- 0.04 2008/12/16 getProjectID,getTestPlanID,getBuildIDōłrhID̑傫IDԂ悤ύX.getStatusByTCNameǉ
# 


class TestLinkClient
#
#=== Tv
#
# initialize
#
#=== 
#
#+server_url+::
# TestLink Server URL
#+dev_key+::
# Personal API access key 
#+api_path+::
# xmlrpc.php path (Option) 
#
#=== ߂l
#
# Ȃ
#
#=== O
#
#=== ڍ
#
#  TestLinkݒuT[o[URLPersonal API access keyݒ肵܂B
#  Personal API access key肷ɂ͈ȉsĂB
#  
#1. TestLinkconfig.inc.phpύX܂
#    /** SOAP API availability (disabled by default) */
#    $tlCfg->api_enabled = TRUE;
#2. user_api_key擾
#    TestLinkJuPersonalvJB
#    uGenerate a new keyv{^NbN
#    Personal API access key = xxxxxxxxxxxxxxxxxxxxxxxxxxxx
#
#=== 
#  client = TestLinkClient.new("http://foo.org/testlink_18RC1","413a5f43341axxxxxx91f166501740ec")
#
  def initialize(server_url,dev_key,api_path = "/lib/api/xmlrpc.php")
    @server = XMLRPC::Client.new2(server_url + api_path)
    @devKey = dev_key
  end


#
#=== Tv
#
# reportTCResult(tpid,tcid,status,bid,notes,guess)
#
#=== 
#
#+tpid+::
# eXgvID
#+tcid+::
# eXgP[XID
#+status+::
# eXg  p: f:s b:ubN
#+bid+::
# rhID(IvV)
#+notes+::
# m[g(IvV)
#+guess+::
# (IvV)
#
#=== ߂l
# 
# [{"message"=>"Success!", "status"=>true, "id"=>"2"}]
#
#=== O
#
#=== ڍ
#
# eXgʂo^
#
#  message:bZ[W
#  id:ID
#  status:true  false s
#
#=== 
#
# reportTCResult(tpid,bid,tcid,status) #=>[{"message"=>"Success!", "status"=>true, "id"=>"2"}]
#
  def reportTCResult(tpid,tcid,status,bid=nil,notes=nil,guess=nil)

    args = {"devKey"=>@devKey,"testcaseid"=>tcid.to_i,"testplanid"=>tpid,"status"=>status,"buildid"=>bid}

    if bid then
      args["buildid"] = bid
    end
    if notes then #string
      args["notes"] = notes
    end
    if guess then #bool
      args["guess"] = guess
    end
    ret = @server.call("tl.reportTCResult",args)
  end

#
#=== Tv
#
# getProjects
#
#=== 
#
# Ȃ
#
#=== ߂l
#
# ݂̃eXgvWFNg񂪕Ԃ܂
# 
#[{"name"=>"project", "prefix"=>"test", "tc_counter"=>"15", "option_automation"=>"1", "option_priority"=>"1", "notes"=>"", "id"=>"1", "color"=>"", "option_reqs"=>"1", "active"=>"0"}, {"name"=>"testproject2", "prefix"=>"tp2", "tc_counter"=>"6", "option_automation"=>"1", "option_priority"=>"1", "notes"=>"<p>comment</p>","id"=>"35", "color"=>"", "option_reqs"=>"1", "active"=>"1"}]
#
#=== ڍ
#
# vWFNgɈȉ̒l𓾂邱Ƃł܂
#
# name:eXgvWFNg
# prefix:vtBbNX
# tc_counter:eXgP[X
# option_automation:automationgp邩
# option_priority:Dxgp邩
# notes:m[g
# id:eXgvWFNgID
# color:
# option_reqs:vǗgp邩
# active:ANeBuvWFNg
#
#=== 
# getProjects #=>[{"name"=>"project", "prefix"=>"test", "tc_counter"=>"15", "option_automation"=>"1", "option_priority"=>"1", "notes"=>"", "id"=>"1", "color"=>"", "option_reqs"=>"1", "active"=>"0"}]
#
  def getProjects
    args = {"devKey"=>@devKey}
    ret = @server.call("tl.getProjects",args)
  end

#
#=== Tv
#
# getProjectTestPlans(pid)
#
#=== 
#
#+pid+::
# eXgvWFNgID
#
#=== ߂l
# 
# [{"3"=>{"name"=>"test plan", "notes"=>"note", "id"=>"3", "testproject_id"=>"1", "active"=>"1"}}]
#
#=== O
#
#=== ڍ
#
# eXgvWFNgIDnƃeXgv̏ڍ׏Ԃ
#
#  -   :eXgvID
#  name:eXgv於
#  notes:m[g
#  id:ID
#  testproject_id:eXgvWFNgID
#  active:ANeBu
#
#=== 
#
# getProjectTestPlans(pid) #=>[{"3"=>{"name"=>"test plan", "notes"=>"note", "id"=>"3", "testproject_id"=>"1", "active"=>"1"}}]
#
  def getProjectTestPlans(pid)
    args = {"devKey"=>@devKey,"testprojectid"=>pid}     
    ret = @server.call("tl.getProjectTestPlans",args)
  end


#
#=== Tv
#
# createBuild(testplanid,buildname,buildnotes)
#
#=== 
#
#+testplanid+::
# eXgvID
#+buildname+::
# rh
#+buildnotes+::
# rhm[g
#
#=== ߂l
# 
# [{"message"=>"Success!", "status"=>true, "id"=>"4"}]
#
#=== O
#
#=== ڍ
#
# eXgvWFNgID,rhArhm[gnƐVKrh𐶐
#  -   :rhID
#  name:rh
#  notes:m[g
#  id:rhID
#  testproject_id:eXgvWFNgID
#  active:ANeBuH
#
#=== 
#
# createBuild(testplanid,buildname,buildnotes) #=>[{"message"=>"Success!", "status"=>true, "id"=>"2"}]
#
  def createBuild(testplanid,buildname,buildnotes)
    args = {"devKey"=>@devKey,"testplanid"=>testplanid,"buildname"=>buildname,"buildnotes"=>buildnotes}     
    ret = @server.call("tl.createBuild",args)
  end

#
#=== Tv
#
# getBuildsForTestPlan(tpid)
#
#=== 
#
#+tpid+::
# eXgvID
#
#=== ߂l
# 
# [{"name"=>"build1", "notes"=>"", "id"=>"1", "is_open"=>"1", "testplan_id"=>"3", "active"=>"1"}]
#
#=== O
#
#=== ڍ
#
# eXgvIDnƃrh̏ڍ׏Ԃ
#  name:rh
#  notes:m[g
#  id:ID
#  is_open:I[vH
#  testplan_id:eXgvID
#  active:ANeBu
#
#=== 
#
# getBuildsForTestPlan(tpid) #=>[{"name"=>"build1", "notes"=>"", "id"=>"1", "is_open"=>"1", "testplan_id"=>"3", "active"=>"1"}]
#
  def getBuildsForTestPlan(tpid)
    args = {"devKey"=>@devKey,"testplanid"=>tpid}     
    ret = @server.call("tl.getBuildsForTestPlan",args)
  end  

#
#=== Tv
#
# getTestSuitesForTestPlan(tpid)
#
#=== 
#
#+tpid+::
# eXgvID
#
#=== ߂l
# 
# {"name"=>"testsuite1", "id"=>"36"}
#
#=== O
#
#=== ڍ
#
# eXgvIDnƃeXgXC[g̏ڍ׏Ԃ
#  name:eXgXC[g
#  id:ID
#
#=== 
#
# getTestSuitesForTestPlan(tpid) #=>{"name"=>"testsuite1", "id"=>"36"}
#
  def getTestSuitesForTestPlan(tpid)
    args = {"devKey"=>@devKey,"testplanid"=>tpid}     
    ret = @server.call("tl.getTestSuitesForTestPlan",args)
  end  
#
#=== Tv
#
# getTestCasesForTestSuite(tsid)
#
#=== 
#
#+tsid+::
# eXgXC[gID
#+deep+::
# ċAIs(IvV) ftHgTrue
#
#=== ߂l
# 
# {"name"=>"testsuite1", "id"=>"36"}
#
#=== O
#
#=== ڍ
#
# eXgXC[gIDnƃeXgP[X̏ڍ׏Ԃ
#  name:eXgP[X
#  id:eXgP[XID
#  node_type_id:
#  parent_id:
#  node_order:
#
#=== 
#
# getTestCasesForTestSuite(tsid) #=>{"name"=>"testsuite1", "id"=>"36"}
#
  def getTestCasesForTestSuite(ts,deep=nil)
    args = {"devKey"=>@devKey,"testsuiteid"=>ts}

    if deep then #
      args["deep"] = deep
    end

    ret = @server.call("tl.getTestCasesForTestSuite",args)
  end  

#
#=== Tv
#
# getTestCasesForTestPlan(tpid,tcid,bldid,keyid,execid,assignedto,executestatus)
#
#=== 
#
#+tpid+::eXgvID
#+tcid+::eXgP[XIDiIvVj
#+bldid+::rhIDiIvVj
#+keyid+::L[IDiIvVj
#+executed+::iIvVj
#+assignedto+::iIvVj
#+executestatus+::iIvVj
#
#=== ߂l
# 
#{"45"=>{"exec_status"=>"n", "status"=>"", "name"=>"testcase1", "assigner_id"=>"", "urgency"=>"2", "exec_id"=>"", "type"=>"", "exec_on_tplan"=>"", "executed"=>"", "external_id"=>"4", "z"=>"100", "tc_id"=>"45", "version"=>"1", "tcversion_id"=>"46", "execution_order"=>"40", "user_id"=>"", "feature_id"=>"19", "tcversion_number"=>"", "testsuite_id"=>"44", "active"=>"1"}, "41"=>{"exec_status"=>"p", "status"=>"", "name"=>"testcase3", "assigner_id"=>"", "urgency"=>"2", "exec_id"=>"42", "type"=>"", "exec_on_tplan"=>"43", "executed"=>"42", "external_id"=>"3", "z"=>"100", "tc_id"=>"41", "version"=>"1", "tcversion_id"=>"42", "execution_order"=>"30", "user_id"=>"", "feature_id"=>"18", "tcversion_number"=>"1", "testsuite_id"=>"36", "active"=>"1"}}
#=== O
#
#=== ڍ
#
# eXgvIDnƃeXgP[X̏ڍ׏Ԃ
#  -   :eXgP[XID
#  exec_status:s p or f or b
#  status:
#  name:eXgP[X
#  assigner_id:
#  urgency:
#  exec_id:
#  type:
#  exec_on_tplan:
#  executed:
#  external_id:
#  z:
#  tc_id:eXgP[XID
#  version:eXgP[Xo[W
#  tcversion_id:eXgP[Xo[WID
#  execution_order:
#  user_id:
#  feature_id:
#  tcversion_number:
#  testsuite_id:eXgXC[gID
#  active:ANeBuH
#
#=== 
#
# getTestCasesForTestPlan(tpid) #=>{"45"=>{"exec_status"=>"n", "status"=>"", "name"=>"testcase1", "assigner_id"=>"", "urgency"=>"2", "exec_id"=>"", "type"=>"", "exec_on_tplan"=>"", "executed"=>"", "external_id"=>"4", "z"=>"100", "tc_id"=>"45", "version"=>"1", "tcversion_id"=>"46", "execution_order"=>"40", "user_id"=>"", "feature_id"=>"19", "tcversion_number"=>"", "testsuite_id"=>"44", "active"=>"1"}, "41"=>{"exec_status"=>"p", "status"=>"", "name"=>"testcase3", "assigner_id"=>"", "urgency"=>"2", "exec_id"=>"42", "type"=>"", "exec_on_tplan"=>"43", "executed"=>"42", "external_id"=>"3", "z"=>"100", "tc_id"=>"41", "version"=>"1", "tcversion_id"=>"42", "execution_order"=>"30", "user_id"=>"", "feature_id"=>"18", "tcversion_number"=>"1", "testsuite_id"=>"36", "active"=>"1"}}
#
  def getTestCasesForTestPlan(tpid,tcid=nil,bldid=nil,keyid=nil,executed=nil,assignedto=nil,executestatus=nil)
    args = {"devKey"=>@devKey,"testplanid"=>tpid}
    if tcid then
      args["testcaseid"] = tcid
    end
    if bldid then
      args["buildid"] = bldid
    end
    if keyid then
      args["keywordid"] = keyid
    end
    if executed then #boolean
      args["executed"] = executed
    end
    if assignedto then
      args["assignedto"] = assignedto
    end
    if executestatus then #string
      args["executestatus"] = executestatus
    end
    ret = @server.call("tl.getTestCasesForTestPlan",args)
  end  


#
#=== Tv
#
# getTestCaseIDByName(testcasename,testsuitename)
#
#=== 
#
#+testcasename+::
# eXgP[X
#+testsuitename+::
# eXgXC[g(IvV)
#
#=== ߂l
# 
# {"name"=>"testsuite1", "id"=>"36"}
#
#=== O
#
#=== ڍ
#
# eXgP[XAeXgXC[gnƃeXgP[XIDԂ
#  name:eXgP[X
#  id:eXgP[XID
#
#=== 
#
# getTestCaseIDByName(tsid) #=>[{"name"=>"testcase1", "id"=>"37"}]
#
  def getTestCaseIDByName(testcasename,testsuitename = nil)
    args = {"devKey"=>@devKey,"testcasename"=>testcasename}

    if testsuitename then
	    args["testsuitename"] = testsuitename
    end

    ret = @server.call("tl.getTestCaseIDByName",args)
  end  
#
#=== Tv
#
# createTestCase()
#
#=== 
#
#=== ߂l
#
#=== O
#
#=== ڍ
#
# eXgP[X쐬()
#
#=== 
#
# createTestCase() #=>
#
  def createTestCase()#
    args = {"devKey"=>@devKey}
    ret = @server.call("tl.createTestCase",args)
  end
#
#=== Tv
#
# createTestProject()
#
#=== 
#
#=== ߂l
#
#=== O
#
#=== ڍ
#
# eXgvWFNg쐬((s))
#
#=== 
#
# createTestProject() #=>
#
  def createTestProject()#s
    args = {"devKey"=>@devKey}
    ret = @server.call("tl.createTestProject",args)
  end  
#
#=== Tv
#
# getTestCaseCustomFieldDesignValue()
#
#=== 
#
#=== ߂l
#
#=== O
#
#=== ڍ
#
# JX^tB[h̒l𓾂(gp@s)
#
#=== 
#
# getTestCaseCustomFieldDesignValue() #=>
#
  def getTestCaseCustomFieldDesignValue()
    args = {"devKey"=>@devKey}
    ret = @server.call("tl.getTestCaseCustomFieldDesignValue",args)
  end  

#
#=== Tv
#
# about()
#
#=== 
#
#    Ȃ
#
#=== ߂l
#
# "Testlink API Version: 1.0 Beta 3 written by Asiel Brumfield\n contribution by TestLink development Team"
#
#=== O
#
#=== ڍ
#
# Testlink APȈ񂪕Ԃ
#
#=== 
#
# about() #=>Testlink API Version: 1.0 Beta 3 written by Asiel Brumfield\n contribution by TestLink development Team
#
  def about
    ret = @server.call("tl.about")
  end

#
#=== Tv
#
# sayHello()
#
#=== 
#
#    Ȃ
#
#=== ߂l
#
# "Hello!"
#
#=== O
#
#=== ڍ
#
# "Hello!"Ԃ
# mFp
#
#=== 
#
# sayHello() #=>"Hello!"
#
  def sayHello
    ret = @server.call("tl.sayHello")
  end

#
#=== Tv
#
# repeat(message)
#
#=== 
#
#+message+::
# bZ[W
#
#=== ߂l
#
# "You said: xxxxx"
#
#=== O
#
#=== ڍ
#
# MbZ[WԂ
# mFp
#
#=== 
#
# repeat("message") #=>"You said: message"
#
#You said: message
  def repeat(message)
    args = {"str"=>message}
    ret = @server.call("tl.repeat",args)
  end


######################################
#
#  ȉƎ֐
#
######################################



#
#=== Tv
#
# getProjectID
#
#=== 
#
# Ȃ
#
#=== ߂l
#
# ł傫iŐV́jIDŃANeBuȃeXgvWFNgID
#  3
#
#=== ڍ
#
# ł傫iŐV́jIDŃANeBuȃeXgvWFNgIDԂ܂
#
#=== 
# getProjectID #=>3
#
  def getProjectID
    args = {"devKey"=>@devKey}
    ret = @server.call("tl.getProjects",args)
    val = ret.select{|x|x["active"]=="1"}.sort{|a,b|a["id"].to_i<=>b["id"].to_i}
    if not val.nil? then
        return val[-1]["id"]
    end
    raise "ProjectID error"
  end

#
#=== Tv
#
# getTestPlanID(pid)
#
#=== 
#
#+pid+::
# eXgvWFNgID
#
#=== ߂l
#
# ł傫iŐV́jIDŃANeBuȃeXgvID
#  3
#
#=== ڍ
#
# ł傫iŐV́jIDŃANeBuȃeXgvIDԂ܂
#
#=== 
# getTestPlanID(3) #=>4
#
  def getTestPlanID(pid)
    args = {"devKey"=>@devKey,"testprojectid"=>pid}
    ret = @server.call("tl.getProjectTestPlans",args)
    tpid=[]
    
    ret.each{|item|
      item.each{|key,val|
        tpid << key.to_i
      }
    }
    tpid.sort
    if tpid.size != 0 then
      return tpid[-1]
    end
    raise "TestPlanID error"
  end

#
#=== Tv
#
# getBuildID(tpid)
#
#=== 
#
#+tpid+::
# eXgvID
#
#=== ߂l
#
# ł傫iŐV́jIDŃANeBuŃI[vȃrhID
#  3
#
#=== ڍ
#
# ł傫iŐV́jIDŃANeBuŃI[vȃrhIDԂ܂
#
#=== 
# getBuildID(tpid) #=>4
#
  def getBuildID(tpid)
    args = {"devKey"=>@devKey,"testplanid"=>tpid}     
    ret = @server.call("tl.getBuildsForTestPlan",args)
    val = ret.select{|x|x["active"]=="1" and x["is_open"]=="1" }.sort{|a,b|a["id"].to_i<=>b["id"].to_i}
    if not val.nil? then
        return val[-1]["id"]
    end
    raise "BuildID error"
  end  

#
#=== Tv
#
# reportTCResultByTCName(testcasename,testsuitename,status,notes)
#
#=== 
#
#+testcasename+::
# eXgP[X
#+testsuitename+::
# eXgXC[g
#+status+::
#  eXg p: f:s b:ubN
#+notes+::
#  m[giIvVj
#
#=== ߂l
#
# EsԂ
#  [{"message"=>"Success!", "status"=>true, "id"=>"1638"}]
#
#=== ڍ
#
# eXgP[XyуeXgXC[gŎw肵eXgP[XɎʂo^
#
#=== 
# reportTCResultByTCName(testcasename,testsuitename,"p") #=>[{"message"=>"Success!", "status"=>true, "id"=>"1638"}]
#
  def reportTCResultByTCName(testcasename,testsuitename,status,notes=nil)
    pid = getProjectID
    tpid = getTestPlanID(pid)
    bid = getBuildID(tpid)
    ret = getTestCaseIDByName(testcasename,testsuitename)
    tcInfo = ret[0]
    tcid = tcInfo["id"]
    ret = reportTCResult(tpid,tcid,status,bid,notes)
  end


#
#=== Tv
#
# getStatusByTCName(testcasename,testsuitename)
#
#=== 
#
#+testcasename+::
# eXgP[X
#+testsuitename+::
# eXgXC[g
#
#=== ߂l
#
#  eXg p: f:s b:ubN Ԃ
#
#=== ڍ
#
# eXgP[XyуeXgXC[gŃeXgP[X̎ʂ𓾂
#
#=== 
# getStatusByTCName(testcasename,testsuitename,status) #=>"p"
#
  def getStatusByTCName(testcasename,testsuitename)
    pid = getProjectID
    tpid = getTestPlanID(pid)
    bid = getBuildID(tpid)
    ret = getTestCaseIDByName(testcasename,testsuitename)
    tcInfo = ret[0]
    tcid = tcInfo["id"]
    ret = getTestCasesForTestPlan(tpid,tcid)
    ret.each{|key,val|
      return val["exec_status"]
    }
  end
end
 
