#!/usr/bin/env ruby 

require 'rubygems'
require 'TestLinkClient'
require 'optparse'

Version="0.01"

def putsHelp
  puts "USAGE #{File::basename($0)} serverURL dev_key buildName"
  puts "-v:Version -h:help -t:time stamp"
end


isTimeStampOn=false
notes=""
OptionParser.new {|opt|
  opt.on('-c [OPTION]') {|v| notes = v }
  opt.on('-v') {|v| puts Version;exit(0)}
  opt.on('-h') {|v| putsHelp;exit(0)}
  opt.on('-t') {|v| isTimeStampOn = true}
  opt.parse!(ARGV)
}

SERVER_URL = 0
DEV_KEY = 1
BUILD_NAME = 2

if ARGV.size == BUILD_NAME + 1 then

  client = TestLinkClient.new(ARGV[SERVER_URL],ARGV[DEV_KEY])
  pid = client.getProjectID
  tpid = client.getTestPlanID(pid)

  buildname = ARGV[BUILD_NAME]
  if isTimeStampOn then
    day = Time.now
    buildname = buildname + day.to_s
  end

  ret = client.createBuild(tpid,buildname,notes)
  p ret

  if ret[0]["status"] == true then
    exit(0)
  else
    exit(1)
  end
else
  putsHelp
  exit(2)
end
