package com.torn.tetoru.sample.console;
import com.torn.tetoru.parts.Debug;
import com.torn.tetoru.template.Player;


public class MyConsolePlayer extends Player {

	private enum KeyMap {
		CH_DOWN('k', OP_DOWN),
		CH_RIGHT('l', OP_RIGHT),
		CH_LEFT('j', OP_LEFT),
		CH_ROTATE_RIGHT('a', OP_ROTATE_RIGHT),
		CH_ROTATE_LEFT('s', OP_ROTATE_LEFT),
		CH_START(' ', OP_START),
		CH_NO('*', OP_NO);

		/* ͂ꂽ̎ */
		private char code;
		/* ̎ */
		private int operate;

		private KeyMap(char code, int operate) {
			this.code = code;
			this.operate = operate;
		}
		/* ̕ɑΉKeyMap擾 */
		public static KeyMap getKey(char code) {
			for (KeyMap k : KeyMap.values()) {
				if (k.code == code) {
					return k;
				}
			}
			return CH_NO;
		}
		/* ̎ނ擾 */
		public int getOperate() {
			return operate;
		}
	}


	/* ͂ꂽ */
	private int inputType = OP_NO;


	MyConsolePlayer() {
		/* L[{[h͂󂯂R\[(NCg)N */
		new Thread(new MyConsolePlayerClient(this)).start();
	}


	/**
	 * ɏ
	 * @param code
	 */
	void writeInputType(byte code) {
		
		KeyMap k = KeyMap.getKey((char)code);
		inputType = k.getOperate();
		Debug.println("inputType:" + inputType);
	}


	/**
	 *  ̎ނǂݎ
	 */
	@Override
	public int readOperate() {
		int type = OP_NO;

		/* ͂ǂݎ */
		/* ͂Ȃꍇ́AOP_NO擾ł */
		type = inputType;

		/* ͏ */
		inputType = OP_NO;

		return type;
	}


	/**
	 * Q[Jn}҂
	 */
	@Override
	public boolean waitStartSign() {
		int retOperate = OP_NO;

		/* Jn͑҂ */
		while (OP_START != retOperate) {
			/* ͂҂ */
			try {
				Thread.sleep(20);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			
			retOperate = readOperate();
		}

		return true;
	}
}
